/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.timedio;

import com.sybase.jdbc3.jdbc.ErrorMessage;
import com.sybase.jdbc3.jdbc.SybProperty;
import com.sybase.jdbc3.timedio.Dbio;
import com.sybase.jdbc3.timedio.InStreamMgr;
import com.sybase.jdbc3.timedio.TDSTunnellingIS;
import com.sybase.jdbc3.timedio.TDSTunnellingOS;
import com.sybase.jdbc3.utils.Queue;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.sql.SQLException;

public class URLDbio
extends Dbio {
    private URL _urlNone = null;
    private URL _urlMore = null;
    private URL _urlPoll = null;
    private URL _urlClose = null;
    private URL _urlConnect = null;
    private URL _url = null;
    private String _protocol = null;
    private StringBuffer _file = null;
    private String _urlBase = null;
    protected String _tdsSessionID = null;
    private boolean _readRequested = false;
    private boolean _closing = false;
    private Queue _responses = null;
    private TDSTunnellingIS _ttis = null;
    private TDSTunnellingOS _ttos = null;
    public static final int NONE = 1;
    public static final int MORE = 2;
    public static final int POLL = 3;
    public static final int CLOSE = 4;
    public static final String TDS_SESSION = "Tds-Session";
    public static final String IGNORE_SESSION = "IGNORE";
    public static final String TDS_OPERATION = "Operation";
    public static final String TDS_TIMEOUT = "Timeout";
    public static final String OPERATION_POLL = "poll";
    public static final String OPERATION_MORE = "more";
    public static final String OPERATION_CLOSE = "close";
    public static final String HOST = "host";
    public static final String PORT = "port";

    protected URLDbio(String string, int n, InStreamMgr inStreamMgr, SybProperty sybProperty) throws SQLException {
        super(string, n, inStreamMgr, sybProperty);
        this._tdsSessionID = sybProperty.getString(20);
        if (this._tdsSessionID != null) {
            try {
                this.registerSessionId();
            }
            catch (IOException iOException) {
                ErrorMessage.raiseErrorCheckDead(iOException);
            }
            return;
        }
        int n2 = sybProperty.getInteger(19);
        this._file = new StringBuffer();
        this._file.append("?");
        this._file.append(HOST);
        this._file.append('=');
        this._file.append(string);
        this._file.append('&');
        this._file.append(PORT);
        this._file.append('=');
        this._file.append(n);
        this._file.append('&');
        this._file.append(TDS_OPERATION);
        this._file.append('=');
        this._file.append(OPERATION_MORE);
        if (n2 > 0) {
            this._file.append('&');
            this._file.append(TDS_TIMEOUT);
            this._file.append('=');
            this._file.append(n2 * 1000);
        }
    }

    public String getSessionID() {
        return this._tdsSessionID;
    }

    protected void closing() {
        this._closing = true;
    }

    protected synchronized void close() {
        while (!this._responses.empty()) {
            try {
                URLConnection uRLConnection = (URLConnection)this._responses.pop();
                InputStream inputStream = uRLConnection.getInputStream();
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        try {
            if (!this._closing) {
                this._ttos.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void doConnect(int n) throws IOException {
        if (this._tdsSessionID == null) {
            this._urlConnect = new URL(this._proxyHost + this._file);
        }
        this._ttis = new TDSTunnellingIS(this);
        this._in = this._ttis;
        this._ttos = new TDSTunnellingOS(this);
        this._out = this._ttos;
        this._responses = new Queue(4, 4);
    }

    protected int reallyRead(long l) throws IOException {
        int n = 0;
        n = this._ttis.read(this._bufIntv._buf, this._bufIntv._offset + this._bRead, this._bufIntv._length - this._bRead, l);
        return n;
    }

    protected void write(int n, byte[] byArray, int n2) throws IOException {
        Closeable closeable;
        switch (n) {
            case 1: {
                this._url = this._urlNone;
                break;
            }
            case 2: {
                this._url = this._urlMore;
                break;
            }
            case 3: {
                this._url = this._urlPoll;
                break;
            }
            case 4: {
                if (this._urlClose == null) {
                    return;
                }
                this._url = this._urlClose;
                break;
            }
        }
        if (this._closing) {
            this._url = this._urlClose;
        }
        if (this._url == null) {
            this._url = this._urlConnect;
        }
        URLConnection uRLConnection = this._url.openConnection();
        uRLConnection.setUseCaches(false);
        uRLConnection.setDoInput(true);
        uRLConnection.setRequestProperty("Connection", " Keep-Alive");
        if (n2 > 0) {
            uRLConnection.setDoOutput(true);
            closeable = uRLConnection.getOutputStream();
            ((OutputStream)closeable).write(byArray, 0, n2);
            ((OutputStream)closeable).flush();
        }
        if (n == 4) {
            closeable = uRLConnection.getInputStream();
            ((InputStream)closeable).close();
        } else {
            this._responses.push(uRLConnection);
        }
    }

    protected synchronized URLConnection getURLC(long l) throws IOException {
        URLConnection uRLConnection = null;
        while (uRLConnection == null) {
            uRLConnection = (URLConnection)this._responses.popNoEx();
            if (uRLConnection != null) continue;
            this._ttos.moreData(l);
        }
        String string = uRLConnection.getHeaderField(TDS_SESSION);
        if (string == null) {
            ErrorMessage.raiseIOException("JZ0T6");
        }
        if (string.equals(IGNORE_SESSION)) {
            InputStream inputStream = uRLConnection.getInputStream();
            inputStream.close();
            return this.getURLC(l);
        }
        if (this._tdsSessionID == null) {
            this._tdsSessionID = string;
            this.registerSessionId();
        }
        return uRLConnection;
    }

    private void registerSessionId() throws IOException {
        this._urlBase = "?Tds-Session=" + this._tdsSessionID;
        this._urlNone = new URL(this._proxyHost + this._urlBase);
        this._urlMore = new URL(this._proxyHost + this._urlBase + "&" + TDS_OPERATION + "=" + OPERATION_MORE);
        this._urlPoll = new URL(this._proxyHost + this._urlBase + "&" + TDS_OPERATION + "=" + OPERATION_POLL);
        this._urlClose = new URL(this._proxyHost + this._urlBase + "&" + TDS_OPERATION + "=" + OPERATION_CLOSE);
    }
}

