/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dbaccess;

import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.SymmCipherDesc;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.sql.SQLException;
import javax.crypto.Cipher;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class MsgSecurity {
    private static final byte[] DEFAULT_IV = new byte[]{32, 33, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 32};
    private static final String DHParaP = "C009D877BAF5FAF416B7F778E6115DCB90D65217DCC2F08A9DFCB5A192C593EBAB02929266B8DBFC2021039FDBD4B7FDE2B996E00008F57AE6EFB4ED3F17B6D3";
    private static final String DHParaG = "5";
    private static DHParameterSpec DHParaSpec = null;
    private static KeyPairGenerator keyPairGenerator = null;
    private static BigInteger p = null;
    private static BigInteger g = null;

    private static IvParameterSpec getIV(int ivLength) {
        if (-1 == ivLength) {
            return new IvParameterSpec(new byte[0]);
        }
        byte[] iv = new byte[ivLength];
        System.arraycopy(DEFAULT_IV, 0, iv, 0, ivLength);
        IvParameterSpec algParams = new IvParameterSpec(iv);
        return algParams;
    }

    private static BigInteger bytes2Bn(byte[] bnBytesSrc) {
        byte[] bnBytesTo = null;
        if (bnBytesSrc == null) {
            return null;
        }
        if (bnBytesSrc[0] == 0) {
            return new BigInteger(bnBytesSrc);
        }
        int validBytesCount = bnBytesSrc.length + 1;
        bnBytesTo = new byte[validBytesCount];
        bnBytesTo[0] = 0;
        System.arraycopy(bnBytesSrc, 0, bnBytesTo, 1, validBytesCount - 1);
        return new BigInteger(bnBytesTo);
    }

    protected static byte[] bn2Bytes(BigInteger bn, int bnLen) {
        byte[] bnBytesSrc = null;
        byte[] bnBytesTemp = null;
        byte[] bnBytesTo = null;
        int validBytesCount = 0;
        if (bn == null) {
            return null;
        }
        bnBytesSrc = bn.toByteArray();
        if (bnBytesSrc[0] != 0) {
            bnBytesTemp = bnBytesSrc;
            validBytesCount = bnBytesTemp.length;
        } else {
            validBytesCount = bnBytesSrc.length - 1;
            bnBytesTemp = new byte[validBytesCount];
            System.arraycopy(bnBytesSrc, 1, bnBytesTemp, 0, validBytesCount);
        }
        int leading_zero_count = bnLen == 0 ? 0 : bnLen - validBytesCount;
        if (leading_zero_count > 0) {
            int i = 0;
            bnBytesTo = new byte[64];
            i = 0;
            while (i < leading_zero_count) {
                bnBytesTo[i] = 0;
                ++i;
            }
            System.arraycopy(bnBytesTemp, 0, bnBytesTo, i, validBytesCount);
        } else {
            bnBytesTo = bnBytesTemp;
        }
        return bnBytesTo;
    }

    protected static synchronized KeyPair newClientKeyPair() throws SQLException {
        if (keyPairGenerator == null) {
            p = new BigInteger(DHParaP, 16);
            g = new BigInteger(DHParaG, 16);
            DHParaSpec = new DHParameterSpec(p, g, 512);
            try {
                keyPairGenerator = KeyPairGenerator.getInstance("DH");
                keyPairGenerator.initialize(DHParaSpec);
            }
            catch (NoSuchAlgorithmException e) {
                keyPairGenerator = null;
                DBError.throwSQLException("can't find sunjce_provider.jar");
            }
            catch (InvalidAlgorithmParameterException e) {
                keyPairGenerator = null;
                DBError.throwSQLException("can't find sunjce_provider.jar");
            }
        }
        if (keyPairGenerator == null) {
            return null;
        }
        KeyPair clientKeyPair = keyPairGenerator.generateKeyPair();
        return clientKeyPair;
    }

    protected static byte[] computeSessionKey(PrivateKey clientPrivKey, byte[] serverPubKey) {
        BigInteger serverKeyX = MsgSecurity.bytes2Bn(serverPubKey);
        BigInteger clientPrivKeyX = ((DHPrivateKey)clientPrivKey).getX();
        BigInteger sessinoKeyBN = serverKeyX.modPow(clientPrivKeyX, p);
        return MsgSecurity.bn2Bytes(sessinoKeyBN, 0);
    }

    protected static Cipher newCipher(int cipherMode, SymmCipherDesc cipherDesc, byte[] sessionKey) throws Exception {
        Cipher encrypt_cipher = null;
        encrypt_cipher = Cipher.getInstance(cipherDesc.getAlgorithmFullName());
        SecretKeySpec keySpec = new SecretKeySpec(sessionKey, cipherDesc.getAlgorithmName());
        if (1 == cipherDesc.getWork_mode() || 4096 == cipherDesc.getAlgorithmType()) {
            encrypt_cipher.init(cipherMode, keySpec);
        } else {
            encrypt_cipher.init(cipherMode, (Key)keySpec, MsgSecurity.getIV(cipherDesc.getIvLength()));
        }
        return encrypt_cipher;
    }
}

