/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.desc.ParameterDesc;
import dm.jdbc.driver.DmOutParamBinder;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.jdbc.driver.DmdbStatement_bs;
import dm.sql.TypeDescriptor;
import java.sql.SQLException;

public abstract class DmBinder {
    int recDType = 0;
    int recPrec = 0;
    int recScale = 0;
    byte destIoType = 0;
    int destDType = 0;
    int destPrec = 0;
    int destScale = 0;
    int srcScale = 0;
    byte[] streamReadTry = null;
    int streamReadTryLen = 0;
    boolean streamReadOver = false;
    char[] readerTry = null;
    int readerTryLen = 0;
    int offset_var = -1;
    public static final int RET_LOB_OFF_ROW = -1;
    public static final int RET_LOB_READ_OVER = 0;
    int sqlType = 0;
    boolean hasSqlType = false;
    boolean hasSqlScale = false;
    int sqlScale = -1;
    DmdbPreparedStatement_bs pstmt;
    ParameterDesc[] paramsDesc;
    boolean m_checkType = false;
    private String typeName = null;
    private boolean outValueFromStandby = false;

    public DmBinder(DmdbPreparedStatement_bs pstmt) {
        this.pstmt = pstmt;
        this.init();
    }

    abstract void init();

    void clearVars() {
        this.streamReadTry = null;
        this.streamReadTryLen = 0;
        this.streamReadOver = false;
        this.readerTry = null;
        this.readerTryLen = 0;
        this.offset_var = -1;
    }

    void checkType(int irow, int icol, boolean forBatch) throws SQLException {
        if (this.m_checkType) {
            return;
        }
        this.m_checkType = true;
        if (this.paramsDesc == null) {
            this.paramsDesc = this.pstmt.getParamsDesc();
        }
        byte typeFlag = this.paramsDesc[icol].getTypeFlag();
        int dType = this.paramsDesc[icol].getDType();
        int prec = this.paramsDesc[icol].getPrec();
        int scale = this.paramsDesc[icol].getScale();
        byte ioType = this.paramsDesc[icol].getIOType();
        if (ioType != 1 && typeFlag != 1) {
            this.destDType = this.recDType;
            this.destPrec = this.recPrec;
            this.destScale = this.recScale;
        } else {
            this.destDType = dType;
            this.destPrec = prec;
            this.destScale = scale;
        }
        this.destIoType = ioType;
        this.srcScale = scale;
    }

    public abstract int bindData(DmMsgSend var1, int var2, int var3, boolean var4) throws SQLException;

    public int bindLobCyc(DmMsgSend lobMsg, int irow, int icol) throws SQLException {
        throw new SQLException("Not impletement");
    }

    public void setOutNullFlag(boolean flag) throws SQLException {
        throw new SQLException("setOutNullFlag not impletement");
    }

    public boolean getOutNullFlag() throws SQLException {
        throw new SQLException("getOutNullFlag not impletement");
    }

    public void setOutValue(byte[] out) throws SQLException {
        throw new SQLException("setOutValue not impletement");
    }

    public byte[] getOutValue() throws SQLException {
        throw new SQLException("getOutValue not impletement");
    }

    public void setSqlType(int sqlType) {
        this.sqlType = sqlType;
        this.hasSqlType = true;
    }

    public void setSqlScale(int sqlScale) {
        this.sqlScale = sqlScale;
        this.hasSqlScale = true;
    }

    public int bindDesc(DmMsgSend msg, int irow, int icol, boolean forBatch) throws SQLException {
        this.checkType(irow, icol, forBatch);
        if (this.destIoType == 2 && 120 != this.destDType) {
            DmBinder inBinder = ((DmOutParamBinder)this).m_inParamBinder;
            inBinder.checkType(irow, icol, forBatch);
            this.destDType = inBinder.destDType;
            this.destPrec = inBinder.destPrec;
            this.destScale = inBinder.destScale;
            this.destIoType = inBinder.destIoType;
            this.srcScale = inBinder.srcScale;
        }
        if (this.destIoType == 1 && 120 == this.destDType) {
            msg.appendByte((byte)2);
        } else {
            msg.appendByte(this.destIoType);
        }
        msg.setInt(this.destDType);
        int lprec = 0;
        int lscale = 0;
        boolean isComplex = true;
        TypeDescriptor typeDesc = this.paramsDesc[icol].getTypeDescriptor();
        switch (this.destDType) {
            case 117: 
            case 122: {
                lprec = TypeDescriptor.getPackArraySize(typeDesc);
                break;
            }
            case 121: {
                lprec = TypeDescriptor.getPackRecordSize(typeDesc);
                break;
            }
            case 119: {
                lprec = TypeDescriptor.getPackClassSize(typeDesc);
                break;
            }
            case 12: {
                lprec = this.paramsDesc[icol].isComplexType() ? this.paramsDesc[icol].getTypeDescriptor().getObjId() : this.destPrec;
                lscale = this.destScale;
                isComplex = false;
                break;
            }
            default: {
                lprec = this.destPrec;
                lscale = this.destScale;
                isComplex = false;
            }
        }
        msg.setInt(lprec);
        msg.setInt(lscale);
        switch (this.destDType) {
            case 117: 
            case 122: {
                TypeDescriptor.packArray(typeDesc, msg);
                break;
            }
            case 121: {
                TypeDescriptor.packRecord(typeDesc, msg);
                break;
            }
            case 119: {
                TypeDescriptor.packClass(typeDesc, msg);
                break;
            }
            default: {
                isComplex = false;
            }
        }
        if (isComplex) {
            return 13 + lprec;
        }
        return 13;
    }

    public boolean checkIOType(byte type) {
        return this.destIoType == type;
    }

    public void setInoutParamBinder(DmBinder inBinder) throws SQLException {
        throw new SQLException("setInoutParamBinder not impletement");
    }

    public DmdbStatement_bs getCursorStmt() throws SQLException {
        throw new SQLException("getCursorStmt not impletement");
    }

    public void clearRetValue() {
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public void setOutValueFromStandby(boolean outValueFromStandby) {
        this.outValueFromStandby = outValueFromStandby;
    }

    public boolean isOutValueFromStandby() {
        return this.outValueFromStandby;
    }
}

