/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dataConvertion.CType2JType;
import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dbaccess.Const;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.FetchDaemons;
import dm.jdbc.desc.ColumnDesc;
import dm.jdbc.desc.GlobalControlCfg;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbCSI;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.driver.DmdbColumn;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.driver.DmdbInfo;
import dm.jdbc.driver.DmdbLog;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.jdbc.driver.DmdbResultSetCache;
import dm.jdbc.driver.DmdbResultSetCache_h;
import dm.jdbc.driver.DmdbResultSetCache_v;
import dm.jdbc.driver.DmdbResultSetMetaData_bs;
import dm.jdbc.driver.DmdbStatement_bs;
import dm.jdbc.driver.DmdbType;
import dm.jdbc.innerData.DmdbParamVal;
import dm.jdbc.util.StringUtil;
import dm.sql.DmdbIntervalDT;
import dm.sql.DmdbIntervalYM;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;

public class DmdbResultSet_bs
implements ResultSet,
Cloneable {
    DmdbResultSetCache rsCache;
    public LinkedList rsCacheList;
    public int cacheCount = 0;
    Thread fetchThread;
    public SQLException fetchThreadError = null;
    private boolean m_multiRsCaches = false;
    DmdbStatement_bs statement = null;
    DmdbConnection_bs conn = null;
    protected SQLWarning m_warnings = null;
    protected int maxFieldSize;
    protected boolean isClosed = false;
    int fetchDirection;
    int fetchSize;
    protected int resultSetType;
    protected int resultConcurrencyType;
    protected int resultSetHoldability;
    protected boolean wasNullFlag = false;
    private boolean m_ignorCase = true;
    long startRow = 0L;
    DmdbInfo dbInfo = null;
    DmdbColumn[] colInfo = null;
    protected long currentRow = -1L;
    Hashtable m_updateParams = new Hashtable();
    protected boolean isUpdateStatus = false;
    protected boolean isInsertStatus = false;
    boolean metaRsFlag = false;
    public long rowCount = 0L;
    public long maxRows = 0L;
    public boolean fromRsCachePool = false;
    int columnCount = 0;
    String serverEncoding = null;
    DmdbBlob[][] m_blobArray = null;
    DmdbClob[][] m_clobArray = null;
    private boolean m_lobCached = false;
    short rsId = 0;
    boolean m_fromStandby = false;
    private boolean isBdta = false;
    int FETCH_FORWARD = 1000;
    int FETCH_REVERSE = 1001;
    int FETCH_UNKNOWN = 1002;
    int TYPE_FORWARD_ONLY = 1003;
    int TYPE_SCROLL_INSENSITIVE = 1004;
    int TYPE_SCROLL_SENSITIVE = 1005;
    int CONCUR_READ_ONLY = 1007;
    int CONCUR_UPDATABLE = 1008;
    int HOLD_CURSORS_OVER_COMMIT = 1;
    int CLOSE_CURSORS_AT_COMMIT = 2;

    DmdbResultSet_bs() {
    }

    public int getDataLen() {
        return this.rsCache.realLen;
    }

    public void setStatement(DmdbStatement_bs stmt) throws SQLException {
        this.statement = stmt;
        this.conn = (DmdbConnection_bs)stmt.getConnection();
    }

    private void cacheLob() throws SQLException {
        if (this.conn == null || this.statement == null || this.colInfo == null || this.rsCache == null || this.colInfo.length == 0 || this.colInfo[0].getDesc().getLobMode() != 2) {
            return;
        }
        int rowCountTemp = (int)this.rowCount;
        if (rowCountTemp <= 0 || rowCountTemp != this.rsCache.rownum) {
            return;
        }
        this.m_blobArray = new DmdbBlob[rowCountTemp][this.columnCount];
        this.m_clobArray = new DmdbClob[rowCountTemp][this.columnCount];
        boolean isBlob = false;
        short col = 0;
        while (col < this.columnCount) {
            ColumnDesc desc = this.colInfo[col].getDesc();
            if (desc.getIsLob()) {
                isBlob = desc.getDType() == 12;
                int row = 0;
                while ((long)row < this.rowCount) {
                    if (row == 0) {
                        this.rsCache.absolute(0);
                    } else {
                        this.rsCache.next();
                    }
                    byte[] value = this.rsCache.getBytes(col);
                    if (value != null) {
                        if (isBlob) {
                            this.m_blobArray[row][col] = (DmdbBlob)CType2JType.getBlob(value, desc, this.conn);
                        } else {
                            this.m_clobArray[row][col] = (DmdbClob)CType2JType.getClob(value, desc, this.conn);
                        }
                    }
                    ++row;
                }
            }
            col = (short)(col + 1);
        }
        this.m_lobCached = true;
    }

    private void initialize(DmdbInfo info, DmdbResultSetCache cache, boolean fromStandby) throws SQLException {
        if (info != null) {
            this.dbInfo = (DmdbInfo)info.clone();
            this.colInfo = info.getColumnsInfo();
            this.rowCount = info.getRowCount();
            this.columnCount = info.getColumnCount();
            this.statement = null;
            this.conn = null;
        }
        if (cache != null) {
            this.rsCache = cache;
            this.isBdta = this.rsCache instanceof DmdbResultSetCache_v;
            this.statement = this.rsCache.statement;
            this.conn = this.statement.connection;
            this.maxFieldSize = 0;
            this.resultSetType = 1003;
            this.resultConcurrencyType = 1007;
            this.resultSetHoldability = 1;
            this.serverEncoding = this.conn.getServerEncoding();
            this.fetchDirection = 1000;
            this.fetchSize = 5;
            if (this.statement != null) {
                this.maxFieldSize = this.statement.getMaxFieldSize();
                this.resultSetType = this.statement.getResultSetType();
                this.resultConcurrencyType = this.statement.getResultSetConcurrency();
                this.resultSetHoldability = this.statement.getResultSetHoldability();
                this.fetchDirection = this.statement.getFetchDirection();
                this.fetchSize = this.statement.getFetchSize();
            }
            this.m_ignorCase = this.conn.getIgnoreCase();
            boolean bl = this.m_multiRsCaches = this.conn.getMultiRsCaches() && this.resultSetType == 1003 && (!GlobalControlCfg.getEnRsCache() || this.dbInfo.getRsCacheOffset() == 0);
            if (this.conn.getRscacheCount() > 1) {
                this.cacheCount = this.conn.getRscacheCount() - 1;
            }
            if (this.m_multiRsCaches && this.rowCount == Long.MAX_VALUE) {
                this.rsCacheList = new LinkedList();
                this.fetchThread = new Thread(new FetchDaemons(this));
                this.fetchThread.setDaemon(true);
                this.fetchThread.start();
            }
        }
        if (this.colInfo != null && GlobalControlCfg.getEnRsCache() && info.getRsCacheOffset() > 0) {
            int i = 0;
            while (i < this.colInfo.length) {
                this.colInfo[i].getDesc().setLobMode(2);
                ++i;
            }
        }
        this.m_fromStandby = fromStandby;
        this.initializePara();
        this.cacheLob();
    }

    public void setConcurrencyType(int conType) {
        this.resultConcurrencyType = conType;
    }

    public void setHoldability(int hold) {
        this.resultSetHoldability = hold;
    }

    DmdbResultSet_bs(DmdbInfo info, boolean fromStandby) throws SQLException {
        this.initialize(info, null, fromStandby);
    }

    DmdbResultSet_bs(DmdbResultSetCache cache, DmdbInfo info, boolean fromStandby) throws SQLException {
        this.initialize(info, cache, fromStandby);
    }

    DmdbResultSet_bs(DmdbResultSetCache cache, DmdbInfo info, boolean fetchAll, boolean fromStandby) throws SQLException {
        this.initialize(info, cache, fromStandby);
        if (this.rowCount > (long)this.rsCache.rownum) {
            this.fetchData(1, fetchAll);
        }
        this.metaRsFlag = true;
        this.initializePara();
    }

    public boolean next() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "next()", "");
        }
        this.checkClose();
        if (this.rowCount == 0L) {
            this.m_warnings = DBError.addSQLWarning(this.m_warnings, 100);
            return false;
        }
        if (this.fromRsCachePool && this.maxRows != 0L && this.currentRow + 1L == this.maxRows) {
            return false;
        }
        if (this.currentRow == -1L) {
            ++this.currentRow;
            if (this.startRow == 0L && this.rsCache.rownum > 0) {
                this.rsCache.absolute(0);
            } else if (this.m_multiRsCaches && this.rsCacheList != null) {
                this.fetch_for_multiRsCaches();
            } else {
                this.fetchData(1, false);
            }
            return true;
        }
        if (this.currentRow < this.rowCount) {
            ++this.currentRow;
            if (this.currentRow == this.rowCount) {
                this.rsCache.next();
                return false;
            }
            if (this.currentRow >= this.startRow + (long)this.rsCache.rownum) {
                this.startRow = this.currentRow;
                if (this.m_multiRsCaches && this.rsCacheList != null) {
                    this.fetch_for_multiRsCaches();
                } else {
                    int code = this.fetchData(1, false);
                    if (code == -7036) {
                        if (this.resultSetType != 1003) {
                            this.startRow = this.currentRow = this.rowCount - 1L;
                            this.fetchData(1, false);
                            this.currentRow = this.rowCount;
                            this.rsCache.next();
                        }
                        return false;
                    }
                }
            } else {
                this.rsCache.next();
            }
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private void fetch_for_multiRsCaches() throws SQLException {
        if (this.fetchThreadError == null) ** GOTO lbl10
        if (this.rsCacheList.size() > 0) {
            this.rsCache = (DmdbResultSetCache)this.rsCacheList.removeFirst();
        } else {
            throw this.fetchThreadError;
lbl-1000:
            // 1 sources

            {
                if (this.fetchThread.isAlive() || this.rowCount != 0x7FFFFFFFFFFFFFFFL) continue;
                this.fetchThread = new Thread(new FetchDaemons(this));
                this.fetchThread.setDaemon(true);
                this.fetchThread.start();
lbl10:
                // 3 sources

                ** while (this.rsCacheList.size() == 0)
            }
lbl11:
            // 1 sources

            this.rsCache = (DmdbResultSetCache)this.rsCacheList.removeFirst();
            if (!this.fetchThread.isAlive() && this.rowCount == 0x7FFFFFFFFFFFFFFFL) {
                this.fetchThread = new Thread(new FetchDaemons(this));
                this.fetchThread.setDaemon(true);
                this.fetchThread.start();
            }
        }
    }

    public void close() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "close()", "");
        }
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.dbInfo = null;
        this.colInfo = null;
        this.currentRow = -1L;
        this.m_multiRsCaches = false;
        this.rsCache = null;
        this.rsCacheList = null;
        this.fetchThread = null;
        this.fetchThreadError = null;
        this.cacheCount = 1;
        if (this.fetchThread != null) {
            this.fetchThread.stop();
            this.fetchThread = null;
        }
        this.m_blobArray = null;
        this.m_clobArray = null;
        this.clearWarnings();
        this.statement = null;
        this.conn = null;
    }

    public boolean wasNull() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "wasNull()", "");
        }
        this.checkClose();
        return this.wasNullFlag;
    }

    public String getString(int columnIndex) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getString(int)", "columnIndex = " + columnIndex);
        }
        this.checkClose();
        this.checkBoundary();
        this.checkIndex(columnIndex);
        ColumnDesc desc = this.colInfo[columnIndex - 1].getDesc();
        byte[] val = this.getByteArrayValue(columnIndex, desc, true);
        if (this.setWasNullFalg(val)) {
            return null;
        }
        return CType2JType.getString(val, desc, this.conn, this.isBdta);
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getBoolean(int)", "columnIndex = " + columnIndex);
        }
        this.checkClose();
        this.checkBoundary();
        this.checkIndex(columnIndex);
        ColumnDesc desc = this.colInfo[columnIndex - 1].getDesc();
        byte[] val = this.getByteArrayValue(columnIndex, desc, true);
        if (this.setWasNullFalg(val)) {
            return false;
        }
        return CType2JType.getBoolean(val, desc, this.conn);
    }

    public byte getByte(int columnIndex) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getByte(int)", "columnIndex = " + columnIndex);
        }
        this.checkClose();
        this.checkBoundary();
        this.checkIndex(columnIndex);
        ColumnDesc desc = this.colInfo[columnIndex - 1].getDesc();
        byte[] val = this.getByteArrayValue(columnIndex, desc, true);
        if (this.setWasNullFalg(val)) {
            return 0;
        }
        return CType2JType.getByte(val, desc, this.conn);
    }

    public short getShort(int columnIndex) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getShort(int)", "columnIndex = " + columnIndex);
        }
        this.checkClose();
        this.checkBoundary();
        this.checkIndex(columnIndex);
        ColumnDesc desc = this.colInfo[columnIndex - 1].getDesc();
        byte[] val = this.getByteArrayValue(columnIndex, desc, true);
        if (this.setWasNullFalg(val)) {
            return 0;
        }
        return CType2JType.getShort(val, desc, this.conn);
    }

    public int getInt(int columnIndex) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getInt(int)", "columnIndex = " + columnIndex);
        }
        this.checkClose();
        this.checkBoundary();
        this.checkIndex(columnIndex);
        ColumnDesc desc = this.colInfo[columnIndex - 1].getDesc();
        byte[] val = this.getByteArrayValue(columnIndex, desc, true);
        if (this.setWasNullFalg(val)) {
            return 0;
        }
        return CType2JType.getInt(val, desc, this.conn);
    }

    public long getLong(int columnIndex) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getLong(int)", "columnIndex = " + columnIndex);
        }
        this.checkClose();
        this.checkBoundary();
        this.checkIndex(columnIndex);
        ColumnDesc desc = this.colInfo[columnIndex - 1].getDesc();
        byte[] val = this.getByteArrayValue(columnIndex, desc, true);
        if (this.setWasNullFalg(val)) {
            return 0L;
        }
        return CType2JType.getLong(val, desc, this.conn);
    }

    public float getFloat(int columnIndex) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getFloat(int)", "columnIndex = " + columnIndex);
        }
        this.checkClose();
        this.checkBoundary();
        this.checkIndex(columnIndex);
        ColumnDesc desc = this.colInfo[columnIndex - 1].getDesc();
        byte[] val = this.getByteArrayValue(columnIndex, desc, true);
        if (this.setWasNullFalg(val)) {
            return 0.0f;
        }
        return CType2JType.getFloat(val, desc, this.conn);
    }

    public double getDouble(int columnIndex) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getDouble(int)", "columnIndex = " + columnIndex);
        }
        this.checkClose();
        this.checkBoundary();
        this.checkIndex(columnIndex);
        ColumnDesc desc = this.colInfo[columnIndex - 1].getDesc();
        byte[] val = this.getByteArrayValue(columnIndex, desc, true);
        if (this.setWasNullFalg(val)) {
            return 0.0;
        }
        return CType2JType.getDouble(val, desc, this.conn);
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        BigDecimal dec = this.getBigDecimal(columnIndex);
        return this.wasNullFlag ? null : dec.setScale(scale, 4);
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getBytes(int)", "columnIndex = " + columnIndex);
        }
        this.checkClose();
        this.checkBoundary();
        this.checkIndex(columnIndex);
        ColumnDesc desc = this.colInfo[columnIndex - 1].getDesc();
        byte[] val = this.getByteArrayValue(columnIndex, desc, true);
        if (this.setWasNullFalg(val)) {
            return null;
        }
        byte[] ret = CType2JType.getBytes(val, desc, this.conn);
        int len = ret.length;
        if (this.maxFieldSize > 0 && len > this.maxFieldSize) {
            len = this.maxFieldSize;
            val = new byte[len];
            System.arraycopy(ret, 0, val, 0, len);
            return val;
        }
        return ret;
    }

    public Date getDate(int columnIndex) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getDate(int)", "columnIndex = " + columnIndex);
        }
        this.checkClose();
        this.checkBoundary();
        this.checkIndex(columnIndex);
        ColumnDesc desc = this.colInfo[columnIndex - 1].getDesc();
        byte[] val = this.getByteArrayValue(columnIndex, desc, true);
        if (this.setWasNullFalg(val)) {
            return null;
        }
        return CType2JType.getDate(val, desc, this.conn);
    }

    public Time getTime(int columnIndex) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getTime(int)", "columnIndex = " + columnIndex);
        }
        this.checkClose();
        this.checkBoundary();
        this.checkIndex(columnIndex);
        ColumnDesc desc = this.colInfo[columnIndex - 1].getDesc();
        byte[] val = this.getByteArrayValue(columnIndex, desc, true);
        if (this.setWasNullFalg(val)) {
            return null;
        }
        return CType2JType.getTime(val, desc, this.conn);
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getTimestamp(int)", "columnIndex = " + columnIndex);
        }
        this.checkClose();
        this.checkBoundary();
        this.checkIndex(columnIndex);
        ColumnDesc desc = this.colInfo[columnIndex - 1].getDesc();
        byte[] val = this.getByteArrayValue(columnIndex, desc, true);
        if (this.setWasNullFalg(val)) {
            return null;
        }
        return CType2JType.getTimestamp(val, desc, this.conn);
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getAsciiStream(int)", "columnIndex = " + columnIndex);
        }
        this.checkClose();
        this.checkBoundary();
        this.checkIndex(columnIndex);
        ColumnDesc desc = this.colInfo[columnIndex - 1].getDesc();
        byte[] val = this.getByteArrayValue(columnIndex, desc, false);
        if (this.setWasNullFalg(val)) {
            return null;
        }
        return CType2JType.getAsciiStream(val, desc, this.conn);
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getUnicodeStream(int)", "columnIndex = " + columnIndex);
        }
        this.checkClose();
        this.checkBoundary();
        this.checkIndex(columnIndex);
        ColumnDesc desc = this.colInfo[columnIndex - 1].getDesc();
        byte[] val = this.getByteArrayValue(columnIndex, desc, false);
        if (this.setWasNullFalg(val)) {
            return null;
        }
        return CType2JType.getUnicodeStream(val, desc, this.conn);
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getBinaryStream(int)", "columnIndex = " + columnIndex);
        }
        this.checkClose();
        this.checkBoundary();
        this.checkIndex(columnIndex);
        ColumnDesc desc = this.colInfo[columnIndex - 1].getDesc();
        byte[] val = this.getByteArrayValue(columnIndex, desc, false);
        if (this.setWasNullFalg(val)) {
            return null;
        }
        return CType2JType.getBinaryStream(val, desc, this.conn);
    }

    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkClose();
        return this.m_warnings;
    }

    public void clearWarnings() throws SQLException {
        this.m_warnings = null;
    }

    public String getCursorName() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getCursorName(int)", "");
        }
        this.checkClose();
        if (this.statement.cursorName == null) {
            this.statement.setCursorName("BPXLYBHQ" + this.statement.handle);
        }
        this.statement.connection.remove_statement(this.statement.handle);
        this.statement.connection.add_statement(this.statement.handle, this.statement);
        return this.statement.cursorName;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getCursorName(int)", "");
        }
        this.checkClose();
        if (this.conn != null) {
            return new DmdbResultSetMetaData_bs(this.statement, this.colInfo, this.resultConcurrencyType, this.conn.getComOra(), this.conn.getClobAsString());
        }
        return new DmdbResultSetMetaData_bs(this.statement, this.colInfo, this.resultConcurrencyType, false, false);
    }

    public Object getObject(int columnIndex) throws SQLException {
        return this.getObjectInner(columnIndex, this.conn.getTypeMap());
    }

    private Object getObjectInner(int columnIndex, Map map) throws SQLException {
        Object ret;
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getObject(int)", "columnIndex = " + columnIndex);
        }
        this.checkClose();
        this.checkBoundary();
        this.checkIndex(columnIndex);
        ColumnDesc desc = this.colInfo[columnIndex - 1].getDesc();
        if (this.conn.getComOra() && DmdbType.isNUMERICtype(DmdbType.dtypeToSqlType(desc.getDType(), desc.getTypeName()))) {
            return this.getBigDecimal(columnIndex);
        }
        if (this.m_lobCached && (desc.getDType() == 12 || desc.getDType() == 19) && !desc.isComplexType()) {
            int len = 0;
            if (desc.getDType() == 12) {
                DmdbBlob blob = this.m_blobArray[(int)this.currentRow][columnIndex - 1];
                if (blob == null) {
                    this.setWasNullFalg(null);
                    return null;
                }
                if ("LONGVARBINARY".equalsIgnoreCase(desc.getTypeName())) {
                    len = blob.getLobLen();
                    if (this.maxFieldSize > 0 && len > this.maxFieldSize) {
                        len = this.maxFieldSize;
                    }
                    return blob.getBytes(1L, len);
                }
                return blob;
            }
            DmdbClob clob = this.m_clobArray[(int)this.currentRow][columnIndex - 1];
            if (clob == null) {
                this.setWasNullFalg(null);
                return null;
            }
            if ("LONGVARCHAR".equalsIgnoreCase(desc.getTypeName())) {
                len = clob.getLobLen();
                return clob.getSubString(1L, len);
            }
            return clob;
        }
        byte[] val = this.getByteArrayValue(columnIndex, desc, false);
        if (this.setWasNullFalg(val)) {
            return null;
        }
        String typeName = null;
        if (desc.getTypeDescriptor() != null) {
            typeName = desc.getTypeDescriptor().getFulName();
        }
        if ((ret = CType2JType.getObject(val, desc, this.conn, map, typeName)) instanceof byte[]) {
            byte[] byteArr = (byte[])ret;
            int len = byteArr.length;
            if (this.maxFieldSize > 0 && len > this.maxFieldSize) {
                len = this.maxFieldSize;
                val = new byte[len];
                System.arraycopy(byteArr, 0, val, 0, len);
                return val;
            }
        }
        return ret;
    }

    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    public int findColumn(String columnName) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "findColumn(String)", "columnName = " + columnName);
        }
        this.checkClose();
        String colTemp = null;
        int retIndex = -1;
        int i = 0;
        while (i < this.colInfo.length) {
            colTemp = this.colInfo[i].getDesc().getName();
            if (this.m_ignorCase) {
                if (colTemp.equalsIgnoreCase(columnName)) {
                    retIndex = i + 1;
                    break;
                }
            } else if (colTemp.equals(columnName)) {
                retIndex = i + 1;
                break;
            }
            ++i;
        }
        if (retIndex == -1) {
            DBError.throwSQLException(6017);
        }
        return retIndex;
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getCharacterStream(int)", "columnIndex = " + columnIndex);
        }
        this.checkClose();
        this.checkBoundary();
        this.checkIndex(columnIndex);
        ColumnDesc desc = this.colInfo[columnIndex - 1].getDesc();
        byte[] val = this.getByteArrayValue(columnIndex, desc, false);
        if (this.setWasNullFalg(val)) {
            return null;
        }
        return CType2JType.getCharacterStream(val, desc, this.conn);
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getBigDecimal(int)", "columnIndex = " + columnIndex);
        }
        this.checkClose();
        this.checkBoundary();
        this.checkIndex(columnIndex);
        ColumnDesc desc = this.colInfo[columnIndex - 1].getDesc();
        byte[] val = this.getByteArrayValue(columnIndex, desc, true);
        if (this.setWasNullFalg(val)) {
            return null;
        }
        return CType2JType.getBigDecimal(val, desc, this.conn);
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    public boolean isBeforeFirst() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "isBeforeFirst()", "");
        }
        this.checkClose();
        return this.isBeforeFirst_inner();
    }

    public boolean isAfterLast() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "isAfterLast()", "");
        }
        this.checkClose();
        return this.isAfterLast_inner();
    }

    public boolean isFirst() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "isFirst()", "");
        }
        this.checkClose();
        return this.currentRow == 0L && this.currentRow < this.rowCount;
    }

    public boolean isLast() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "isLast()", "");
        }
        this.checkClose();
        if (this.resultSetType == 1003) {
            DBError.throwSQLException(6019);
        }
        if (this.rowCount == Long.MAX_VALUE) {
            this.rowCount = DmdbCSI.getRowCount(this.statement, this.m_fromStandby);
        }
        return this.currentRow == this.rowCount - 1L && this.currentRow > -1L;
    }

    public void beforeFirst() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "beforeFirst()", "");
        }
        if (this.rowCount != 0L) {
            this.absolute(1);
            this.currentRow = -1L;
        }
    }

    public void afterLast() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "afterLast()", "");
        }
        this.last();
        this.currentRow = this.rowCount;
    }

    public boolean first() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "first()", "");
        }
        return this.absolute(1);
    }

    public boolean last() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "last()", "");
        }
        this.checkClose();
        if (this.resultSetType == 1003) {
            DBError.throwSQLException(6019);
        }
        if (this.rowCount == Long.MAX_VALUE) {
            this.rowCount = DmdbCSI.getRowCount(this.statement, this.m_fromStandby);
        }
        if (this.rowCount == 0L) {
            return false;
        }
        return this.absolute((int)this.rowCount);
    }

    public int getRow() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getRow()", "");
        }
        this.checkClose();
        if (this.rowCount == 0L || this.currentRow == -1L || this.currentRow >= this.rowCount) {
            return 0;
        }
        return (int)this.currentRow + 1;
    }

    public boolean absolute(int rows) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "absolute(int)", "rows = " + rows);
        }
        this.checkClose();
        if (rows == 0) {
            DBError.throwSQLException(6020);
        }
        if (this.resultSetType == 1003) {
            DBError.throwSQLException(6019);
        }
        if (this.rowCount == 0L) {
            this.currentRow = -1L;
            return false;
        }
        if (rows > 0) {
            if ((long)rows > this.startRow && (long)rows <= this.startRow + (long)this.rsCache.rownum) {
                this.currentRow = rows - 1;
                this.rsCache.absolute((int)((long)rows - this.startRow - 1L));
                return true;
            }
            if ((long)rows <= this.rowCount) {
                this.startRow = this.currentRow = (long)(rows - 1);
                int code = this.fetchData(1, false);
                if (code == -7036) {
                    this.startRow = this.currentRow = this.rowCount - 1L;
                    code = this.fetchData(1, false);
                    this.rsCache.absolute(this.rsCache.rownum);
                    this.currentRow = this.rowCount;
                    return false;
                }
                return true;
            }
            this.startRow = this.currentRow = this.rowCount - 1L;
            this.fetchData(1, false);
            this.rsCache.absolute(this.rsCache.rownum);
            this.currentRow = this.rowCount;
            return false;
        }
        if (rows < 0) {
            if (this.rowCount == Long.MAX_VALUE) {
                this.rowCount = DmdbCSI.getRowCount(this.statement, this.m_fromStandby);
            }
            if ((long)rows + this.rowCount >= this.startRow && (long)rows + this.rowCount < this.startRow + (long)this.rsCache.rownum) {
                this.currentRow = this.rowCount + (long)rows;
                this.rsCache.absolute(this.rsCache.rownum + rows);
            } else if (this.rowCount + (long)rows >= 0L) {
                this.startRow = this.currentRow = this.rowCount + (long)rows;
                this.fetchData(1, false);
            } else if (this.rowCount + (long)rows <= -1L) {
                this.currentRow = 0L;
                this.startRow = 0L;
                this.fetchData(1, false);
                this.rsCache.absolute(0);
                this.currentRow = -1L;
                return false;
            }
        }
        return true;
    }

    public boolean relative(int rows) throws SQLException {
        int rowNum;
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "relative(int)", "rows = " + rows);
        }
        this.checkClose();
        if (this.resultSetType == 1003) {
            DBError.throwSQLException(6019);
        }
        if ((rowNum = (int)((long)rows + this.currentRow + 1L)) <= 0) {
            this.beforeFirst();
            return false;
        }
        if ((long)rowNum > this.rowCount) {
            this.afterLast();
            return false;
        }
        return this.absolute(rowNum);
    }

    public boolean previous() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "previous()", "");
        }
        this.checkClose();
        if (this.resultSetType == 1003) {
            DBError.throwSQLException(6019);
        }
        if (this.currentRow > -1L) {
            if (this.currentRow <= this.startRow && this.currentRow > 0L) {
                this.startRow = this.currentRow - 1L;
                this.fetchData(2, false);
            } else {
                this.rsCache.previous();
                --this.currentRow;
            }
        }
        return this.currentRow > -1L;
    }

    public void setFetchDirection(int direction) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "setFetchDirection(int)", "direction = " + direction);
        }
        this.checkClose();
        if (direction != 1002 && direction != 1000 && direction != 1001) {
            DBError.throwSQLException(6022);
        }
        if (this.resultSetType == 1003 && direction != 1000) {
            DBError.throwSQLException(6023);
        }
        this.fetchDirection = direction;
    }

    public int getFetchDirection() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getFetchDirection()", "");
        }
        this.checkClose();
        return this.fetchDirection;
    }

    public void setFetchSize(int rows) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "setFetchSize(int)", "rows = " + rows);
        }
        this.checkClose();
        if (rows >= 0 && (this.statement.getMaxRows() > 0 && rows <= this.statement.getMaxRows() || this.statement.getMaxRows() == 0)) {
            this.fetchSize = rows;
        } else {
            DBError.throwSQLException(6020);
        }
    }

    public int getFetchSize() throws SQLException {
        this.checkClose();
        return this.fetchSize;
    }

    public int getType() throws SQLException {
        this.checkClose();
        return this.resultSetType;
    }

    public int getConcurrency() throws SQLException {
        this.checkClose();
        return this.resultConcurrencyType;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    public void updateNull(int columnIndex) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "updateNull(int)", "columnIndex = " + columnIndex);
        }
        this.updateParam(columnIndex, null, 24);
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "updateBoolean(int, boolean)", "columnIndex = " + columnIndex + ", x = " + x);
        }
        this.updateParam(columnIndex, new Boolean(x), 0);
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "updateByte(int, byte)", "columnIndex = " + columnIndex + ", x = " + x);
        }
        this.updateParam(columnIndex, new Byte(x), 1);
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "updateShort(int, short)", "columnIndex = " + columnIndex + ", x = " + x);
        }
        this.updateParam(columnIndex, new Short(x), 2);
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "updateInt(int, int)", "columnIndex = " + columnIndex + ", x = " + x);
        }
        this.updateParam(columnIndex, new Integer(x), 3);
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "updateLong(int, long)", "columnIndex = " + columnIndex + ", x = " + x);
        }
        this.updateParam(columnIndex, new Long(x), 4);
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "updateFloat(int, float)", "columnIndex = " + columnIndex + ", x = " + x);
        }
        this.updateParam(columnIndex, new Float(x), 5);
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "updateDouble(int, double)", "columnIndex = " + columnIndex + ", x = " + x);
        }
        this.updateParam(columnIndex, new Double(x), 6);
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (x == null) {
                DmdbLog.trace(this, "updateBigDecimal(int, BigDecimal)", "columnIndex = " + columnIndex + ", x is null ");
            } else {
                DmdbLog.trace(this, "updateBigDecimal(int, BigDecimal)", "columnIndex = " + columnIndex + ", x = " + x);
            }
        }
        this.updateParam(columnIndex, x, 7);
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (x == null) {
                DmdbLog.trace(this, "updateString(int, String)", "columnIndex = " + columnIndex + ", x is null");
            } else {
                DmdbLog.trace(this, "updateString(int, String)", "columnIndex = " + columnIndex + ", x = " + x);
            }
        }
        this.updateParam(columnIndex, x, 14);
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (x == null) {
                DmdbLog.trace(this, "updateBytes(int, byte[])", "columnIndex = " + columnIndex + ", x is null");
            } else {
                DmdbLog.trace(this, "updateBytes(int, byte[])", "columnIndex = " + columnIndex + ", x = " + new String(x));
            }
        }
        this.updateParam(columnIndex, x, 15);
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (x == null) {
                DmdbLog.trace(this, "updateDate(int, java.sql.Date)", "columnIndex = " + columnIndex + ", x is null");
            } else {
                DmdbLog.trace(this, "updateDate(int, java.sql.Date)", "columnIndex = " + columnIndex + ", x = " + x.toString());
            }
        }
        this.updateParam(columnIndex, x, 8);
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (x == null) {
                DmdbLog.trace(this, "updateTime(int, java.sql.Time)", "columnIndex = " + columnIndex + ", x is null");
            } else {
                DmdbLog.trace(this, "updateTime(int, java.sql.Time)", "columnIndex = " + columnIndex + ", x = " + x.toString());
            }
        }
        this.updateParam(columnIndex, x, 9);
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (x == null) {
                DmdbLog.trace(this, "updateTimestamp(int, java.sql.Timestamp)", "columnIndex = " + columnIndex + ", x is null");
            } else {
                DmdbLog.trace(this, "updateTimestamp(int, java.sql.Timestamp)", "columnIndex = " + columnIndex + ", x = " + x.toString());
            }
        }
        this.updateParam(columnIndex, x, 10);
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (x == null) {
                DmdbLog.trace(this, "updateAsciiStream(int, java.io.InputStream, int)", "columnIndex = " + columnIndex + ", x is null");
            } else {
                DmdbLog.trace(this, "updateAsciiStream(int, java.io.InputStream, int)", "columnIndex = " + columnIndex + ", length = " + length);
            }
        }
        this.updateParam(columnIndex, x, 19, length);
    }

    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (x == null) {
                DmdbLog.trace(this, "updateAsciiStream(int, java.io.InputStream, long)", "columnIndex = " + columnIndex + ", x is null");
            } else {
                DmdbLog.trace(this, "updateAsciiStream(int, java.io.InputStream, long)", "columnIndex = " + columnIndex + ", length = " + length);
            }
        }
        this.updateParam(columnIndex, x, 19, length);
    }

    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (x == null) {
                DmdbLog.trace(this, "updateAsciiStream(int, java.io.InputStream)", "columnIndex = " + columnIndex + ", x is null");
            } else {
                DmdbLog.trace(this, "updateAsciiStream(int, java.io.InputStream)", "columnIndex = " + columnIndex);
            }
        }
        this.updateParam(columnIndex, x, 19);
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (x == null) {
                DmdbLog.trace(this, "updateBinaryStream(int, java.io.InputStream, int)", "columnIndex = " + columnIndex + ", x is null");
            } else {
                DmdbLog.trace(this, "updateBinaryStream(int, java.io.InputStream, int)", "columnIndex = " + columnIndex + ", length = " + length);
            }
        }
        this.updateParam(columnIndex, x, 19, length);
    }

    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (x == null) {
                DmdbLog.trace(this, "updateBinaryStream(int, java.io.InputStream, long)", "columnIndex = " + columnIndex + ", x is null");
            } else {
                DmdbLog.trace(this, "updateBinaryStream(int, java.io.InputStream, long)", "columnIndex = " + columnIndex + ", length = " + length);
            }
        }
        this.updateParam(columnIndex, x, 19, length);
    }

    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (x == null) {
                DmdbLog.trace(this, "updateBinaryStream(int, java.io.InputStream)", "columnIndex = " + columnIndex + ", x is null");
            } else {
                DmdbLog.trace(this, "updateBinaryStream(int, java.io.InputStream)", "columnIndex = " + columnIndex);
            }
        }
        this.updateParam(columnIndex, x, 19);
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (x == null) {
                DmdbLog.trace(this, "updateCharacterStream(int, java.io.Reader, int)", "columnIndex = " + columnIndex + ", x is null");
            } else {
                DmdbLog.trace(this, "updateCharacterStream(int, java.io.Reader, int)", "columnIndex = " + columnIndex + ", length = " + length);
            }
        }
        this.updateParam(columnIndex, x, 18, length);
    }

    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (x == null) {
                DmdbLog.trace(this, "updateCharacterStream(int, java.io.Reader, long)", "columnIndex = " + columnIndex + ", x is null");
            } else {
                DmdbLog.trace(this, "updateCharacterStream(int, java.io.Reader, long)", "columnIndex = " + columnIndex + ", length = " + length);
            }
        }
        this.updateParam(columnIndex, x, 18, length);
    }

    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (x == null) {
                DmdbLog.trace(this, "updateCharacterStream(int, java.io.Reader)", "columnIndex = " + columnIndex + ", x is null");
            } else {
                DmdbLog.trace(this, "updateCharacterStream(int, java.io.Reader)", "columnIndex = " + columnIndex);
            }
        }
        this.updateParam(columnIndex, x, 18);
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (x == null) {
                DmdbLog.trace(this, "updateObject(int, Object, int)", "columnIndex = " + columnIndex + ", x is null");
            } else {
                DmdbLog.trace(this, "updateObject(int, Object, int)", "columnIndex = " + columnIndex + "Object is " + x.toString() + ", scale = " + scale);
            }
        }
        this.updateParam_withScale(columnIndex, x, 25, scale);
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (x == null) {
                DmdbLog.trace(this, "updateObject(int, Object)", "columnIndex = " + columnIndex + ", x is null");
            } else {
                DmdbLog.trace(this, "updateObject(int, Object)", "columnIndex = " + columnIndex + "Object is " + x.toString());
            }
        }
        if (x instanceof BigDecimal) {
            int scale = ((BigDecimal)x).scale();
            this.updateParam_withScale(columnIndex, x, 25, scale);
        } else {
            this.updateParam(columnIndex, x, 25);
        }
    }

    public void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), x);
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnName), x);
    }

    public void updateShort(String columnName, short x) throws SQLException {
        this.updateShort(this.findColumn(columnName), x);
    }

    public void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.findColumn(columnName), x);
    }

    public void updateLong(String columnName, long x) throws SQLException {
        this.updateLong(this.findColumn(columnName), x);
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x);
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x);
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x);
    }

    public void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.findColumn(columnName), x);
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x);
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnName), x);
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnName), x);
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x);
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x, length);
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader, length);
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), x, scale);
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    public void insertRow() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "insertRow()", "");
        }
        this.checkClose();
        this.checkUpdatable();
        if (!this.isInsertStatus) {
            DBError.throwSQLException(6026);
        }
        if (this.m_updateParams.size() <= 0) {
            throw new SQLException("Can't insert Row for nothing update.");
        }
        this.checkBoundaryForUpdate();
        String paramNames = "";
        String paramEntity = "";
        String schemaName = "\"" + StringUtil.getEscObjName(this.colInfo[0].getDesc().getSchName()) + "\"";
        String tableName = "\"" + StringUtil.getEscObjName(this.colInfo[0].getDesc().getTabName()) + "\"";
        int pan = 0;
        DmdbParamVal param = null;
        int i = 0;
        while (i < this.columnCount) {
            param = (DmdbParamVal)this.m_updateParams.get(new Integer(i + 1));
            if (param != null) {
                if (pan++ > 0) {
                    paramNames = String.valueOf(paramNames) + " , ";
                    paramEntity = String.valueOf(paramEntity) + " , ";
                }
                paramNames = String.valueOf(paramNames) + "\"" + StringUtil.getEscObjName(this.colInfo[i].getDesc().getName()) + "\"";
                paramEntity = String.valueOf(paramEntity) + " ? ";
            }
            ++i;
        }
        if (paramEntity.length() == 0 || paramNames.length() == 0) {
            return;
        }
        String insertSql = "insert into " + schemaName + "." + tableName + " (" + paramNames + ") values(" + paramEntity + ")";
        DmdbPreparedStatement_bs pstmt = new DmdbPreparedStatement_bs(this.conn, insertSql);
        pan = 0;
        int i2 = 0;
        while (i2 < this.columnCount) {
            param = (DmdbParamVal)this.m_updateParams.get(new Integer(i2 + 1));
            if (param != null) {
                pstmt.setParamValue(++pan, param);
            }
            ++i2;
        }
        pstmt.setPutLobData(2);
        pstmt.executeUpdate();
        pstmt.close();
        this.initializePara();
        this.isInsertStatus = false;
    }

    public void updateRow() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "updateRow()", "");
        }
        this.checkClose();
        this.checkUpdatable();
        if (this.isInsertStatus) {
            DBError.throwSQLException(6027);
        }
        if (this.m_updateParams.size() <= 0) {
            throw new SQLException("Can't update Row for nothing update.");
        }
        this.checkBoundaryForUpdate();
        String schemaName = "\"" + StringUtil.getEscObjName(this.colInfo[0].getDesc().getSchName()) + "\"";
        String tableName = "\"" + StringUtil.getEscObjName(this.colInfo[0].getDesc().getTabName()) + "\"";
        int pan = 0;
        DmdbParamVal param = null;
        String paramNames = "";
        int i = 0;
        while (i < this.columnCount) {
            param = (DmdbParamVal)this.m_updateParams.get(new Integer(i + 1));
            if (param != null) {
                if (pan++ > 0) {
                    paramNames = String.valueOf(paramNames) + ", ";
                }
                paramNames = String.valueOf(paramNames) + "\"" + StringUtil.getEscObjName(this.colInfo[i].getDesc().getName()) + "\"" + " = ? ";
            }
            ++i;
        }
        if (paramNames.length() == 0) {
            return;
        }
        String insertSql = "update " + schemaName + "." + tableName + " set " + paramNames + " where current of \"" + StringUtil.getEscObjName(this.getCursorName()) + "\"";
        DmdbPreparedStatement_bs pstmt = new DmdbPreparedStatement_bs(this.conn, insertSql);
        pan = 0;
        i = 0;
        while (i < this.columnCount) {
            param = (DmdbParamVal)this.m_updateParams.get(new Integer(i + 1));
            if (param != null) {
                pstmt.setParamValue(++pan, param);
            }
            ++i;
        }
        pstmt.setPutLobData(2);
        pstmt.executeUpdate();
        pstmt.close();
        this.initializePara();
        this.isUpdateStatus = false;
    }

    public void deleteRow() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "deleteRow()", "");
        }
        this.checkClose();
        this.checkUpdatable();
        this.checkBoundary();
        if (this.isInsertStatus) {
            DBError.throwSQLException(6027);
        }
        this.checkBoundaryForUpdate();
        StringBuffer deleteStmtBuffer = new StringBuffer();
        deleteStmtBuffer.append("DELETE FROM ");
        String schema = "\"" + StringUtil.getEscObjName(this.colInfo[0].getDesc().getSchName()) + "\"";
        String table = "\"" + StringUtil.getEscObjName(this.colInfo[0].getDesc().getTabName()) + "\"";
        deleteStmtBuffer.append(schema).append(".");
        deleteStmtBuffer.append(table);
        deleteStmtBuffer.append(" WHERE CURRENT OF \"" + StringUtil.getEscObjName(this.getCursorName()) + "\"");
        String sql = deleteStmtBuffer.toString();
        DmdbStatement_bs stmtForDel = null;
        try {
            stmtForDel = new DmdbStatement_bs(this.conn, 1003, 1007, 1);
            stmtForDel.cursorUpdateRow = this.currentRow;
            stmtForDel.executeUpdate(sql);
        }
        finally {
            if (stmtForDel != null) {
                stmtForDel.close();
                stmtForDel = null;
            }
        }
    }

    public void refreshRow() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "refreshRow()", "");
        }
        this.checkClose();
        if (this.resultSetType == 1003) {
            DBError.throwSQLException(6019);
        }
        if (this.isInsertStatus) {
            DBError.throwSQLException(6027);
        }
    }

    public void cancelRowUpdates() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "cancelRowUpdates()", "");
        }
        this.checkClose();
        this.m_updateParams.clear();
    }

    public void moveToInsertRow() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "moveToInsertRow()", "");
        }
        this.checkClose();
        if (this.resultConcurrencyType == 1007) {
            DBError.throwSQLException(6029);
        }
        this.isInsertStatus = true;
    }

    public void moveToCurrentRow() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "moveToCurrentRow()", "");
        }
        this.checkClose();
        this.isInsertStatus = false;
        if (this.resultConcurrencyType == 1007) {
            DBError.throwSQLException(6029);
        }
    }

    public Statement getStatement() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getStatement()", "");
        }
        this.checkClose();
        return this.statement;
    }

    public Object getObject(int i, Map map) throws SQLException {
        if (map == null) {
            return this.getObject(i);
        }
        return this.getObjectInner(i, map);
    }

    public Ref getRef(int i) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public Blob getBlob(int columnIndex) throws SQLException {
        ColumnDesc desc;
        byte[] val;
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getBlob(int)", "columnid = " + columnIndex);
        }
        this.checkClose();
        this.checkIndex(columnIndex);
        this.checkBoundary();
        if (this.m_lobCached) {
            if (this.colInfo[columnIndex - 1].getDesc().getDType() == 12) {
                return this.m_blobArray[(int)this.currentRow][columnIndex - 1];
            }
            DBError.throwSQLException(6016);
        }
        if (this.setWasNullFalg(val = this.getByteArrayValue(columnIndex, desc = this.colInfo[columnIndex - 1].getDesc(), false))) {
            return null;
        }
        return CType2JType.getBlob(val, desc, this.conn);
    }

    public Clob getClob(int i) throws SQLException {
        ColumnDesc desc;
        byte[] val;
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getClob(int)", "columnid = " + i);
        }
        this.checkClose();
        this.checkIndex(i);
        this.checkBoundary();
        if (this.m_lobCached) {
            if (this.colInfo[i - 1].getDesc().getDType() == 19) {
                return this.m_clobArray[(int)this.currentRow][i - 1];
            }
            DBError.throwSQLException(6016);
        }
        if (this.setWasNullFalg(val = this.getByteArrayValue(i, desc = this.colInfo[i - 1].getDesc(), false))) {
            return null;
        }
        return CType2JType.getClob(val, desc, this.conn);
    }

    public Array getArray(int i) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public Object getObject(String colName, Map map) throws SQLException {
        return this.getObject(this.findColumn(colName), map);
    }

    public Ref getRef(String colName) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public Blob getBlob(String colName) throws SQLException {
        return this.getBlob(this.findColumn(colName));
    }

    public Clob getClob(String colName) throws SQLException {
        return this.getClob(this.findColumn(colName));
    }

    public Array getArray(String colName) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        Date d = this.getDate(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.setTime(d);
        return new Date(cal.getTimeInMillis());
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnName), cal);
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        Time time = this.getTime(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.setTimeInMillis(time.getTime());
        return new Time(cal.getTimeInMillis());
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnName), cal);
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        Timestamp timestamp = this.getTimestamp(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.setTime(timestamp);
        Timestamp xn = new Timestamp(cal.getTimeInMillis());
        int nanos = timestamp.getNanos();
        if (nanos != 0) {
            xn.setNanos(nanos);
        }
        return xn;
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), cal);
    }

    public URL getURL(int columnIndex) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public URL getURL(String columnName) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    public void updateRef(String columnName, Ref x) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (x == null) {
                DmdbLog.trace(this, "updateBlob(int, java.sql.Blob)", "columnid = " + columnIndex + ", x is null");
            } else {
                DmdbLog.trace(this, "updateBlob(int, java.sql.Blob)", "columnid = " + columnIndex);
            }
        }
        this.updateParam(columnIndex, x, 16);
    }

    public void updateBlob(String columnName, Blob x) throws SQLException {
        this.updateBlob(this.findColumn(columnName), x);
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (x == null) {
                DmdbLog.trace(this, "updateClob(int, java.sql.Clob)", "columnid = " + columnIndex + ", x is null");
            } else {
                DmdbLog.trace(this, "updateClob(int, java.sql.Clob)", "columnid = " + columnIndex);
            }
        }
        this.updateParam(columnIndex, x, 17);
    }

    public void updateClob(String columnName, Clob x) throws SQLException {
        this.updateClob(this.findColumn(columnName), x);
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    public void updateArray(String columnName, Array x) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    public void updateINTERVALYM(int i, DmdbIntervalYM ym) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (ym == null) {
                DmdbLog.trace(this, "updateINTERVALYM(int, DmdbIntervalYM)", "columnid = " + i + ", x is null");
            } else {
                DmdbLog.trace(this, "updateINTERVALYM(int, DmdbIntervalYM)", "columnid = " + i + ", x = " + ym.toString());
            }
        }
        this.updateParam(i, ym, 12);
    }

    public void updateINTERVALYM(String s, DmdbIntervalYM ym) throws SQLException {
        this.updateINTERVALYM(this.findColumn(s), ym);
    }

    public void updateINTERVALDT(int i, DmdbIntervalDT dt) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (dt == null) {
                DmdbLog.trace(this, "updateINTERVALDT(int, DmdbIntervalDT)", "columnid = " + i + ", x is null");
            } else {
                DmdbLog.trace(this, "updateINTERVALDT(int, DmdbIntervalDT)", "columnid = " + i + ", x = " + dt.toString());
            }
        }
        this.updateParam(i, dt, 13);
    }

    public void updateINTERVALDT(String s, DmdbIntervalDT dt) throws SQLException {
        this.updateINTERVALDT(this.findColumn(s), dt);
    }

    byte[] getByteArrayValue(int columnIndex, ColumnDesc desc, boolean loadLobAll) throws SQLException {
        byte[] val;
        if ((val = this.rsCache.getBytes((short)(--columnIndex))) != null && loadLobAll && (desc.getDTypeInfo().getDType() == 12 || desc.getDTypeInfo().getDType() == 19)) {
            if (desc.getLobDesc() == null) {
                DBError.throwSQLException(6007);
            }
            val = Convertion.getBytesFrmLob(val, desc.getDTypeInfo(), desc.getLobDesc(), this.conn, this.statement, this.m_fromStandby);
        }
        return val;
    }

    protected long getCurrentRowNum() {
        return this.currentRow;
    }

    private int fetchData(int fetchType, boolean fetchAll) throws SQLException {
        long curPos;
        int ret = 1;
        if (this.metaRsFlag) {
            return ret;
        }
        if (fetchAll) {
            curPos = this.rsCache.rownum;
        } else if (fetchType == 1) {
            curPos = this.startRow;
        } else {
            int tmp_tuple_len = DmdbColumn.getMaxTupleLen(this.colInfo, this.conn.getMaxRowSize());
            int max_row_num = 32640 / tmp_tuple_len;
            curPos = this.startRow - (long)(max_row_num / 2);
            if (curPos < 0L) {
                curPos = 0L;
            }
        }
        ret = DmdbCSI.fetch(this.statement, curPos, fetchAll, this, this.rsId, this.m_fromStandby);
        if (fetchType == 2) {
            if (this.rsCache instanceof DmdbResultSetCache_h) {
                this.setRsCache_after_fetch((DmdbResultSetCache_h)this.rsCache, curPos);
            }
            this.rsCache.curpos = (int)(this.startRow - curPos);
            this.startRow = curPos;
        }
        return ret;
    }

    private void setRsCache_after_fetch(DmdbResultSetCache_h rsCache, long curPos) {
        int offset = 0;
        int i = 0;
        while ((long)i < this.startRow - curPos) {
            offset += rsCache.rec4_get_len(rsCache.rowbuf, offset);
            ++i;
        }
        rsCache.offset = offset;
    }

    public long getRowid() {
        return this.rsCache.rec_get_rowid();
    }

    public long getRowCount() throws SQLException {
        this.checkClose();
        if (this.rowCount == Long.MAX_VALUE) {
            if (this.resultSetType == 1003) {
                return -1L;
            }
            return DmdbCSI.getRowCount(this.statement, this.m_fromStandby);
        }
        return this.rowCount;
    }

    void initializePara() {
        this.m_updateParams.clear();
    }

    public final Object clone() {
        DmdbResultSet_bs rs = null;
        try {
            rs = (DmdbResultSet_bs)super.clone();
            rs.statement = null;
            rs.conn = null;
            rs.m_multiRsCaches = false;
            rs.rsCache = null;
            rs.rsCacheList = null;
            rs.fetchThread = null;
            rs.fetchThreadError = null;
            rs.cacheCount = 1;
            if (this.dbInfo != null) {
                rs.dbInfo = (DmdbInfo)this.dbInfo.clone();
            }
            if (this.colInfo != null) {
                rs.colInfo = (DmdbColumn[])this.colInfo.clone();
            }
            if (this.rsCache != null) {
                rs.rsCache = (DmdbResultSetCache)this.rsCache.clone();
                rs.rsCache.setCols(rs.colInfo);
            }
            rs.startRow = 0L;
            rs.currentRow = -1L;
            rs.initializePara();
            if (this.m_lobCached) {
                int col = 0;
                while (col < this.columnCount) {
                    int dtype = this.colInfo[col].getDesc().getDType();
                    int row = 0;
                    while ((long)row < this.rowCount) {
                        if (dtype == 12 && this.m_blobArray[row][col] != null) {
                            rs.m_blobArray[row][col] = (DmdbBlob)this.m_blobArray[row][col].clone();
                        }
                        if (dtype == 19 && this.m_clobArray[row][col] != null) {
                            rs.m_clobArray[row][col] = (DmdbClob)this.m_clobArray[row][col].clone();
                        }
                        ++row;
                    }
                    col = (short)(col + 1);
                }
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return rs;
    }

    public void setRsId(short resId) {
        this.rsId = resId;
    }

    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    private boolean isBeforeFirst_inner() {
        return this.currentRow <= -1L && this.rowCount >= 0L;
    }

    private boolean isAfterLast_inner() throws SQLException {
        if (this.rowCount == Long.MAX_VALUE) {
            return false;
        }
        return this.currentRow >= this.rowCount && this.rowCount >= 0L;
    }

    protected void checkIndex(int i) throws SQLException {
        if (i < 1 || i > this.columnCount) {
            DBError.throwSQLException(6032);
        }
    }

    protected void checkClose() throws SQLException {
        if (this.isClosed) {
            DBError.throwSQLException(6034);
        }
    }

    void checkUpdatable() throws SQLException {
        if (this.resultConcurrencyType != 1008 || !this.dbInfo.getUpdatable()) {
            DBError.throwSQLException(6029);
        }
        if (this.m_fromStandby) {
            DBError.throwSQLException(Const.res.getString("error.rsUpdateNotSupportWhenFromStandby"));
        }
    }

    protected void checkBoundary() throws SQLException {
        if (this.isBeforeFirst_inner()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
        if (this.rowCount != Long.MAX_VALUE && this.isAfterLast_inner()) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
    }

    private void checkBoundaryForUpdate() throws SQLException {
        if ((this.isBeforeFirst_inner() || this.isAfterLast_inner()) && !this.isInsertStatus) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
    }

    private void checkNullable(int columnIndex) throws SQLException {
        if (!this.colInfo[columnIndex - 1].getDesc().getNullable()) {
            DBError.throwSQLException(6024);
        }
    }

    private void setUpdateStatus(boolean update) {
        this.isUpdateStatus = update;
    }

    private boolean setWasNullFalg(byte[] value) {
        this.wasNullFlag = value == null;
        return this.wasNullFlag;
    }

    private void putUpdateParam(int columnIndex, Object x, int jType) {
        DmdbParamVal param = new DmdbParamVal();
        param.setInValue(x, jType);
        param.setTypeFlag((byte)1);
        this.m_updateParams.put(new Integer(columnIndex), param);
    }

    private void putUpdateParam(int columnIndex, Object x, int jType, long length) {
        DmdbParamVal param = new DmdbParamVal();
        param.setInValue(x, jType);
        param.setLength(length);
        param.setTypeFlag((byte)1);
        this.m_updateParams.put(new Integer(columnIndex), param);
    }

    private void putUpdateParam_withScale(int columnIndex, Object x, int jType, int scale) {
        DmdbParamVal param = new DmdbParamVal();
        param.setInValue(x, jType);
        param.setTargetScale(scale);
        param.setTypeFlag((byte)1);
        this.m_updateParams.put(new Integer(columnIndex), param);
    }

    private void updateParam(int columnIndex, Object x, int jType) throws SQLException {
        this.checkClose();
        this.checkUpdatable();
        this.checkIndex(columnIndex);
        this.checkBoundaryForUpdate();
        if (x == null) {
            this.checkNullable(columnIndex);
        }
        this.setUpdateStatus(true);
        this.putUpdateParam(columnIndex, x, jType);
    }

    private void updateParam(int columnIndex, Object x, int jType, long length) throws SQLException {
        this.checkClose();
        this.checkUpdatable();
        this.checkIndex(columnIndex);
        this.checkBoundaryForUpdate();
        if (x == null) {
            this.checkNullable(columnIndex);
        }
        this.setUpdateStatus(true);
        this.putUpdateParam(columnIndex, x, jType, length);
    }

    private void updateParam_withScale(int columnIndex, Object x, int jType, int scale) throws SQLException {
        this.checkClose();
        this.checkUpdatable();
        this.checkIndex(columnIndex);
        this.checkBoundaryForUpdate();
        if (x == null) {
            this.checkNullable(columnIndex);
        }
        this.setUpdateStatus(true);
        this.putUpdateParam_withScale(columnIndex, x, jType, scale);
    }

    public int getHoldability() throws SQLException {
        return 1;
    }

    public int fetchData_for_multiRscaches() throws SQLException {
        int ret = 1;
        if (this.metaRsFlag) {
            return ret;
        }
        ret = DmdbCSI.fetch(this.statement, this.startRow, false, this, this.rsId, this.m_fromStandby);
        return ret;
    }

    public boolean multiRsCaches() {
        return this.m_multiRsCaches;
    }

    public void addRsCache(DmdbResultSetCache tmp) {
        this.rsCacheList.addLast(tmp);
    }
}

