/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbResultSet_bs;
import dm.jdbc.driver.DmdbStatement_bs;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class DmdbStatement
implements Statement {
    private DmdbStatement_bs rStmt = null;
    private DmdbResultSet curResultSet = null;
    private DmdbConnection curConnect = null;

    public DmdbStatement(DmdbStatement_bs Stmt, DmdbConnection curConn) throws SQLException {
        this.rStmt = Stmt;
        this.curConnect = curConn;
    }

    DmdbStatement() {
    }

    public DmdbStatement_bs getRealStmt() {
        return this.rStmt;
    }

    void setRealStmt(DmdbStatement_bs Stmt, DmdbConnection curConn) {
        this.rStmt = Stmt;
        this.curConnect = curConn;
    }

    DmdbConnection_bs getRealConn() {
        return this.curConnect.getRealConn();
    }

    void setCurResultSet(DmdbResultSet rs) {
        if (this.curResultSet != null) {
            this.curResultSet = null;
        }
        this.curResultSet = rs;
    }

    public int getExecuteId() {
        return this.rStmt.getExecuteId();
    }

    public long getRowId() {
        return this.rStmt.getRowId();
    }

    public void initializeReuseStmt(DmdbConnection conn) throws SQLException {
        this.rStmt.initializeReuseStmt(conn.getRealConn());
    }

    public DmdbStatement(DmdbConnection conn) throws SQLException {
        this.curConnect = conn;
        this.rStmt = new DmdbStatement_bs(conn.getRealConn());
    }

    @Override
    public synchronized ResultSet executeQuery(String sql) throws SQLException {
        DmdbResultSet_bs rsb = (DmdbResultSet_bs)this.rStmt.executeQuery(sql);
        if (rsb == null) {
            return null;
        }
        DmdbResultSet rs = new DmdbResultSet(rsb, this);
        this.setCurResultSet(rs);
        return rs;
    }

    @Override
    public synchronized int executeUpdate(String sql) throws SQLException {
        return this.rStmt.executeUpdate(sql);
    }

    @Override
    public synchronized void close() throws SQLException {
        this.rStmt.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.rStmt.getMaxFieldSize();
    }

    @Override
    public synchronized void setMaxFieldSize(int max) throws SQLException {
        this.rStmt.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.rStmt.getMaxRows();
    }

    @Override
    public synchronized void setMaxRows(int max) throws SQLException {
        this.rStmt.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.rStmt.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.rStmt.getQueryTimeout();
    }

    @Override
    public synchronized void setQueryTimeout(int seconds) throws SQLException {
        this.rStmt.setQueryTimeout(seconds);
    }

    @Override
    public synchronized void cancel() throws SQLException {
        this.rStmt.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.rStmt.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.rStmt.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.rStmt.setCursorName(name);
    }

    @Override
    public synchronized boolean execute(String sql) throws SQLException {
        return this.rStmt.execute(sql);
    }

    @Override
    public synchronized ResultSet getResultSet() throws SQLException {
        DmdbResultSet_bs rs = (DmdbResultSet_bs)this.rStmt.getResultSet();
        if (rs == null) {
            return null;
        }
        this.curResultSet = new DmdbResultSet(rs, this);
        return this.curResultSet;
    }

    @Override
    public synchronized int getUpdateCount() throws SQLException {
        return this.rStmt.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        if (this.curResultSet != null) {
            this.curResultSet.close();
        }
        return this.rStmt.getMoreResults();
    }

    @Override
    public synchronized void setFetchDirection(int direction) throws SQLException {
        this.rStmt.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.rStmt.getFetchDirection();
    }

    @Override
    public synchronized void setFetchSize(int rows) throws SQLException {
        this.rStmt.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.rStmt.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.rStmt.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.rStmt.getResultSetType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.rStmt.addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.rStmt.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.rStmt.executeBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.curConnect;
    }

    @Override
    public synchronized boolean getMoreResults(int current) throws SQLException {
        if ((current == 1 || current == 3) && this.curResultSet != null) {
            this.curResultSet.close();
        }
        return this.rStmt.getMoreResults(current);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        DmdbResultSet_bs rsb = (DmdbResultSet_bs)this.rStmt.getGeneratedKeys();
        if (rsb == null) {
            return null;
        }
        return new DmdbResultSet(rsb, this);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.rStmt.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.rStmt.executeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.rStmt.executeUpdate(sql, columnNames);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.rStmt.execute(sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.rStmt.execute(sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.rStmt.execute(sql, columnNames);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.rStmt.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.rStmt.isClosed();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return iface.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.rStmt.setPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.rStmt.isPoolable();
    }

    public synchronized void preCompile(String sql) throws SQLException {
        this.rStmt.preCompile(sql);
    }

    public synchronized void executeDirect() throws SQLException {
        this.rStmt.executeDirect();
    }
}

