/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dbaccess;

import dm.jdbc.dbaccess.DBError;
import java.sql.SQLException;

class SymmCipherDesc {
    private static final String DEFAULT_PADDING_TYPE = "PKCS5Padding";
    private static final String NO_PADDING_TYPE = "NoPadding";
    private int algorithmType = -1;
    private int work_mode = -1;
    private String algorithmFullName = null;
    private String algorithmName = null;
    private int keyLength = -1;
    private int ivLength = -1;

    protected SymmCipherDesc(int algorithmID) throws SQLException {
        StringBuffer algorithmNameT = new StringBuffer();
        this.algorithmType = algorithmID & 0xFF80;
        this.work_mode = algorithmID & 0x7F;
        switch (this.algorithmType) {
            case 512: {
                algorithmNameT.append("AES");
                this.keyLength = 16;
                this.ivLength = 16;
                break;
            }
            case 1024: {
                algorithmNameT.append("AES");
                this.keyLength = 24;
                this.ivLength = 16;
                break;
            }
            case 2048: {
                algorithmNameT.append("AES");
                this.keyLength = 32;
                this.ivLength = 16;
                break;
            }
            case 128: {
                algorithmNameT.append("DES");
                this.keyLength = 8;
                this.ivLength = 8;
                break;
            }
            case 256: {
                algorithmNameT.append("DESEDE");
                this.keyLength = 16;
                this.ivLength = 8;
                break;
            }
            case 4096: {
                this.keyLength = 16;
                algorithmNameT.append("RC4");
                break;
            }
            default: {
                DBError.throwSQLException(6069);
            }
        }
        this.algorithmName = algorithmNameT.toString();
        if (4096 == this.algorithmType) {
            this.algorithmFullName = algorithmNameT.toString();
            return;
        }
        algorithmNameT.append("/");
        switch (this.work_mode) {
            case 1: {
                algorithmNameT.append("ECB");
                algorithmNameT.append("/");
                algorithmNameT.append(DEFAULT_PADDING_TYPE);
                break;
            }
            case 2: {
                algorithmNameT.append("CBC");
                algorithmNameT.append("/");
                algorithmNameT.append(DEFAULT_PADDING_TYPE);
                break;
            }
            case 4: {
                algorithmNameT.append("CFB");
                algorithmNameT.append("/");
                algorithmNameT.append(NO_PADDING_TYPE);
                break;
            }
            case 8: {
                algorithmNameT.append("OFB");
                algorithmNameT.append("/");
                algorithmNameT.append(NO_PADDING_TYPE);
                break;
            }
            default: {
                DBError.throwSQLException(6069);
            }
        }
        this.algorithmFullName = algorithmNameT.toString();
    }

    protected String getAlgorithmFullName() {
        return this.algorithmFullName;
    }

    protected int getIvLength() {
        return this.ivLength;
    }

    protected int getKeyLength() {
        return this.keyLength;
    }

    protected String getAlgorithmName() {
        return this.algorithmName;
    }

    protected int getWork_mode() {
        return this.work_mode;
    }

    protected int getAlgorithmType() {
        return this.algorithmType;
    }
}

