/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.tds;

import com.sybase.jdbc3.jdbc.SybConnection;
import com.sybase.jdbc3.utils.Debug;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

public class PduOutputFormatter
extends FilterOutputStream {
    private int _packetSize;
    private byte[] _netBuf;
    private int _nextOut;
    private int _pduType;
    private int _pduStatus;
    private SybConnection _conn;

    public PduOutputFormatter(OutputStream outputStream, int n, SybConnection sybConnection) throws SQLException {
        super(outputStream);
        this.setNetBufSize(n);
        this._nextOut = 8;
        this._pduType = 15;
        this._pduStatus = 0;
        this._conn = sybConnection;
    }

    public void setNetBufSize(int n) {
        int n2;
        byte[] byArray = new byte[n];
        for (n2 = 0; n2 < this._nextOut; ++n2) {
            byArray[n2] = this._netBuf[n2];
        }
        for (n2 = this._nextOut; n2 < n; ++n2) {
            byArray[n2] = 0;
        }
        this._netBuf = byArray;
        this._packetSize = n;
    }

    public void write(int n) throws IOException {
        if (this._nextOut >= this._packetSize) {
            this.doFlush(true);
        }
        this._netBuf[this._nextOut++] = (byte)n;
    }

    public void write(byte[] byArray, int n) throws IOException {
        this.write(byArray, 0, n);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        Debug.asrt(this, n2 + n <= byArray.length, "Offset/Length values are incorrect");
        int n3 = n;
        while (n2 > 0) {
            int n4;
            if (this._nextOut >= this._packetSize) {
                this.doFlush(true);
            }
            int n5 = (n4 = this._packetSize - this._nextOut) < n2 - n ? n4 : n2 - n;
            System.arraycopy(byArray, n3, this._netBuf, this._nextOut, n5);
            this._nextOut += n5;
            n2 -= n5;
            n3 += n5;
        }
    }

    public void setPDUHeader(int n, int n2) {
        this._pduType = n;
        this._pduStatus = n2;
    }

    public void flush() throws IOException {
        this.doFlush(false);
    }

    protected void changeOutput(OutputStream outputStream) {
        this.out = outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFlush(boolean bl) throws IOException {
        try {
            this._netBuf[0] = (byte)this._pduType;
            int n = this._packetSize;
            if (bl) {
                this._netBuf[1] = (byte)this._pduStatus;
            } else {
                this._netBuf[1] = (byte)(this._pduStatus | 1);
                n = this._nextOut;
            }
            this._netBuf[2] = (byte)((n & 0xFF00) >> 8);
            this._netBuf[3] = (byte)(n & 0xFF);
            this.out.write(this._netBuf, 0, n);
            if (!bl) {
                this.out.flush();
            }
        }
        catch (IOException iOException) {
            this._conn.markDeadTryHA();
        }
        finally {
            this._nextOut = 8;
        }
    }
}

