/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

public class StringUtil {
    private static final int BYTE_RANGE = 256;
    private static byte[] allBytes = new byte[256];
    private static char[] byteToChars = new char[256];

    static {
        int i = -128;
        while (i <= 127) {
            StringUtil.allBytes[i - -128] = (byte)i;
            ++i;
        }
        String allBytesString = new String(allBytes, 0, 255);
        int allBytesStringLen = allBytesString.length();
        int i2 = 0;
        while (i2 < 255 && i2 < allBytesStringLen) {
            StringUtil.byteToChars[i2] = allBytesString.charAt(i2);
            ++i2;
        }
    }

    public static final String toAsciiString(byte[] buffer) {
        return StringUtil.toAsciiString(buffer, 0, buffer.length);
    }

    public static final String toAsciiString(byte[] buffer, int startPos, int length) {
        char[] charArray = new char[length];
        int readpoint = startPos;
        int i = 0;
        while (i < length) {
            charArray[i] = byteToChars[buffer[readpoint] - -128];
            ++readpoint;
            ++i;
        }
        return new String(charArray);
    }

    public static final char firstNonWsCharUc(String searchIn) {
        if (searchIn == null) {
            return '\u0000';
        }
        int length = searchIn.length();
        int i = 0;
        while (i < length) {
            char c = searchIn.charAt(i);
            if (!Character.isWhitespace(c)) {
                return Character.toUpperCase(c);
            }
            ++i;
        }
        return '\u0000';
    }

    public static final boolean startsWithIgnoreCase(String searchIn, String searchFor) {
        return StringUtil.startsWithIgnoreCase(searchIn, 0, searchFor);
    }

    public static final boolean startsWithIgnoreCase(String searchIn, int startAt, String searchFor) {
        return searchIn.regionMatches(true, 0, searchFor, startAt, searchFor.length());
    }

    public static final boolean startsWithIgnoreCaseAndWs(String searchIn, String searchFor) {
        int beginPos = 0;
        int inLength = searchIn.length();
        beginPos = 0;
        while (beginPos < inLength) {
            if (!Character.isWhitespace(searchIn.charAt(beginPos))) break;
            ++beginPos;
        }
        return StringUtil.startsWithIgnoreCase(searchIn, beginPos, searchFor);
    }

    public static final String[] split(String s, String seperators) {
        if (s == null || seperators == null) {
            return null;
        }
        int[] foot = new int[s.length()];
        int count = 0;
        int sLen = s.length();
        int seperatorsLen = seperators.length();
        int i = 0;
        while (i < sLen) {
            if (i == 0 && sLen >= seperatorsLen && s.substring(0, seperatorsLen).equals(seperators)) {
                i += seperatorsLen - 1;
            } else {
                int j = 0;
                while (j < seperatorsLen) {
                    if (s.charAt(i) == seperators.charAt(j)) {
                        foot[count] = i;
                        ++count;
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        String[] ret = new String[count + 1];
        if (count == 0) {
            ret[0] = s;
            return ret;
        }
        ret[0] = s.substring(0, foot[0]);
        int i2 = 1;
        while (i2 < count) {
            ret[i2] = s.substring(foot[i2 - 1] + 1, foot[i2]);
            ++i2;
        }
        ret[count] = s.substring(foot[count - 1] + 1, s.length());
        return ret;
    }

    public static final String getEscObjName(String name) {
        String escName = "";
        if (name == null || name.indexOf("\"") == -1) {
            return name;
        }
        int index = 0;
        while (true) {
            int index2;
            if ((index2 = name.indexOf("\"", index)) == -1) break;
            escName = String.valueOf(escName) + name.substring(index, index2 + 1);
            escName = String.valueOf(escName) + "\"";
            index = index2 + 1;
        }
        escName = String.valueOf(escName) + name.substring(index);
        return escName;
    }

    public static final String getEscStringName(String name) {
        String escName = "";
        if (name == null || name.indexOf("'") == -1) {
            return name;
        }
        int index = 0;
        while (true) {
            int index2;
            if ((index2 = name.indexOf("'", index)) == -1) break;
            escName = String.valueOf(escName) + name.substring(index, index2 + 1);
            escName = String.valueOf(escName) + "'";
            index = index2 + 1;
        }
        escName = String.valueOf(escName) + name.substring(index);
        return escName;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return str != null && str.length() > 0;
    }
}

