/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.DBError;
import java.sql.SQLException;
import java.sql.Savepoint;

public class DmdbSavepoint
implements Savepoint {
    private static int s_seedId = 0;
    private boolean releasedFlag = false;
    private static final int MAX_ID_VALUE = Integer.MAX_VALUE;
    private static final int INVALID_ID_VALUE = -1;
    static final int NAMED_SAVEPOINT_TYPE = 2;
    static final int UNNAMED_SAVEPOINT_TYPE = 1;
    static final int UNKNOWN_SAVEPOINT_TYPE = 0;
    private int m_id = -1;
    private String m_name = null;
    private int m_type = 0;

    public DmdbSavepoint() throws SQLException {
        this.m_type = 1;
        this.m_id = this.getNextId();
        this.m_name = null;
        this.releasedFlag = false;
    }

    public DmdbSavepoint(String s) throws SQLException {
        this.m_type = 2;
        this.m_id = -1;
        this.m_name = s;
        this.releasedFlag = false;
    }

    public int getSavepointId() throws SQLException {
        if (this.m_type == 2) {
            DBError.throwSQLException(6046);
        }
        return this.m_id;
    }

    public String getSavepointName() throws SQLException {
        if (this.m_type == 1) {
            DBError.throwSQLException(6047);
        }
        return this.m_name;
    }

    int getType() {
        return this.m_type;
    }

    private int getNextId() {
        s_seedId = (s_seedId + 1) % Integer.MAX_VALUE;
        return s_seedId;
    }

    void setReleasedFlagTrue() {
        this.releasedFlag = true;
    }

    boolean getReleasedFlag() {
        return this.releasedFlag;
    }
}

