/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.pool;

import dm.jdbc.driver.DmdbConnection_bs;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class DmdbPooledConnection_bs
implements PooledConnection {
    private Hashtable eventListeners;
    private SQLException sqlException = null;
    protected Connection physicalConn;
    protected Connection logicalHandle = null;

    public Hashtable getEventListeners() {
        return this.eventListeners;
    }

    public void setSqlException(SQLException ex) {
        this.sqlException = ex;
    }

    public DmdbPooledConnection_bs(Connection connection) {
        this.physicalConn = connection;
        this.eventListeners = new Hashtable(10);
    }

    public synchronized void addConnectionEventListener(ConnectionEventListener listener) {
        if (this.eventListeners == null) {
            this.sqlException = new SQLException("Listener Hashtable Null");
        } else {
            this.eventListeners.put(listener, listener);
        }
    }

    void callListener(int i) {
        if (this.eventListeners == null) {
            return;
        }
        Enumeration enumeration = this.eventListeners.keys();
        ConnectionEvent connectionevent = new ConnectionEvent(this, this.sqlException);
        while (enumeration.hasMoreElements()) {
            ConnectionEventListener connectioneventlistener = (ConnectionEventListener)enumeration.nextElement();
            ConnectionEventListener connectioneventlistener1 = (ConnectionEventListener)this.eventListeners.get(connectioneventlistener);
            if (i == 1) {
                connectioneventlistener1.connectionClosed(connectionevent);
                continue;
            }
            if (i != 2) continue;
            connectioneventlistener1.connectionErrorOccurred(connectionevent);
        }
    }

    public synchronized void close() throws SQLException {
        if (this.physicalConn != null) {
            ((DmdbConnection_bs)this.physicalConn).unLogicalConnection();
            this.physicalConn.close();
            this.physicalConn = null;
        }
    }

    public synchronized Connection getConnection() throws SQLException {
        if (this.physicalConn == null) {
            this.sqlException = new SQLException("Physical Connection doesn't exis");
            this.callListener(2);
            return null;
        }
        try {
            if (this.logicalHandle != null) {
                this.logicalHandle.close();
            }
            this.logicalHandle = ((DmdbConnection_bs)this.physicalConn).getLogicalConnection(this);
        }
        catch (SQLException sqlexception) {
            this.sqlException = sqlexception;
            this.callListener(2);
            return null;
        }
        return this.logicalHandle;
    }

    public synchronized void logicalClose() {
        this.callListener(1);
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener listener) {
        if (this.eventListeners == null) {
            this.sqlException = new SQLException("Listener Hashtable Null");
        } else {
            this.eventListeners.remove(listener);
        }
    }
}

