/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.driver.DmBinder;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import java.sql.Clob;
import java.sql.SQLException;

public class DmClobBinder
extends DmBinder {
    boolean new_lob_flag = false;

    public DmClobBinder(DmdbPreparedStatement_bs pstmt) {
        super(pstmt);
        this.new_lob_flag = pstmt.getConnection_bs().getNewLobFlag();
    }

    void init() {
        this.recDType = 19;
        this.recPrec = Integer.MAX_VALUE;
        this.recScale = 0;
    }

    public int bindData(DmMsgSend msg, int irow, int icol, boolean forBatch) throws SQLException {
        byte[] ret = null;
        Clob clob = (Clob)this.pstmt.getParamObject(irow, icol);
        String serverEncoding = this.pstmt.connection.getServerEncoding();
        String str = "";
        long length = clob.length();
        if (this.destDType == 19) {
            if (length > 2048L) {
                return -1;
            }
            str = clob.getSubString(1L, (int)length);
            ret = Convertion.getBytes(str, serverEncoding);
            if (ret.length > 2048) {
                return -1;
            }
        }
        switch (this.destDType) {
            case 2: 
            case 19: {
                str = clob.getSubString(1L, (int)length);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        ret = Convertion.getBytes(str, serverEncoding);
        return msg.appendBytesWithLen2(ret, 0, ret.length);
    }

    public int bindLobCyc(DmMsgSend lobMsg, int irow, int icol) throws SQLException {
        Clob lob = (Clob)this.pstmt.getParamObject(irow, icol);
        int maxLen = 8000;
        long lobLen = lob.length();
        if ((long)this.offset_var > lobLen) {
            this.clearVars();
            return 0;
        }
        if (this.offset_var == -1) {
            this.offset_var = 1;
        }
        String serverEncoding = this.pstmt.connection.getServerEncoding();
        String str = lob.getSubString(this.offset_var, maxLen);
        this.offset_var += str.length();
        byte[] ret = Convertion.getBytes(str, serverEncoding);
        return lobMsg.appendOffRowBytes(ret, 0, ret.length, this.new_lob_flag, str.length());
    }
}

