/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.rsCache;

import dm.jdbc.driver.DmdbCallableStatement_bs;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.jdbc.driver.DmdbStatement_bs;
import dm.sql.DmdbIntervalDT;
import dm.sql.DmdbIntervalYM;
import dm.sql.DmdbTime;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public class DmdbResultSetKey {
    String m_guid = null;
    String m_curSch = null;
    String m_sql = null;
    public final int m_paramCount;
    public Object[] m_paramObjects = null;
    private boolean m_codeCalced = false;
    private int m_codeVal = 0;

    public DmdbResultSetKey(String guid, String curSch, String sql, DmdbStatement_bs stmt) {
        this.m_guid = guid;
        this.m_curSch = curSch;
        this.m_sql = sql;
        if (stmt instanceof DmdbPreparedStatement_bs || stmt instanceof DmdbCallableStatement_bs) {
            ((DmdbPreparedStatement_bs)stmt).copyParamValueBound(this);
            int parmCount = ((DmdbPreparedStatement_bs)stmt).getParamCount();
            int outParmCount = ((DmdbPreparedStatement_bs)stmt).getOutParamCount();
            this.m_paramCount = parmCount > outParmCount ? parmCount : 0;
        } else {
            this.m_paramCount = 0;
        }
    }

    public int hashCode() {
        if (this.m_codeCalced) {
            return this.m_codeVal;
        }
        if (this.m_guid == null || this.m_curSch == null || this.m_sql == null) {
            this.m_codeVal = 0;
            this.m_codeCalced = true;
            return this.m_codeVal;
        }
        this.m_codeVal = this.m_guid.hashCode() ^ this.m_curSch.hashCode() ^ this.m_sql.hashCode();
        int i = 0;
        while (i < this.m_paramCount) {
            if (this.m_paramObjects[i] instanceof Boolean) {
                this.m_codeVal += ((Boolean)this.m_paramObjects[i]).hashCode();
            } else if (this.m_paramObjects[i] instanceof Byte) {
                this.m_codeVal += ((Byte)this.m_paramObjects[i]).hashCode();
            } else if (this.m_paramObjects[i] instanceof Short) {
                this.m_codeVal += ((Short)this.m_paramObjects[i]).hashCode();
            } else if (this.m_paramObjects[i] instanceof Integer) {
                this.m_codeVal += ((Integer)this.m_paramObjects[i]).hashCode();
            } else if (this.m_paramObjects[i] instanceof Long) {
                this.m_codeVal += ((Long)this.m_paramObjects[i]).hashCode();
            } else if (this.m_paramObjects[i] instanceof Float) {
                this.m_codeVal += ((Float)this.m_paramObjects[i]).hashCode();
            } else if (this.m_paramObjects[i] instanceof Double) {
                this.m_codeVal += ((Double)this.m_paramObjects[i]).hashCode();
            } else if (this.m_paramObjects[i] instanceof BigDecimal) {
                this.m_codeVal += ((BigDecimal)this.m_paramObjects[i]).hashCode();
            } else if (this.m_paramObjects[i] instanceof Date) {
                this.m_codeVal += ((Date)this.m_paramObjects[i]).hashCode();
            } else if (this.m_paramObjects[i] instanceof Timestamp) {
                this.m_codeVal += ((Timestamp)this.m_paramObjects[i]).hashCode();
            } else if (this.m_paramObjects[i] instanceof Time) {
                this.m_codeVal += ((Time)this.m_paramObjects[i]).hashCode();
            } else if (this.m_paramObjects[i] instanceof DmdbTime) {
                this.m_codeVal += ((DmdbTime)this.m_paramObjects[i]).hashCode();
            } else if (this.m_paramObjects[i] instanceof DmdbIntervalDT) {
                this.m_codeVal += ((DmdbIntervalDT)this.m_paramObjects[i]).hashCode();
            } else if (this.m_paramObjects[i] instanceof DmdbIntervalYM) {
                this.m_codeVal += ((DmdbIntervalYM)this.m_paramObjects[i]).hashCode();
            } else if (this.m_paramObjects[i] instanceof String) {
                this.m_codeVal += ((String)this.m_paramObjects[i]).hashCode();
            } else if (this.m_paramObjects[i] instanceof byte[]) {
                this.m_codeVal += ((byte[])this.m_paramObjects[i]).hashCode();
            }
            ++i;
        }
        this.m_codeCalced = true;
        return this.m_codeVal;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof DmdbResultSetKey)) {
            return false;
        }
        DmdbResultSetKey rsKey = (DmdbResultSetKey)o;
        if (!(this.m_guid.equals(rsKey.m_guid) && this.m_curSch.equals(rsKey.m_curSch) && this.m_sql.equals(rsKey.m_sql) && this.m_paramCount == rsKey.m_paramCount)) {
            return false;
        }
        int i = 0;
        while (i < this.m_paramCount) {
            if (this.m_paramObjects[i] == null && rsKey.m_paramObjects[i] != null) {
                return false;
            }
            if (this.m_paramObjects[i] != null) {
                if (this.m_paramObjects[i] instanceof byte[]) {
                    if (rsKey.m_paramObjects[i] == null || !(rsKey.m_paramObjects[i] instanceof byte[]) || ((byte[])rsKey.m_paramObjects[i]).length != ((byte[])rsKey.m_paramObjects[i]).length) {
                        return false;
                    }
                    int len = ((byte[])rsKey.m_paramObjects[i]).length;
                    int j = 0;
                    while (j < len) {
                        if (((byte[])this.m_paramObjects[i])[j] != ((byte[])rsKey.m_paramObjects[i])[j]) {
                            return false;
                        }
                        ++j;
                    }
                } else if (!this.m_paramObjects[i].equals(rsKey.m_paramObjects[i])) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }
}

