/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dbaccess;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dbaccess.AuthInfo;
import dm.jdbc.dbaccess.Const;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DataOfFetch;
import dm.jdbc.dbaccess.DmMsgRecv;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.dbaccess.MsgSecurity;
import dm.jdbc.desc.GlobalControlCfg;
import dm.jdbc.desc.ParameterDesc;
import dm.jdbc.driver.DmBinder;
import dm.jdbc.driver.DmExternalCrypto;
import dm.jdbc.driver.DmInputStreamBinder;
import dm.jdbc.driver.DmNullBinder;
import dm.jdbc.driver.DmOutParamBinder;
import dm.jdbc.driver.DmReaderBinder;
import dm.jdbc.driver.DmdbCSI;
import dm.jdbc.driver.DmdbCallableStatement_bs;
import dm.jdbc.driver.DmdbColumn;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.driver.DmdbInfo;
import dm.jdbc.driver.DmdbLob;
import dm.jdbc.driver.DmdbLobLocator;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.jdbc.driver.DmdbResultSetCache_h;
import dm.jdbc.driver.DmdbResultSetCache_v;
import dm.jdbc.driver.DmdbResultSet_bs;
import dm.jdbc.driver.DmdbStatement_bs;
import dm.jdbc.driver.DmdbType;
import dm.jdbc.innerData.DmdbExecOpt;
import dm.jdbc.util.StringUtil;
import dm.jdbc.xa.DmdbXAException;
import dm.jdbc.xa.DmdbXAResource;
import dm.jdbc.xa.DmdbXid;
import dm.sql.TypeDescriptor;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class Request_Response {
    static /* synthetic */ Class class$0;

    public static final void req_startup(DmMsgSend msg, DmdbConnection_bs conn, boolean toPrimary) throws SQLException {
        Request_Response.req_initMsg(msg);
        msg.req_startup_set_encrypt_type(0);
        if (conn.isCompress()) {
            msg.req_startup_set_cmp_flag(2);
        } else {
            msg.req_startup_set_cmp_flag(0);
        }
        if (conn.isBdtaRS()) {
            msg.req_startup_set_rs_bdta_flag((byte)2);
        } else {
            msg.req_startup_set_rs_bdta_flag((byte)0);
        }
        if (GlobalControlCfg.getCommunicationEncrypt()) {
            msg.req_startup_set_comm_enc_flag((byte)1);
            msg.req_startup_set_gen_keypair_flag((byte)1);
        } else {
            msg.req_startup_set_comm_enc_flag((byte)0);
            msg.req_startup_set_gen_keypair_flag((byte)0);
        }
        int offset = 64;
        String str = DmdbType.getVersion();
        byte[] buf = Convertion.getBytes(str, conn.getServerEncoding());
        offset += msg.setBytesWithLen4(buf, 0, offset, buf.length);
        byte flag = 0;
        String uKeyName = conn.getProperties().getProperty("uKeyName");
        if (uKeyName != null && uKeyName.length() > 0) {
            String uKeyPin;
            Pointer p;
            byte[] buffer;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("dm.jdbc.driver.DmExternalCrypto");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            DmExternalCrypto INSTANCE = (DmExternalCrypto)Native.loadLibrary((String)uKeyName, (Class)clazz);
            flag = 1;
            offset += msg.setByte(flag, offset);
            conn.setUKeyFlag(true);
            boolean rv = false;
            byte[] cert = new byte[4096];
            int cert_len = 4096;
            PointerByReference pref = new PointerByReference();
            IntByReference iref = new IntByReference(100);
            rv = INSTANCE.crypto_get_name(pref, iref);
            if (!rv) {
                DBError.throwSQLException(6001);
            }
            if (!uKeyName.equalsIgnoreCase(new String(buffer = (p = pref.getValue()).getByteArray(0L, iref.getValue())))) {
                DBError.throwSQLException(6001);
            }
            if (!(rv = INSTANCE.crypto_login(pref, (uKeyPin = conn.getProperties().getProperty("uKeyPin")).getBytes(), uKeyPin.length()))) {
                DBError.throwSQLException(6001);
            }
            if (!(rv = INSTANCE.crypto_read_cert(p, cert, iref = new IntByReference(4096)))) {
                DBError.throwSQLException(6001);
            }
            cert_len = iref.getValue();
            buf = Convertion.getBytes(uKeyName, conn.getServerEncoding());
            offset += msg.setBytesWithLen4(buf, 0, offset, buf.length);
            offset += msg.setBytesWithLen4(cert, 0, offset, cert_len);
        }
        offset += msg.setByte(flag, offset);
        if (GlobalControlCfg.getCommunicationEncrypt()) {
            byte[] clientPubKey = conn.getDbAccess().getClientPubKey(toPrimary);
            offset += msg.setBytesWithLen4(clientPubKey, 0, offset, 64);
        }
        Request_Response.req_setCommonHead(msg, 0, (short)200, offset - 64);
    }

    public static final void resp_startup(DmMsgRecv recvMsg, DmdbConnection_bs conn, boolean toPrimary) throws SQLException {
        boolean pwd_encrypt = false;
        byte[] sessionKey = null;
        int msgEncryptType = -1;
        int msgCipherType = -1;
        int len = 0;
        Request_Response.resp_startup_get_msghead(recvMsg, conn);
        Request_Response.resp_checkErr(recvMsg, conn);
        byte comm_enc_flag = recvMsg.res_startup_get_comm_enc_flag();
        byte gen_keypair_flag = recvMsg.res_startup_get_gen_keypair_flag();
        int offset = 64;
        len = (int)recvMsg.getInt(offset += recvMsg.getErrlen());
        conn.setDmServerVersion(recvMsg.getString(offset += 4, len));
        offset += len;
        Request_Response.resp_dbVersionCheck(conn.getDmServerVersion(), len);
        if (conn.getUKeyFlag()) {
            conn.setRandom(recvMsg.getString(offset, 16));
            offset += 16;
        }
        if (comm_enc_flag == 1) {
            msgEncryptType = (int)recvMsg.getInt(offset);
            offset += 4;
        }
        if (gen_keypair_flag == 1) {
            msgCipherType = msgEncryptType;
            if (msgCipherType == -1) {
                pwd_encrypt = true;
                msgCipherType = 132;
            }
            len = (int)recvMsg.getInt(offset);
            byte[] serverPubKey = recvMsg.getBytes(offset += 4, len);
            sessionKey = MsgSecurity.computeSessionKey(conn.getDbAccess().getClientPrivKey(toPrimary), serverPubKey);
            offset += len;
        }
        conn.getDbAccess().genMsgCiphers(toPrimary, msgCipherType, sessionKey);
        conn.setPwdEncrypt(pwd_encrypt);
        conn.getDbAccess().setMsgEncryptType(msgEncryptType, toPrimary);
    }

    public static final void req_login(DmMsgSend msg, DmdbConnection_bs conn, boolean toPrimary) throws SQLException {
        Request_Response.req_initMsg(msg);
        msg.req_login_set_env(2);
        int iso_level = 0;
        switch (conn.getTransLevel()) {
            case 2: {
                iso_level = 1;
                break;
            }
            case 8: {
                iso_level = 3;
                break;
            }
            case 1: {
                iso_level = 0;
                break;
            }
            default: {
                iso_level = -1;
            }
        }
        msg.req_login_set_iso_level(iso_level);
        msg.req_login_set_language(conn.getLanguage());
        msg.req_login_set_time_zone(conn.getTz());
        msg.req_login_set_read_only((byte)conn.getTransAccessMode());
        msg.req_login_set_session_timeout(conn.getSessionTimeout());
        if (conn.getMppLocal()) {
            msg.req_login_set_mpp_login_type((byte)1);
        } else {
            msg.req_login_set_mpp_login_type((byte)0);
        }
        if (conn.getRwSeparate()) {
            msg.req_login_set_req_standby_flag((byte)1);
        } else {
            msg.req_login_set_req_standby_flag((byte)0);
        }
        msg.nmsg_req_login_set_new_lob_flag((byte)1);
        int offset = 64;
        try {
            byte[] userbuf;
            String serverEncoding = conn.getServerEncoding();
            if (conn.getUKeyFlag()) {
                IntByReference iref;
                DmExternalCrypto INSTANCE;
                boolean rv = false;
                byte[] buf = conn.getRandom().getBytes(serverEncoding);
                byte[] signdata = new byte[1024];
                int signdata_len = 1024;
                String uKeyName = conn.getProperties().getProperty("uKeyName");
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("dm.jdbc.driver.DmExternalCrypto");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!(rv = (INSTANCE = (DmExternalCrypto)Native.loadLibrary((String)uKeyName, (Class)clazz)).cipher_asym_sign(0, null, 0, buf, buf.length, signdata, iref = new IntByReference(1024)))) {
                    DBError.throwSQLException(6001);
                }
                signdata_len = iref.getValue();
                offset += msg.setBytesWithLen4(signdata, 0, offset, signdata_len);
            }
            if ((userbuf = conn.getLoginName().getBytes(serverEncoding)).length > 128) {
                throw new SQLException("User's name is too long");
            }
            byte[] userpwd = conn.getPassword().getBytes(serverEncoding);
            if (userpwd.length > 128) {
                throw new SQLException(Const.res.getString("error.passwordtoolong"));
            }
            if (conn.pwd_encrypt()) {
                userbuf = conn.getDbAccess().symmetricEncrypto(toPrimary, userbuf, userbuf.length, false);
                userpwd = conn.getDbAccess().symmetricEncrypto(toPrimary, userpwd, userpwd.length, false);
            }
            offset += msg.setBytesWithLen4(userbuf, 0, offset, userbuf.length);
            offset += msg.setBytesWithLen4(userpwd, 0, offset, userpwd.length);
            String appName = conn.getAppName();
            if (appName == null) {
                appName = "";
            }
            byte[] buf = appName.getBytes(serverEncoding);
            offset += msg.setBytesWithLen4(buf, 0, offset, buf.length);
            buf = conn.getOsName().getBytes(serverEncoding);
            offset += msg.setBytesWithLen4(buf, 0, offset, buf.length);
            buf = conn.getHostMchName().getBytes(serverEncoding);
            offset += msg.setBytesWithLen4(buf, 0, offset, buf.length);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        offset = Request_Response.req_login_kerberosInfo(msg, conn, offset);
        Request_Response.req_setCommonHead(msg, 0, (short)1, offset - 64);
    }

    private static final int req_login_kerberosInfo(DmMsgSend msg, DmdbConnection_bs con, int offset) {
        AuthInfo kerberosAuth = con.getKerberosAuth();
        if (kerberosAuth == null) {
            return offset;
        }
        byte[] buf = kerberosAuth.getOut_buf();
        offset += msg.setBytesWithLen4(buf, 0, offset, buf.length);
        return offset;
    }

    public static final void resp_login(DmMsgRecv recvMsg, DmdbConnection_bs conn) throws SQLException {
        Request_Response.resp_checkErr(recvMsg, conn);
        conn.setMaxRowSize((short)recvMsg.res_login_get_max_data_len());
        if (recvMsg.res_login_get_ddl_auto_commit() == 0) {
            conn.setDDL_Auto_commit(false);
        } else {
            conn.setDDL_Auto_commit(true);
        }
        switch (recvMsg.res_login_get_iso_level()) {
            case 1: {
                conn.setTransLevel(2);
                break;
            }
            case 3: {
                conn.setTransLevel(8);
                break;
            }
            default: {
                conn.setTransLevel(0);
            }
        }
        conn.setCaseSensitive(recvMsg.res_login_get_str_case_sensitive() == 1);
        if (recvMsg.res_login_get_back_slash() == 0) {
            conn.setBackslashEscape(false);
        } else {
            conn.setBackslashEscape(true);
        }
        conn.setSvrStat(recvMsg.res_login_get_svr_stat());
        conn.setSvrMode(recvMsg.res_login_get_svr_mode());
        conn.setConstParaOpt(recvMsg.res_login_get_const_para_opt());
        conn.setDbTz(recvMsg.res_login_get_db_tz());
        conn.setNewLobFlag(recvMsg.res_login_get_new_lob_flag());
        String serverEncoding = conn.getServerEncoding();
        int tmpLen = 0;
        int offset = 64;
        tmpLen = (int)recvMsg.getInt(offset += recvMsg.getErrlen());
        String instance = recvMsg.getString(offset += 4, tmpLen, serverEncoding);
        conn.setInstanceName(instance);
        offset += tmpLen;
        tmpLen = (int)recvMsg.getInt(offset);
        String currentSch = recvMsg.getString(offset += 4, tmpLen, serverEncoding);
        conn.setSchema(currentSch);
        offset += tmpLen;
        tmpLen = (int)recvMsg.getInt(offset);
        String lastLoginIP = recvMsg.getString(offset += 4, tmpLen);
        offset += tmpLen;
        conn.setLastLoginIP(lastLoginIP);
        tmpLen = (int)recvMsg.getInt(offset);
        String lastLoginTime = recvMsg.getString(offset += 4, tmpLen, serverEncoding);
        conn.setLastLoginTime(lastLoginTime);
        conn.setFailedAttempt((int)recvMsg.getInt(offset += tmpLen));
        conn.setLoginWarningID((int)recvMsg.getInt(offset += 4));
        conn.setGraceTimeRemainder((int)recvMsg.getInt(offset += 4));
        int guidLen = (int)recvMsg.getInt(offset += 4);
        String guid = recvMsg.getString(offset += 4, guidLen);
        conn.setGUID(guid);
        tmpLen = (int)recvMsg.getInt(offset += guidLen);
        String dbName = recvMsg.getString(offset += 4, tmpLen);
        offset += tmpLen;
        conn.setCurrentDBName(dbName);
        if (recvMsg.res_login_get_resp_standby() == 0) {
            return;
        }
        tmpLen = (int)recvMsg.getInt(offset);
        if (tmpLen > 0) {
            String sIP = recvMsg.getString(offset += 4, tmpLen);
            int sPort = (int)recvMsg.getInt(offset += tmpLen);
            offset += 4;
            conn.setStandbyInfo(sIP, sPort);
            offset += 2;
        }
    }

    public static final void req_stmt_alloc(DmMsgSend msg) {
        Request_Response.req_initMsg(msg);
        msg.req_alloc_stmt_set_new_col_desc_flag((byte)1);
        Request_Response.req_setCommonHead(msg, 0, (short)3, 0);
    }

    public static final int resp_stmt_alloc(DmMsgRecv recvMsg, DmdbStatement_bs stmt) throws SQLException {
        Request_Response.resp_checkErr(recvMsg, stmt.getConnection_bs());
        stmt.setReadBaseColName(recvMsg.res_alloc_stmt_get_new_col_desc_flag() == 1);
        return recvMsg.res_get_stmtid();
    }

    public static final void req_stmt_free(DmMsgSend msg, int handle) {
        Request_Response.req_initMsg(msg);
        Request_Response.req_setCommonHead(msg, handle, (short)4, 0);
    }

    public static final void resp_stmt_free(DmMsgRecv recvMsg, DmdbConnection_bs conn) throws SQLException {
        Request_Response.resp_checkErr(recvMsg, conn);
    }

    public static final void req_prepare(DmMsgSend msg, DmdbStatement_bs stmt, String sql, boolean direct, int checkFlag) throws SQLException {
        Request_Response.req_initMsg(msg);
        DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
        if (conn.getAutoCommit()) {
            msg.req_prepare_set_auto_cmt((byte)1);
        } else {
            msg.req_prepare_set_auto_cmt((byte)0);
        }
        if (direct) {
            msg.req_prepare_set_exec_direct((byte)1);
        } else {
            msg.req_prepare_set_exec_direct((byte)0);
        }
        msg.req_prepare_set_check_type((byte)1);
        msg.req_prepare_set_sql_Type((short)checkFlag);
        if (stmt.getMaxRowsInner() == 0) {
            msg.req_prepare_set_fetch_max(Long.MAX_VALUE);
        } else {
            msg.req_prepare_set_fetch_max(stmt.getMaxRowsInner());
        }
        if (stmt.getResultSetType() == 1003) {
            msg.req_prepare_set_cur_forward_only((byte)1);
        } else {
            msg.req_prepare_set_cur_forward_only((byte)0);
        }
        if (stmt.getConnection_bs().isBdtaRS()) {
            msg.req_prepare_set_rs_bdta_flag((byte)2);
        } else {
            msg.req_prepare_set_rs_bdta_flag((byte)0);
        }
        msg.req_prepare_set_ret_id_flag((byte)(stmt.autoGeneratedKeys() ? 1 : 0));
        msg.req_prepare_set_query_time_out(stmt.getQueryTimeout());
        int len = msg.setStringWithNTS(sql, conn.getServerEncoding(), 64);
        Request_Response.req_setCommonHead(msg, stmt.getHandle(), (short)5, len);
    }

    public static final DmdbInfo resp_prepare(DmMsgRecv recvMsg, String serverEncoding, DmdbStatement_bs stmt, boolean direct) throws SQLException {
        int sqlcode = Request_Response.resp_checkErr(recvMsg, (DmdbConnection_bs)stmt.getConnection());
        DmdbInfo des = stmt.getDmdbInfoNRS();
        des.setSQLCode(0);
        if (sqlcode > 0) {
            des.setSQLCode(sqlcode);
        }
        int cursorHandle = recvMsg.res_get_stmtid();
        if (direct) {
            return Request_Response.resp_prepare_direct(recvMsg, stmt, sqlcode, cursorHandle);
        }
        return Request_Response.resp_prepare_indirect(recvMsg, stmt, cursorHandle);
    }

    private static DmdbInfo resp_prepare_direct(DmMsgRecv recvMsg, DmdbStatement_bs stmt, int sqlcode, int refHandle) throws SQLException {
        return Request_Response.resp_execute_without_checkErr(recvMsg, stmt, sqlcode, refHandle);
    }

    private static DmdbInfo resp_prepare_indirect(DmMsgRecv recvMsg, DmdbStatement_bs stmt, int refHandle) throws SQLException {
        short paraNum = recvMsg.res_prepare_get_param_num();
        short colNum = recvMsg.res_prepare_get_col_num();
        DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
        short retCmd = recvMsg.res_prepare_get_ret_type();
        DmdbInfo des = stmt.getDmdbInfoNRS();
        des.setRetStmtType(retCmd);
        conn.setTransStatus(recvMsg.res_prepare_get_trans_status());
        if (retCmd == 201 || retCmd == 200) {
            stmt.cursorUpdateRow = conn.getCurpos(refHandle);
        }
        int offset = 64;
        offset = Request_Response.resp_getParaDesc(recvMsg, offset, paraNum, des, stmt);
        offset = Request_Response.resp_getColDesc(recvMsg, offset, colNum, des, stmt);
        return des;
    }

    public static final void req_execute(boolean preExeced, DmMsgSend msg, DmdbStatement_bs stmt, long curPos, int irow) throws SQLException {
        int retLen = 0;
        DmdbPreparedStatement_bs pstmt = null;
        Request_Response.req_initMsg(msg);
        int paramCnt = 0;
        DmBinder[] binders = null;
        if (stmt instanceof DmdbPreparedStatement_bs) {
            pstmt = (DmdbPreparedStatement_bs)stmt;
            binders = pstmt.getParamBoundDesc();
            paramCnt = binders.length;
        }
        Request_Response.req_execute_cmd_head(msg, stmt, curPos, 1, paramCnt);
        if (paramCnt > 0) {
            retLen += Request_Response.req_execute_cmd_body_paratype(msg, irow, binders, false);
            retLen += Request_Response.req_execute_cmd_body_paraData(false, preExeced, msg, pstmt, irow, binders);
        }
        if (stmt.getConnection_bs().getIsExecute2()) {
            Request_Response.req_setCommonHead(msg, stmt.getHandle(), (short)13, retLen);
        } else {
            Request_Response.req_setCommonHead(msg, stmt.getHandle(), (short)6, retLen);
        }
    }

    public static final void req_execute_sendCurInfo(boolean preExeced, DmMsgSend msg, DmdbStatement_bs stmt, long curPos) throws SQLException {
        Request_Response.req_initMsg(msg);
        Request_Response.req_execute_cmd_head(msg, stmt, curPos, 1, 0);
        if (stmt.getConnection_bs().getIsExecute2()) {
            Request_Response.req_setCommonHead(msg, stmt.getHandle(), (short)13, 0);
        } else {
            Request_Response.req_setCommonHead(msg, stmt.getHandle(), (short)6, 0);
        }
    }

    public static final int req_execute_for_batch(boolean preExeced, int curRow, DmMsgSend msg, DmdbPreparedStatement_bs stmt) throws SQLException {
        int batchSize;
        int startRow = curRow;
        int nextRow = batchSize = stmt.getBatchSize();
        int typeLen = 0;
        int totalLen = 0;
        DmBinder[] binder = stmt.getParamBoundDesc();
        int paramCount = binder.length;
        Request_Response.req_initMsg(msg);
        int i = startRow;
        while (i < batchSize) {
            int dateLen;
            if (i == startRow) {
                typeLen = Request_Response.req_execute_cmd_body_paratype(msg, startRow, binder, true);
                totalLen += typeLen;
            }
            if ((dateLen = Request_Response.req_execute_cmd_body_paraData(true, preExeced, msg, stmt, i, binder)) == 0) {
                nextRow = i;
                break;
            }
            totalLen += dateLen;
            ++i;
        }
        if (startRow == nextRow) {
            return nextRow;
        }
        Request_Response.req_execute_cmd_head(msg, stmt, stmt.cursorUpdateRow, nextRow - startRow, paramCount);
        if (stmt.getConnection_bs().getIsExecute2()) {
            Request_Response.req_setCommonHead(msg, stmt.getHandle(), (short)13, totalLen);
        } else {
            Request_Response.req_setCommonHead(msg, stmt.getHandle(), (short)6, totalLen);
        }
        return nextRow;
    }

    public static final int[] resp_execute_for_batch(DmMsgRecv recv, DmdbStatement_bs stmt) throws SQLException {
        DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
        int sqlcode = Request_Response.resp_checkErr(recv, conn);
        DmdbInfo des = stmt.getDmdbInfoNRS();
        des = Request_Response.resp_execute_cmd_head(recv, des, stmt);
        int[] rowCounts = null;
        int offset = 64;
        long msgLen = recv.res_get_len();
        if ((long)offset >= msgLen + 64L) {
            return rowCounts;
        }
        if (des.hasBatchRowCnt()) {
            int counts = (int)recv.getInt(offset);
            offset += 4;
            rowCounts = new int[counts];
            int i = 0;
            while (i < counts) {
                rowCounts[i] = (int)recv.getLong(offset);
                offset += 8;
                ++i;
            }
        }
        if (des.hasRetIds()) {
            int rows = (int)recv.getInt(offset);
            offset += 4;
            long[] retIds = new long[rows];
            int i = 0;
            while (i < rows) {
                retIds[i] = recv.getLong(offset);
                offset += 8;
                ++i;
            }
            stmt.setRetIds(retIds);
        }
        if (sqlcode == 121) {
            if (stmt instanceof DmdbPreparedStatement_bs) {
                ((DmdbPreparedStatement_bs)stmt).setBpWithErr(true);
            }
            offset = Request_Response.resp_exec_build_idu_warn_diag(recv, conn, offset, rowCounts);
        }
        return rowCounts;
    }

    private static int resp_exec_build_idu_warn_diag(DmMsgRecv recv, DmdbConnection_bs conn, int offset, int[] rowCounts) {
        int warn_cnt = (int)recv.getInt(offset += 4);
        offset += 4;
        int i = 0;
        while (i < warn_cnt) {
            int rowi = (int)recv.getInt(offset);
            rowCounts[rowi] = -3;
            int code = (int)recv.getInt(offset += 4);
            int err_len = recv.getShort(offset += 4);
            offset += 2;
            String errStr = "";
            if (err_len > 0) {
                errStr = Convertion.getString(recv.getBuffer(), offset, err_len, conn.getServerEncoding());
                offset += err_len;
            }
            SQLWarning warning = new SQLWarning("row[" + rowi + "]:" + code + ", " + errStr);
            conn.addWarnings(warning);
            ++i;
        }
        return offset;
    }

    private static void req_execute_cmd_head(DmMsgSend msg, DmdbStatement_bs stmt, long curPos, int rowCnt, int paramCnt) throws SQLException {
        if (stmt.getConnection().getAutoCommit()) {
            msg.req_execute_set_auto_cmt((byte)1);
        } else {
            msg.req_execute_set_auto_cmt((byte)0);
        }
        if (stmt.getResultSetType() == 1003) {
            msg.req_execute_set_cur_forward_only((byte)1);
        } else {
            msg.req_execute_set_cur_forward_only((byte)0);
        }
        if (stmt.getMaxRowsInner() == 0) {
            msg.req_execute_set_fetch_max(Long.MAX_VALUE);
        } else {
            msg.req_execute_set_fetch_max(stmt.getMaxRowsInner());
        }
        msg.req_execute_set_row_num(rowCnt);
        msg.req_execute_set_param_num((short)paramCnt);
        msg.req_execute_set_cur_pos(curPos);
        if (stmt.autoGeneratedKeys()) {
            msg.req_execute_set_ret_id_flag((byte)1);
        } else {
            msg.req_execute_set_ret_id_flag((byte)0);
        }
        if (stmt.getConnection_bs().getContinueBatchOnError()) {
            msg.req_execute_set_ign_bp_err((byte)1);
        } else {
            msg.req_execute_set_ign_bp_err((byte)0);
        }
        msg.req_execute_set_query_time_out(stmt.getQueryTimeout());
    }

    private static int req_execute_cmd_body_paratype(DmMsgSend msg, int irow, DmBinder[] binders, boolean forBatch) throws SQLException {
        int paramTotal = binders == null ? 0 : binders.length;
        int retLen = 0;
        int i = 0;
        while (i < paramTotal) {
            retLen += binders[i].bindDesc(msg, irow, i, forBatch);
            ++i;
        }
        return retLen;
    }

    private static int req_execute_cmd_body_paraData(boolean forBatch, boolean preExeced, DmMsgSend msgSend, DmdbPreparedStatement_bs stmt, int irow, DmBinder[] binders) throws SQLException {
        int paramTotal = binders == null ? 0 : binders.length;
        int retLen = 0;
        int i = 0;
        while (i < paramTotal) {
            block12: {
                int dateLen;
                block11: {
                    if (!(binders[i] instanceof DmOutParamBinder) || !binders[i].checkIOType((byte)1) && !binders[i].checkIOType((byte)2)) break block11;
                    int outLen = stmt.getNullIndicator(irow, i) == 1 ? DmNullBinder.bindData(msgSend) : binders[i].bindData(msgSend, irow, i, forBatch);
                    if (outLen != 0) {
                        retLen += outLen;
                    }
                    if (outLen != 0 || binders[i].checkIOType((byte)1)) break block12;
                }
                if ((dateLen = stmt.getNullIndicator(irow, i) == 1 ? DmNullBinder.bindData(msgSend) : binders[i].bindData(msgSend, irow, i, forBatch)) == -1) {
                    if (forBatch) {
                        msgSend.cutBufferLen(retLen);
                        return 0;
                    }
                    msgSend.setParamDataLength(0);
                    retLen += 2;
                    if (!preExeced) {
                        DmdbCSI.preExec(stmt, irow, binders, forBatch);
                    }
                    preExeced = true;
                    DmdbCSI.putBlobData(stmt, irow, i, binders[i]);
                } else {
                    retLen += dateLen;
                }
            }
            ++i;
        }
        i = 0;
        while (i < paramTotal) {
            if (binders[i] instanceof DmInputStreamBinder || binders[i] instanceof DmReaderBinder) {
                binders[i].clearRetValue();
            }
            ++i;
        }
        return retLen;
    }

    public static final DmdbInfo resp_execute(DmMsgRecv recv, DmdbStatement_bs stmt) throws SQLException {
        DmdbConnection_bs connect = (DmdbConnection_bs)stmt.getConnection();
        int sqlcode = Request_Response.resp_checkErr(recv, connect);
        return Request_Response.resp_execute_without_checkErr(recv, stmt, sqlcode, 0);
    }

    private static DmdbInfo resp_execute_without_checkErr(DmMsgRecv recv, DmdbStatement_bs stmt, int sqlcode, int refHandle) throws SQLException {
        DmdbInfo des = stmt.getDmdbInfoNRS();
        des = Request_Response.resp_execute_cmd_head(recv, des, stmt);
        DmdbConnection_bs connect = (DmdbConnection_bs)stmt.getConnection();
        DmdbPreparedStatement_bs pstmt = null;
        int outParamCount = des.getParmCount();
        int offset = 64;
        int printMsgLen = 0;
        if (sqlcode == 111) {
            des.setRowCount(-1L);
        }
        switch (des.getRetStmtType()) {
            case 165: {
                des.setSavepointFlag(true);
                short tz = (short)recv.getShort(offset);
                offset += 2;
                connect.setTz(tz);
                break;
            }
            case 200: 
            case 201: {
                if (stmt instanceof DmdbPreparedStatement_bs) {
                    pstmt = (DmdbPreparedStatement_bs)stmt;
                    if (outParamCount > 0) {
                        offset = Request_Response.resp_execute_cmd_head_param(recv, pstmt.getParamBoundDesc(), outParamCount, offset);
                    }
                }
                if (107 != sqlcode) break;
                stmt.cursorUpdateRow = connect.getCurpos(refHandle);
                recv = DmdbCSI.sendCurPosInfo(stmt, stmt.cursorUpdateRow);
                break;
            }
            case 166: {
                des.setSavepointFlag(true);
                switch (recv.getShort(offset)) {
                    case 1: {
                        connect.setTransLevel(2);
                        break;
                    }
                    case 3: {
                        connect.setTransLevel(8);
                        break;
                    }
                    default: {
                        connect.setTransLevel(0);
                    }
                }
                connect.setTransAccessMode(recv.getByte(offset += 2));
                ++offset;
                break;
            }
            case 153: {
                des.setSavepointFlag(true);
                int schlen = (int)recv.getInt(offset);
                String schname = recv.getString(offset += 4, schlen, connect.getServerEncoding());
                connect.setSchema(schname);
                offset += schlen;
                break;
            }
            case 149: {
                int exlen = (int)recv.getInt(offset);
                String exStr = recv.getString(offset += 4, exlen, connect.getServerEncoding());
                des.setExplain(exStr);
                offset += exlen;
                break;
            }
            case 160: {
                printMsgLen = (int)des.getPrintLen();
                if (printMsgLen > 0) {
                    String val = recv.getString(offset, printMsgLen, connect.getServerEncoding());
                    des.setPrintMsg(val);
                    offset += printMsgLen;
                }
                if (111 == sqlcode) break;
                offset = Request_Response.resp_getColDesc(recv, offset, des.getColCount(), des, stmt);
                int rowidCol = -1;
                if (des.isBdtaRs()) {
                    rowidCol = recv.res_execute_rs_rowid_colindex();
                }
                des.setHasResultSet(true);
                Request_Response.resp_getResultSetData(stmt, recv, des.getRowCount(), des.getColumnsInfo(), offset, des.getRsCacheOffset(), rowidCol, des.isBdtaRs());
                break;
            }
            case 162: {
                printMsgLen = (int)des.getPrintLen();
                if (printMsgLen > 0) {
                    String val = recv.getString(offset, printMsgLen, connect.getServerEncoding());
                    des.setPrintMsg(val);
                    offset += printMsgLen;
                }
                if (stmt instanceof DmdbPreparedStatement_bs) {
                    pstmt = (DmdbPreparedStatement_bs)stmt;
                    if (outParamCount > 0) {
                        offset = Request_Response.resp_execute_cmd_head_param(recv, pstmt.getParamBoundDesc(), outParamCount, offset);
                    }
                }
                if (111 == sqlcode) break;
                offset = Request_Response.resp_getColDesc(recv, offset, des.getColCount(), des, stmt);
                int rowidCol = -1;
                if (des.isBdtaRs()) {
                    rowidCol = recv.res_execute_rs_rowid_colindex();
                }
                Request_Response.resp_getResultSetData(stmt, recv, des.getRowCount(), des.getColumnsInfo(), offset, des.getRsCacheOffset(), rowidCol, des.isBdtaRs());
                break;
            }
            case 161: {
                pstmt = (DmdbPreparedStatement_bs)stmt;
                if (outParamCount <= 0) break;
                offset = Request_Response.resp_execute_cmd_head_param(recv, pstmt.getParamBoundDesc(), outParamCount, offset);
                break;
            }
            case 159: {
                if (stmt instanceof DmdbPreparedStatement_bs) {
                    pstmt = (DmdbPreparedStatement_bs)stmt;
                    if (outParamCount > 0) {
                        offset = Request_Response.resp_execute_cmd_head_param(recv, pstmt.getParamBoundDesc(), outParamCount, offset);
                    }
                }
                des.setHasResultSet(false);
                if (sqlcode != 111) break;
                des.setRowCount(-1L);
                break;
            }
            case 158: {
                if (stmt instanceof DmdbPreparedStatement_bs) {
                    pstmt = (DmdbPreparedStatement_bs)stmt;
                    if (outParamCount > 0) {
                        offset = Request_Response.resp_execute_cmd_head_param(recv, pstmt.getParamBoundDesc(), outParamCount, offset);
                    }
                }
                des.setHasResultSet(false);
                if (sqlcode != 111) break;
                des.setRowCount(-1L);
                break;
            }
            case 157: {
                if (des.hasRetIds() && stmt.autoGeneratedKeys()) {
                    long[] retIds = new long[]{des.getRowId()};
                    stmt.setRetIds(retIds);
                }
                if (!(stmt instanceof DmdbPreparedStatement_bs) && !(stmt instanceof DmdbCallableStatement_bs)) break;
                pstmt = (DmdbPreparedStatement_bs)stmt;
                if (outParamCount <= 0) break;
                offset = Request_Response.resp_execute_cmd_head_param(recv, pstmt.getParamBoundDesc(), outParamCount, offset);
                break;
            }
            case 147: 
            case 148: 
            case 151: {
                des.setSavepointFlag(true);
                break;
            }
            default: {
                des.setHasResultSet(false);
                if (sqlcode != 111) break;
                des.setRowCount(-1L);
            }
        }
        return des;
    }

    private static DmdbInfo resp_execute_cmd_head(DmMsgRecv recv, DmdbInfo des, DmdbStatement_bs stmt) throws SQLException {
        short ret_type = recv.res_execute_get_ret_type();
        if (ret_type != 0) {
            des.setRetStmtType(recv.res_execute_get_ret_type());
        }
        des.setColCount(recv.res_execute_get_col_num());
        des.setRowCount(recv.res_execute_get_row_num());
        des.setParmCount(recv.res_execute_get_param_num());
        if (recv.res_execute_get_rs_updatable() == 0) {
            des.setUpdatable(false);
        } else {
            des.setUpdatable(true);
        }
        des.setFetchedRows(recv.res_execute_get_fetched_rows());
        des.setPrintLen(recv.getOffsetOfPrintMsg());
        if (des.getRetStmtType() == 160 || des.getRetStmtType() == 162) {
            des.setRowId(0L);
            des.setBdtaRs(recv.res_execute_rs_bdta_flag() == 2);
        } else {
            des.setRowId(recv.res_execute_get_rowid());
        }
        stmt.setExecuteId(recv.res_execute_get_exid());
        des.setRsCacheOffset(recv.res_rsCache_offset());
        des.setBatchRowCntFlag(recv.res_execute_rowcnt_flag());
        des.setRetIdsFlag(recv.res_execute_retid_flag());
        DmdbConnection_bs conn = stmt.getConnection_bs();
        conn.setTransStatus(recv.res_execute_trans_status());
        return des;
    }

    private static int resp_execute_cmd_head_param(DmMsgRecv recv, DmBinder[] binders, int outParaNum, int offset) throws SQLException {
        int[] foot = new int[outParaNum];
        int allParamCount = binders.length;
        int j = 0;
        int i = 0;
        while (i < allParamCount) {
            if (!binders[i].checkIOType((byte)0)) {
                foot[j] = i;
                ++j;
            }
            ++i;
        }
        byte[] value = null;
        int i2 = 0;
        while (i2 < outParaNum) {
            boolean isOutNull = false;
            long outParamValueLen = recv.getShort(offset);
            offset += 2;
            if (outParamValueLen == 65534L) {
                outParamValueLen = 0L;
                isOutNull = true;
            } else if (outParamValueLen == 65535L) {
                outParamValueLen = recv.getInt(offset);
                offset += 4;
            }
            if (isOutNull) {
                binders[foot[i2]].setOutValue(null);
                binders[foot[i2]].setOutNullFlag(true);
            } else {
                if (outParamValueLen > Integer.MAX_VALUE) {
                    throw new SQLException(Const.res.getString("error.valLenTLong"));
                }
                value = recv.getBytes(offset, (int)outParamValueLen);
                binders[foot[i2]].setOutValue(value);
                binders[foot[i2]].setOutNullFlag(false);
            }
            offset = (int)((long)offset + outParamValueLen);
            binders[foot[i2]].setOutValueFromStandby(recv.getFromStandby());
            ++i2;
        }
        return offset;
    }

    public static final void req_exec_direct(DmMsgSend msg, DmdbStatement_bs stmt, DmdbExecOpt execOpt) throws SQLException {
        Request_Response.req_initMsg(msg);
        Request_Response.req_execute_cmd_head(msg, stmt, stmt.cursorUpdateRow, 1, execOpt.getParamCount());
        int offset = 64;
        DmdbConnection_bs conn = (DmdbConnection_bs)stmt.getConnection();
        String sql = execOpt.getSqlStr();
        int len = msg.setStringWithNTS(sql, conn.getServerEncoding(), offset);
        msg.setBytes(execOpt.getTypes(), 0, offset += len, execOpt.getTypesLen());
        msg.setBytes(execOpt.getValues(), 0, offset += execOpt.getTypesLen(), execOpt.getValuesLen());
        Request_Response.req_setCommonHead(msg, stmt.getHandle(), (short)91, (offset += execOpt.getValuesLen()) - 64);
    }

    public static final DmdbInfo resp_exec_direct(DmMsgRecv recv, DmdbStatement_bs stmt) throws SQLException {
        return Request_Response.resp_execute(recv, stmt);
    }

    public static final void req_pre_exec(int handle, DmMsgSend blobMsg, int irow, DmBinder[] binders, boolean forBatch) throws SQLException {
        Request_Response.req_initMsg(blobMsg);
        int paramTotal = binders.length;
        blobMsg.req_preexec_set_param_num((short)paramTotal);
        int msgLen = 0;
        int i = 0;
        while (i < paramTotal) {
            msgLen += binders[i].bindDesc(blobMsg, irow, i, forBatch);
            ++i;
        }
        Request_Response.req_setCommonHead(blobMsg, handle, (short)90, msgLen);
    }

    public static final void resp_pre_exec(DmMsgRecv recvMsg, DmdbConnection_bs conn) throws SQLException {
        Request_Response.resp_checkErr(recvMsg, conn);
    }

    public static final void req_fetch(DmMsgSend msg, int handle, DataOfFetch dataFetch) {
        Request_Response.req_initMsg(msg);
        msg.req_fetch_set_row_count(dataFetch.getRowCntToGet());
        msg.req_fetch_set_cur_pos(dataFetch.getCurPos());
        msg.req_fetch_set_res_id(dataFetch.getResId());
        Request_Response.req_setCommonHead(msg, handle, (short)7, 0);
    }

    public static final int resp_fetch_checkErr(DmMsgRecv recvMsg, DmdbConnection_bs conn) throws SQLException {
        return Request_Response.resp_checkErr(recvMsg, conn);
    }

    public static final byte[] resp_fetch_without_checkErr(DmMsgRecv recvMsg, DataOfFetch dataOfFetch, DmdbResultSet_bs resultSet, byte[] buf, boolean isFetchData) throws SQLException {
        int bufLen = 32640;
        long msgBufLen = 0L;
        long totalLen = dataOfFetch.getMsglen_total();
        int fetchNum = dataOfFetch.getResRowCnt_get();
        long curPos = dataOfFetch.getCurPos();
        if (isFetchData) {
            byte[] buf2 = null;
            if (buf == null) {
                buf = new byte[bufLen];
            }
            if (totalLen + (msgBufLen = recvMsg.res_get_len()) > (long)bufLen) {
                buf2 = new byte[(int)(totalLen + msgBufLen)];
                System.arraycopy(buf, 0, buf2, 0, buf.length);
                buf = buf2;
            }
            int offset = dataOfFetch.getOffset();
            System.arraycopy(recvMsg.getBuffer(), 64, buf, offset, (int)msgBufLen);
            offset = (int)((long)offset + recvMsg.res_get_len());
            dataOfFetch.setOffset(offset);
            if (recvMsg.res_fetch_get_row_count() != Long.MAX_VALUE && resultSet != null) {
                resultSet.rowCount = recvMsg.res_fetch_get_row_count();
            }
        }
        dataOfFetch.setResRowCnt_get(fetchNum += recvMsg.res_fetch_get_ret_count());
        dataOfFetch.setCurPos(curPos += (long)recvMsg.res_fetch_get_ret_count());
        dataOfFetch.setResRowCnt_total(recvMsg.res_fetch_get_row_count());
        dataOfFetch.setMsglen_total(totalLen += recvMsg.res_get_len());
        return buf;
    }

    public static final void req_commit(DmMsgSend msg) {
        Request_Response.req_initMsg(msg);
        Request_Response.req_setCommonHead(msg, 0, (short)8, 0);
    }

    public static final int resp_commit(DmMsgRecv recvMsg, DmdbConnection_bs conn) throws SQLException {
        return Request_Response.resp_checkErr(recvMsg, conn);
    }

    public static final void req_rollback(DmMsgSend msg) {
        Request_Response.req_initMsg(msg);
        Request_Response.req_setCommonHead(msg, 0, (short)9, 0);
    }

    public static final int resp_rollback(DmMsgRecv recvMsg, DmdbConnection_bs conn) throws SQLException {
        return Request_Response.resp_checkErr(recvMsg, conn);
    }

    public static final void req_close_stmt(DmMsgSend msg, int handle) {
        Request_Response.req_initMsg(msg);
        Request_Response.req_setCommonHead(msg, handle, (short)17, 0);
    }

    public static final void resp_close_stmt(DmMsgRecv recvMsg, DmdbConnection_bs conn) throws SQLException {
        Request_Response.resp_checkErr(recvMsg, conn);
    }

    public static final void req_cursor_set_name(DmMsgSend msg, String serverEncoding, int handle, String cursorName) throws SQLException {
        if (cursorName == null) {
            DBError.throwSQLException(6036);
        }
        Request_Response.req_initMsg(msg);
        int len = msg.setStringWithNTS(cursorName, serverEncoding, 64);
        msg.setInt(1);
        Request_Response.req_setCommonHead(msg, handle, (short)27, len += 4);
    }

    public static final void resp_cursor_set_name(DmMsgRecv recvMsg, DmdbConnection_bs conn) throws SQLException {
        Request_Response.resp_checkErr(recvMsg, conn);
    }

    public static final void req_put_data(int handle, DmMsgSend blobMsg, int paramIndex, int len) {
        int msgLen = 64 + len;
        blobMsg.req_putdata_set_para_index((short)paramIndex);
        Request_Response.req_setCommonHead(blobMsg, handle, (short)14, msgLen - 64);
    }

    public static final void resp_put_data(DmMsgRecv recvMsg, DmdbConnection_bs conn) throws SQLException {
        Request_Response.resp_checkErr(recvMsg, conn);
    }

    public static final void req_get_data(DmMsgSend msg, int handle, int cntHasGet, DmdbLobLocator lobLocator) {
        Request_Response.req_initMsg(msg);
        int offset = 64;
        msg.setByte(lobLocator.m_lobFlag, 64);
        msg.setBytes(lobLocator.m_tableId, 0, ++offset, lobLocator.m_tableId.length);
        msg.setBytes(lobLocator.m_colId, 0, offset += lobLocator.m_tableId.length, lobLocator.m_colId.length);
        msg.setBytes(lobLocator.m_blobId, 0, offset += lobLocator.m_colId.length, lobLocator.m_blobId.length);
        msg.setBytes(lobLocator.m_data_groupId, 0, offset += lobLocator.m_blobId.length, lobLocator.m_data_groupId.length);
        msg.setBytes(lobLocator.m_data_fileId, 0, offset += lobLocator.m_data_groupId.length, lobLocator.m_data_fileId.length);
        msg.setBytes(lobLocator.m_data_pageNo, 0, offset += lobLocator.m_data_fileId.length, lobLocator.m_data_pageNo.length);
        msg.setBytes(lobLocator.m_curFileId, 0, offset += lobLocator.m_data_pageNo.length, 2);
        msg.setBytes(lobLocator.m_curPageNo, 0, offset += lobLocator.m_curFileId.length, 4);
        msg.setBytes(lobLocator.m_curPageOffset, 0, offset += lobLocator.m_curPageNo.length, 2);
        msg.setInt(lobLocator.m_blobLen - cntHasGet, offset += lobLocator.m_curPageOffset.length);
        Request_Response.req_setCommonHead(msg, handle, (short)15, (offset += 4) - 64);
    }

    public static final boolean resp_get_data(DmMsgRecv recvMsg, DmdbConnection_bs conn, DmdbLobLocator locator, int hasGet) throws SQLException {
        Request_Response.resp_checkErr(recvMsg, conn);
        int offset = 64;
        boolean isOver = recvMsg.getByte(offset) == 1;
        int aBlockLen = (int)recvMsg.getInt(++offset);
        locator.setCurFieldId(recvMsg.getBytes(offset += 4, 2));
        locator.setCurPageNo(recvMsg.getBytes(offset += 2, 4));
        locator.setCurPageOffSet(recvMsg.getBytes(offset += 4, 2));
        int copyLen = hasGet + aBlockLen > locator.m_blobLen ? locator.m_blobLen - hasGet : aBlockLen;
        locator.m_dataOnceGet = recvMsg.getBytes(offset += 2, copyLen);
        return isOver;
    }

    public static final void req_get_lob_len(DmMsgSend lobMsg, DmdbLobLocator lobLocator) {
        Request_Response.req_initMsg(lobMsg);
        int offset = 64;
        lobMsg.setByte(lobLocator.m_lobFlag, offset);
        lobMsg.setBytes(lobLocator.m_blobId, 0, ++offset, lobLocator.m_blobId.length);
        lobMsg.setBytes(lobLocator.m_data_groupId, 0, offset += lobLocator.m_blobId.length, lobLocator.m_data_groupId.length);
        lobMsg.setBytes(lobLocator.m_data_fileId, 0, offset += lobLocator.m_data_groupId.length, lobLocator.m_data_fileId.length);
        lobMsg.setBytes(lobLocator.m_data_pageNo, 0, offset += lobLocator.m_data_fileId.length, lobLocator.m_data_pageNo.length);
        offset += lobLocator.m_data_pageNo.length;
        if (lobLocator.m_new_lob_flag) {
            lobMsg.setBytes(lobLocator.m_tableId, 0, offset, lobLocator.m_tableId.length);
            lobMsg.setBytes(lobLocator.m_colId, 0, offset += lobLocator.m_tableId.length, lobLocator.m_colId.length);
            lobMsg.setBytes(lobLocator.m_rowId, 0, offset += lobLocator.m_colId.length, lobLocator.m_rowId.length);
            lobMsg.setBytes(lobLocator.m_rec_groupId, 0, offset += lobLocator.m_rowId.length, lobLocator.m_rec_groupId.length);
            lobMsg.setBytes(lobLocator.m_rec_fileId, 0, offset += lobLocator.m_rec_groupId.length, lobLocator.m_rec_fileId.length);
            lobMsg.setBytes(lobLocator.m_rec_pageNo, 0, offset += lobLocator.m_rec_fileId.length, lobLocator.m_rec_pageNo.length);
            offset += lobLocator.m_rec_pageNo.length;
        }
        Request_Response.req_setCommonHead(lobMsg, 0, (short)29, offset - 64);
    }

    public static final long resp_get_lob_len(DmMsgRecv recvMsg, DmdbLob lob) throws SQLException {
        Request_Response.resp_checkErr(recvMsg, lob.getConnection());
        return recvMsg.getInt(64);
    }

    public static final void req_get_lob_data(DmMsgSend blobMsg, DmdbLobLocator lobLocator, int start_pos, int length) {
        Request_Response.req_initMsg(blobMsg);
        int offset = 64;
        blobMsg.setByte(lobLocator.m_lobFlag, 64);
        blobMsg.setBytes(lobLocator.m_tableId, 0, ++offset, lobLocator.m_tableId.length);
        blobMsg.setBytes(lobLocator.m_colId, 0, offset += lobLocator.m_tableId.length, lobLocator.m_colId.length);
        blobMsg.setBytes(lobLocator.m_blobId, 0, offset += lobLocator.m_colId.length, lobLocator.m_blobId.length);
        blobMsg.setBytes(lobLocator.m_data_groupId, 0, offset += lobLocator.m_blobId.length, lobLocator.m_data_groupId.length);
        blobMsg.setBytes(lobLocator.m_data_fileId, 0, offset += lobLocator.m_data_groupId.length, lobLocator.m_data_fileId.length);
        blobMsg.setBytes(lobLocator.m_data_pageNo, 0, offset += lobLocator.m_data_fileId.length, lobLocator.m_data_pageNo.length);
        blobMsg.setBytes(lobLocator.m_curFileId, 0, offset += lobLocator.m_data_pageNo.length, lobLocator.m_curFileId.length);
        blobMsg.setBytes(lobLocator.m_curPageNo, 0, offset += lobLocator.m_curFileId.length, lobLocator.m_curPageNo.length);
        blobMsg.setBytes(lobLocator.m_TotalOffset, 0, offset += lobLocator.m_curPageNo.length, lobLocator.m_TotalOffset.length);
        blobMsg.setInt(start_pos, offset += lobLocator.m_TotalOffset.length);
        blobMsg.setInt(length, offset += 4);
        offset += 4;
        if (lobLocator.m_new_lob_flag) {
            blobMsg.setBytes(lobLocator.m_rowId, 0, offset, lobLocator.m_rowId.length);
            blobMsg.setBytes(lobLocator.m_rec_groupId, 0, offset += lobLocator.m_rowId.length, lobLocator.m_rec_groupId.length);
            blobMsg.setBytes(lobLocator.m_rec_fileId, 0, offset += lobLocator.m_rec_groupId.length, lobLocator.m_rec_fileId.length);
            blobMsg.setBytes(lobLocator.m_rec_pageNo, 0, offset += lobLocator.m_rec_fileId.length, lobLocator.m_rec_pageNo.length);
            offset += lobLocator.m_rec_pageNo.length;
        }
        Request_Response.req_setCommonHead(blobMsg, 0, (short)32, offset - 64);
    }

    public static final byte[] resp_get_lob_data(DmMsgRecv recv, DmdbLobLocator lobLocator, DmdbConnection_bs conn) throws SQLException {
        Request_Response.resp_checkErr(recv, conn);
        int offset = 64;
        long len = recv.getInt(++offset);
        if (len <= 0L) {
            return null;
        }
        if (len > Integer.MAX_VALUE) {
            throw new SQLException(Const.res.getString("error.valLenTLong"));
        }
        lobLocator.setCurFieldId(recv.getBytes(offset += 4, 2));
        lobLocator.setCurPageNo(recv.getBytes(offset += 2, 4));
        lobLocator.setTotalOffset(recv.getBytes(offset += 4, 4));
        byte[] value = new byte[(int)len];
        System.arraycopy(recv.getBuffer(), offset += 4, value, 0, (int)len);
        offset = (int)((long)offset + len);
        return value;
    }

    public static final void req_set_lob_data(DmMsgSend msg, DmdbLobLocator lobLocator, int start_pos, byte[] buf, int off, int len, byte firstOrLast) {
        Request_Response.req_initMsg(msg);
        int offset = 64;
        msg.setByte(lobLocator.m_lobFlag, offset);
        msg.setByte(firstOrLast, ++offset);
        msg.setBytes(lobLocator.m_blobId, 0, ++offset, lobLocator.m_blobId.length);
        msg.setBytes(lobLocator.m_data_groupId, 0, offset += lobLocator.m_blobId.length, lobLocator.m_data_groupId.length);
        msg.setBytes(lobLocator.m_data_fileId, 0, offset += lobLocator.m_data_groupId.length, lobLocator.m_data_fileId.length);
        msg.setBytes(lobLocator.m_data_pageNo, 0, offset += lobLocator.m_data_fileId.length, lobLocator.m_data_pageNo.length);
        msg.setBytes(lobLocator.m_curFileId, 0, offset += lobLocator.m_data_pageNo.length, 2);
        msg.setBytes(lobLocator.m_curPageNo, 0, offset += 2, 4);
        msg.setBytes(lobLocator.m_TotalOffset, 0, offset += 4, lobLocator.m_TotalOffset.length);
        msg.setBytes(lobLocator.m_tableId, 0, offset += lobLocator.m_TotalOffset.length, lobLocator.m_tableId.length);
        msg.setBytes(lobLocator.m_colId, 0, offset += lobLocator.m_tableId.length, lobLocator.m_colId.length);
        msg.setBytes(lobLocator.m_rowId, 0, offset += lobLocator.m_colId.length, lobLocator.m_rowId.length);
        msg.setInt(start_pos, offset += lobLocator.m_rowId.length);
        msg.setInt(len, offset += 4);
        msg.setBytes(buf, off, offset += 4, len);
        offset += len;
        if (lobLocator.m_new_lob_flag) {
            msg.setBytes(lobLocator.m_rec_groupId, 0, offset, lobLocator.m_rec_groupId.length);
            msg.setBytes(lobLocator.m_rec_fileId, 0, offset += lobLocator.m_rec_groupId.length, lobLocator.m_rec_fileId.length);
            msg.setBytes(lobLocator.m_rec_pageNo, 0, offset += lobLocator.m_rec_fileId.length, lobLocator.m_rec_pageNo.length);
            offset += lobLocator.m_rec_pageNo.length;
        }
        Request_Response.req_setCommonHead(msg, 0, (short)30, offset - 64);
    }

    public static final int resp_set_lob_data(DmMsgRecv recv, DmdbLobLocator lobLocator, DmdbConnection_bs conn) throws SQLException {
        Request_Response.resp_checkErr(recv, conn);
        int offset = 64;
        int ret = (int)recv.getInt(offset);
        lobLocator.setBlobId(recv.getBytes(offset += 4, 8));
        lobLocator.setGroupId(recv.getBytes(offset += 8, 2));
        lobLocator.setFileId(recv.getBytes(offset += 2, 2));
        lobLocator.setPageNo(recv.getBytes(offset += 2, 4));
        lobLocator.setCurFieldId(recv.getBytes(offset += 4, 2));
        lobLocator.setCurPageNo(recv.getBytes(offset += 2, 4));
        lobLocator.setTotalOffset(recv.getBytes(offset += 4, 4));
        offset += 4;
        return ret;
    }

    public static final void req_lob_truncate(DmMsgSend msg, DmdbLobLocator lobLocator, int length) {
        Request_Response.req_initMsg(msg);
        int offset = 64;
        msg.setByte(lobLocator.m_lobFlag, offset);
        msg.setBytes(lobLocator.m_blobId, 0, ++offset, lobLocator.m_blobId.length);
        msg.setBytes(lobLocator.m_data_groupId, 0, offset += lobLocator.m_blobId.length, lobLocator.m_data_groupId.length);
        msg.setBytes(lobLocator.m_data_fileId, 0, offset += lobLocator.m_data_groupId.length, lobLocator.m_data_fileId.length);
        msg.setBytes(lobLocator.m_data_pageNo, 0, offset += lobLocator.m_data_fileId.length, lobLocator.m_data_pageNo.length);
        msg.setBytes(lobLocator.m_tableId, 0, offset += lobLocator.m_data_pageNo.length, lobLocator.m_tableId.length);
        msg.setBytes(lobLocator.m_colId, 0, offset += lobLocator.m_tableId.length, lobLocator.m_colId.length);
        msg.setBytes(lobLocator.m_rowId, 0, offset += lobLocator.m_colId.length, lobLocator.m_rowId.length);
        msg.setInt(length, offset += lobLocator.m_rowId.length);
        offset += 4;
        if (lobLocator.m_new_lob_flag) {
            msg.setBytes(lobLocator.m_rec_groupId, 0, offset, lobLocator.m_rec_groupId.length);
            msg.setBytes(lobLocator.m_rec_fileId, 0, offset += lobLocator.m_rec_groupId.length, lobLocator.m_rec_fileId.length);
            msg.setBytes(lobLocator.m_rec_pageNo, 0, offset += lobLocator.m_rec_fileId.length, lobLocator.m_rec_pageNo.length);
            offset += lobLocator.m_rec_pageNo.length;
        }
        Request_Response.req_setCommonHead(msg, 0, (short)31, offset - 64);
    }

    public static final long resp_lob_truncate(DmMsgRecv recv, DmdbLobLocator lobLocator, DmdbConnection_bs conn) throws SQLException {
        Request_Response.resp_checkErr(recv, conn);
        int offset = 64;
        long ret = recv.getInt(offset);
        lobLocator.setBlobId(recv.getBytes(offset += 4, 8));
        offset += 8;
        lobLocator.setCurToHead();
        return ret;
    }

    public static final void req_more_result(DmMsgSend msg, int handle, short resId) {
        Request_Response.req_initMsg(msg);
        msg.req_moreres_set_res_id(resId);
        Request_Response.req_setCommonHead(msg, handle, (short)44, 0);
    }

    public static final void req_sess_iso(DmMsgSend msg, int isoLevel) {
        Request_Response.req_initMsg(msg);
        msg.req_sess_iso_set_level(isoLevel);
        Request_Response.req_setCommonHead(msg, 0, (short)52, 0);
    }

    public static final void resp_sess_iso(DmMsgRecv recvMsg, DmdbConnection_bs conn) throws SQLException {
        Request_Response.resp_checkErr(recvMsg, conn);
    }

    public static final short resp_svr_mode(DmMsgRecv recvMsg) {
        return (short)recvMsg.getShort(14);
    }

    public static final short resp_ret_type(DmMsgRecv recvMsg) {
        return (short)recvMsg.getShort(4);
    }

    private static void req_initMsg(DmMsgSend msg) {
        msg.resetCurNode();
    }

    private static void req_setCommonHead(DmMsgSend msg, int handle, short command, int msglen) {
        msg.req_set_cmd(command);
        msg.req_set_len(msglen);
        msg.req_set_stmtid(handle);
    }

    private static void resp_startup_get_msghead(DmMsgRecv recvMsg, DmdbConnection_bs conn) {
        conn.setEncryptMsg(recvMsg.res_startup_get_encrypt_type());
        conn.setGlobalServerSeries(recvMsg.res_startup_get_serial());
        if (1 == recvMsg.res_startup_get_ucflag()) {
            conn.setServerEncoding("UTF-8");
        } else if (2 == recvMsg.res_startup_get_ucflag()) {
            conn.setServerEncoding("EUC-KR");
        } else {
            conn.setServerEncoding("GB18030");
        }
        conn.setComprMsg(recvMsg.res_startup_get_cmpflag());
        if (recvMsg.res_startup_get_rs_bdta_flag() == 0) {
            conn.setIsBdta(false);
        } else {
            conn.setIsBdta(true);
        }
    }

    private static void resp_dbVersionCheck(String verFrmSvr, int len) throws SQLException {
        long valFromSvr = 0L;
        long valLocal = 0L;
        String str = "";
        String tmpStr = "";
        int i = 0;
        while (i < len) {
            if (verFrmSvr.charAt(i) == '.') {
                if (tmpStr.length() == 1) {
                    tmpStr = "0" + tmpStr;
                }
                str = String.valueOf(str) + tmpStr;
                tmpStr = "";
            } else {
                tmpStr = String.valueOf(tmpStr) + verFrmSvr.charAt(i);
            }
            ++i;
        }
        if (tmpStr.length() == 1) {
            tmpStr = "0" + tmpStr;
        }
        str = String.valueOf(str) + tmpStr;
        valFromSvr = new Long(str);
        str = "";
        tmpStr = "";
        String dbVerLocal = DmdbType.getDbProductVer();
        len = dbVerLocal.length();
        i = 0;
        while (i < len) {
            if (dbVerLocal.charAt(i) == '.') {
                if (tmpStr.length() == 1) {
                    tmpStr = "0" + tmpStr;
                }
                str = String.valueOf(str) + tmpStr;
                tmpStr = "";
            } else {
                tmpStr = String.valueOf(tmpStr) + dbVerLocal.charAt(i);
            }
            ++i;
        }
        if (tmpStr.length() == 1) {
            tmpStr = "0" + tmpStr;
        }
        if (valFromSvr < (valLocal = new Long(str = String.valueOf(str) + tmpStr).longValue())) {
            DBError.throwSQLException(Const.res.getString("error.version.server"));
        }
    }

    private static int resp_checkErr(DmMsgRecv recvMsg, DmdbConnection_bs conn) throws SQLException {
        SQLWarning warning;
        int sqlcode;
        String serverEncoding = conn.getServerEncoding();
        if (!StringUtil.isEmpty(serverEncoding) && conn.getLanguage() == 0 && serverEncoding.equalsIgnoreCase("EUC-KR")) {
            serverEncoding = "GB18030";
        }
        if ((sqlcode = recvMsg.res_get_sqlcode()) < 0) {
            if (sqlcode == -7036) {
                return sqlcode;
            }
            String errInfo = recvMsg.getErrorInfo(serverEncoding);
            if (conn.checkHasStandby()) {
                errInfo = recvMsg.getFromStandby() ? ("[S] " + errInfo == null ? "" : errInfo) : ("[P] " + errInfo == null ? "" : errInfo);
            }
            DBError.throwSQLException(errInfo, sqlcode);
        }
        if (sqlcode == 117) {
            warning = new SQLWarning(Const.res.getString("warning.rangeWarn"));
            conn.addWarnings(warning);
        }
        if (sqlcode == 119) {
            warning = new SQLWarning(Const.res.getString("warning.listWarn"));
            conn.addWarnings(warning);
        }
        if (sqlcode == 202) {
            long explain_len = recvMsg.getInt(64);
            if (explain_len > Integer.MAX_VALUE) {
                explain_len = Integer.MAX_VALUE;
            }
            String pln = recvMsg.getString(68, (int)explain_len, serverEncoding);
            DBError.throwSQLException(pln, sqlcode);
        }
        if (sqlcode == 121) {
            SQLWarning warning2 = new SQLWarning(Const.res.getString("warn.bp_with_err"));
            conn.addWarnings(warning2);
        }
        return sqlcode;
    }

    private static final int resp_getParaDesc(DmMsgRecv recv, int offset, int paraNum, DmdbInfo des, DmdbStatement_bs stmt) throws SQLException {
        if (paraNum > 0) {
            int dataType;
            boolean isLob = false;
            ParameterDesc[] paramsInfo = new ParameterDesc[paraNum];
            DmdbConnection_bs conn = stmt.getConnection_bs();
            int i = 0;
            while (i < paraNum) {
                byte typeFlag;
                paramsInfo[i] = new ParameterDesc();
                dataType = (int)recv.getInt(offset);
                int typePrec = (int)recv.getInt(offset += 4);
                int typeScale = (int)recv.getInt(offset += 4);
                offset += 4;
                if (dataType == 54 && typePrec == 0) {
                    paramsInfo[i].setPrec(8188);
                } else if (dataType == 12 || dataType == 19) {
                    paramsInfo[i].setPrec(Integer.MAX_VALUE);
                } else {
                    paramsInfo[i].setPrec(typePrec);
                }
                paramsInfo[i].setScale(typeScale);
                boolean nullable = recv.getInt(offset) != 0L;
                short itemFlag = (short)recv.getShort(offset += 4);
                offset += 2;
                if ((itemFlag & 2) == 2) {
                    paramsInfo[i].setIsLob(true);
                    isLob = true;
                } else {
                    isLob = false;
                }
                byte by = typeFlag = (itemFlag & 8) != 0 ? (byte)2 : 1;
                if (dataType == 54) {
                    typeFlag = 0;
                }
                short ioType = (short)recv.getShort(offset += 4);
                short nameLen = (short)recv.getShort(offset += 2);
                short typeNameLen = (short)recv.getShort(offset += 2);
                short tableLen = (short)recv.getShort(offset += 2);
                short schemaLen = (short)recv.getShort(offset += 2);
                offset += 2;
                try {
                    String serverEncoding = conn.getServerEncoding();
                    String tempName = recv.getString(offset, nameLen, serverEncoding);
                    paramsInfo[i].setName(tempName);
                    tempName = recv.getString(offset += nameLen, typeNameLen, serverEncoding);
                    paramsInfo[i].setTypeName(tempName);
                    tempName = recv.getString(offset += typeNameLen, tableLen, serverEncoding);
                    paramsInfo[i].setTabName(tempName);
                    tempName = recv.getString(offset += tableLen, schemaLen, serverEncoding);
                    paramsInfo[i].setSchName(tempName);
                    offset += schemaLen;
                }
                catch (Exception ex) {
                    System.out.println(ex.toString());
                }
                paramsInfo[i].setDType(dataType);
                paramsInfo[i].setNullable(nullable);
                paramsInfo[i].setTypeFlag(typeFlag);
                paramsInfo[i].setIOType((byte)ioType);
                if (isLob) {
                    paramsInfo[i].setTabId((int)recv.getInt(offset));
                    paramsInfo[i].setColId((short)recv.getShort(offset += 4));
                    offset += 2;
                }
                ++i;
            }
            i = 0;
            while (i < paraNum) {
                TypeDescriptor typeDesc;
                dataType = paramsInfo[i].getDType();
                if (dataType == 117 || dataType == 122 || dataType == 119 || dataType == 120 || dataType == 121) {
                    typeDesc = new TypeDescriptor(conn);
                    offset = typeDesc.unpack(recv.getBuffer(), offset);
                    paramsInfo[i].setTypeDescriptor(typeDesc);
                } else if (paramsInfo[i].isComplexType()) {
                    typeDesc = new TypeDescriptor(conn);
                    offset = typeDesc.unpack(recv.getBuffer(), offset);
                    paramsInfo[i].setTypeDescriptor(typeDesc);
                }
                ++i;
            }
            des.setParamsInfo(paramsInfo);
        }
        return offset;
    }

    private static final int resp_getColDesc(DmMsgRecv recv, int offset, int colNum, DmdbInfo des, DmdbStatement_bs stmt) throws SQLException {
        if (colNum > 0) {
            boolean isLob = false;
            DmdbColumn[] columnsInfo = new DmdbColumn[colNum];
            DmdbConnection_bs conn = stmt.getConnection_bs();
            int i = 0;
            while (i < colNum) {
                columnsInfo[i] = new DmdbColumn(conn);
                columnsInfo[i].getDesc().setLobMode(conn.getLobMode());
                columnsInfo[i].getDesc().getLobDesc().setFromStandby(recv.getFromStandby());
                int dataType = recv.getdType(offset);
                int typePrec = recv.getPrec(offset);
                int typeScale = recv.getScale(offset);
                boolean nullable = recv.getNullable(offset);
                short itemFlag = recv.getItemFlag(offset);
                short nameLen = recv.getNameLen(offset);
                short typeNameLen = recv.getTypeNameLen(offset);
                short tableLen = recv.getTableLen(offset);
                short schemaLen = recv.getSchemaLen(offset);
                offset += 32;
                if ((itemFlag & 1) == 1) {
                    columnsInfo[i].getDesc().setIdentity(true);
                }
                if ((itemFlag & 2) == 2) {
                    columnsInfo[i].getDesc().setIsLob(true);
                    isLob = true;
                } else {
                    isLob = false;
                }
                if ((itemFlag & 4) == 4) {
                    columnsInfo[i].getDesc().setReadOnly(true);
                } else {
                    columnsInfo[i].getDesc().setReadOnly(false);
                }
                String serverEncoding = conn.getServerEncoding();
                String tempName = recv.getString(offset, nameLen, serverEncoding);
                columnsInfo[i].getDesc().setName(tempName);
                tempName = recv.getString(offset += nameLen, typeNameLen, serverEncoding);
                columnsInfo[i].getDesc().setTypeName(tempName);
                tempName = recv.getString(offset += typeNameLen, tableLen, serverEncoding);
                columnsInfo[i].getDesc().setTabName(tempName);
                tempName = recv.getString(offset += tableLen, schemaLen, serverEncoding);
                columnsInfo[i].getDesc().setSchName(tempName);
                offset += schemaLen;
                columnsInfo[i].getDesc().setDType(dataType);
                columnsInfo[i].getDesc().setPrec(typePrec);
                columnsInfo[i].getDesc().setScale(typeScale);
                columnsInfo[i].getDesc().setNullable(nullable);
                if (stmt.isReadBaseColName()) {
                    int baseNameLen = recv.getShort(offset);
                    offset += 2;
                    if (baseNameLen > 0) {
                        String baseName = recv.getString(offset, baseNameLen, serverEncoding);
                        columnsInfo[i].getDesc().setBaseName(baseName);
                        offset += baseNameLen;
                    }
                }
                if (isLob) {
                    columnsInfo[i].getDesc().setTabId((int)recv.getInt(offset));
                    columnsInfo[i].getDesc().setColId((short)recv.getShort(offset += 4));
                    offset += 2;
                }
                ++i;
            }
            i = 0;
            while (i < colNum) {
                offset = columnsInfo[i].checkComplexType(recv.getBuffer(), offset);
                ++i;
            }
            des.setColumnsInfo(columnsInfo);
            des.setHasResultSet(true);
        }
        return offset;
    }

    private static final void resp_getResultSetData(DmdbStatement_bs stmt, DmMsgRecv msg, long rowNum, DmdbColumn[] colsInfo, int offset, int rsCacheOffset, int rowidCol, boolean isBdtaRs) throws SQLException {
        int fetched_rows = msg.res_execute_get_fetched_rows();
        if (fetched_rows > 0) {
            long len;
            if (isBdtaRs) {
                stmt.setRsCache(new DmdbResultSetCache_v(stmt, colsInfo, rowidCol));
            } else {
                stmt.setRsCache(new DmdbResultSetCache_h(stmt, colsInfo));
            }
            if (rsCacheOffset == 0) {
                long msgLen = msg.res_get_len();
                len = msgLen + 64L - (long)offset;
            } else {
                len = rsCacheOffset - offset;
            }
            stmt.getRsCache().fillBuffer2(msg.getBuffer(), offset, (int)len, fetched_rows);
        }
        if (rsCacheOffset == 0) {
            return;
        }
        int tbCount = msg.getShort(rsCacheOffset);
        rsCacheOffset += 2;
        long[] ids = new long[tbCount];
        long[] tss = new long[tbCount];
        int i = 0;
        while (i < tbCount) {
            ids[i] = msg.getInt(rsCacheOffset);
            tss[i] = msg.getLong(rsCacheOffset += 4);
            rsCacheOffset += 8;
            ++i;
        }
        stmt.setTbsId_Ts(ids, tss);
        ids = null;
        tss = null;
    }

    public static void req_table_ts(DmMsgSend msg, long[] tbIds) {
        Request_Response.req_initMsg(msg);
        int tbCount = tbIds.length;
        msg.setShort(tbCount, 20);
        int offset = 64;
        int i = 0;
        while (i < tbCount) {
            msg.setInt((int)tbIds[i], offset);
            offset += 4;
            ++i;
        }
        Request_Response.req_setCommonHead(msg, 0, (short)71, offset - 64);
    }

    public static long[] resp_table_ts(DmMsgRecv recv, DmdbConnection_bs conn) throws SQLException {
        Request_Response.resp_checkErr(recv, conn);
        int tbCount = recv.getShort(20);
        if (tbCount <= 0) {
            return null;
        }
        long[] tss = new long[tbCount];
        int offset = 64;
        int i = 0;
        while (i < tbCount) {
            tss[i] = recv.getLong(offset);
            offset += 8;
            ++i;
        }
        return tss;
    }

    public static void req_xa_common(DmMsgSend msg, int xa_type, Xid xid, int flag) {
        Request_Response.req_initMsg(msg);
        msg.req_xa_set_xa_type(xa_type);
        if (xid != null) {
            byte[] xid_tmp = new byte[128];
            byte[] gtId = xid.getGlobalTransactionId();
            System.arraycopy(gtId, 0, xid_tmp, 0, gtId.length);
            byte[] bq = xid.getBranchQualifier();
            System.arraycopy(bq, 0, xid_tmp, 64, bq.length);
            msg.req_xa_set_xid(xid.getFormatId(), gtId.length, bq.length, xid_tmp);
        }
        msg.req_xa_set_xa_flag(flag);
        Request_Response.req_setCommonHead(msg, 0, (short)60, 148);
    }

    public static int resp_xa_common(DmMsgRecv recvMsg) throws SQLException, XAException {
        int sqlcode = recvMsg.res_get_xa_sqlcode();
        if (sqlcode != 0) {
            throw new DmdbXAException(sqlcode);
        }
        if (sqlcode == 3) {
            return 3;
        }
        return sqlcode;
    }

    public static DmdbXid[] resp_xa_recover(DmdbXAResource xaResource, DmMsgRecv recvMsg) throws XAException {
        recvMsg.res_get_xa_sqlcode();
        int endflag = recvMsg.res_get_xa_recovery_endflag();
        int xid_count = recvMsg.res_get_xa_recovery_xid_count();
        if (endflag == 1) {
            xaResource.setRecoverd(true);
        } else {
            xaResource.setRecoverd(false);
        }
        if (xid_count > 0) {
            DmdbXid[] xids = new DmdbXid[xid_count];
            int i = 0;
            while (i < xid_count) {
                xids[i] = recvMsg.res_get_xa_recovery_xid(i);
                ++i;
            }
            return xids;
        }
        return null;
    }
}

