/*
 * Decompiled with CFR 0.152.
 */
package microsoft.sql;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

public final class DateTimeOffset
implements Serializable,
Comparable<DateTimeOffset> {
    private static final long serialVersionUID = 541973748553014280L;
    private final long utcMillis;
    private final int nanos;
    private final int minutesOffset;
    private static final int NANOS_MIN = 0;
    private static final int NANOS_MAX = 999999999;
    private static final int MINUTES_OFFSET_MIN = -840;
    private static final int MINUTES_OFFSET_MAX = 840;
    private static final int HUNDRED_NANOS_PER_SECOND = 10000000;
    private String formattedValue = null;

    private DateTimeOffset(Timestamp timestamp, int n) {
        if (n < -840 || n > 840) {
            throw new IllegalArgumentException();
        }
        this.minutesOffset = n;
        int n2 = timestamp.getNanos();
        if (n2 < 0 || n2 > 999999999) {
            throw new IllegalArgumentException();
        }
        int n3 = (n2 + 50) / 100;
        this.nanos = 100 * (n3 % 10000000);
        this.utcMillis = timestamp.getTime() - (long)(timestamp.getNanos() / 1000000) + (long)(1000 * (n3 / 10000000));
        assert (this.minutesOffset >= -840 && this.minutesOffset <= 840) : "minutesOffset: " + this.minutesOffset;
        assert (this.nanos >= 0 && this.nanos <= 999999999) : "nanos: " + this.nanos;
        assert (0 == this.nanos % 100) : "nanos: " + this.nanos;
        assert (0L == this.utcMillis % 1000L) : "utcMillis: " + this.utcMillis;
    }

    public static DateTimeOffset valueOf(Timestamp timestamp, int n) {
        return new DateTimeOffset(timestamp, n);
    }

    public static DateTimeOffset valueOf(Timestamp timestamp, Calendar calendar) {
        calendar.setTimeInMillis(timestamp.getTime());
        return new DateTimeOffset(timestamp, (calendar.get(15) + calendar.get(16)) / 60000);
    }

    public String toString() {
        String string = this.formattedValue;
        if (null == string) {
            String string2 = this.minutesOffset < 0 ? String.format(Locale.US, "-%1$02d:%2$02d", -this.minutesOffset / 60, -this.minutesOffset % 60) : String.format(Locale.US, "+%1$02d:%2$02d", this.minutesOffset / 60, this.minutesOffset % 60);
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT" + string2), Locale.US);
            calendar.setTimeInMillis(this.utcMillis);
            assert (this.nanos >= 0 && this.nanos <= 999999999);
            string = 0 == this.nanos ? String.format(Locale.US, "%1$tF %1$tT %2$s", calendar, string2) : String.format(Locale.US, "%1$tF %1$tT.%2$s %3$s", calendar, BigDecimal.valueOf(this.nanos, 9).stripTrailingZeros().toPlainString().substring(2), string2);
            this.formattedValue = string;
        }
        return string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DateTimeOffset)) {
            return false;
        }
        DateTimeOffset dateTimeOffset = (DateTimeOffset)object;
        return this.utcMillis == dateTimeOffset.utcMillis && this.nanos == dateTimeOffset.nanos && this.minutesOffset == dateTimeOffset.minutesOffset;
    }

    public int hashCode() {
        assert (0L == this.utcMillis % 1000L);
        long l = this.utcMillis / 1000L;
        int n = 571;
        n = 2011 * n + (int)l;
        n = 3217 * n + (int)(l / 60L * 60L * 24L * 365L);
        n = 3919 * n + this.nanos / 100000;
        n = 4463 * n + this.nanos / 1000;
        n = 5227 * n + this.nanos;
        n = 6689 * n + this.minutesOffset;
        n = 7577 * n + this.minutesOffset / 60;
        return n;
    }

    public Timestamp getTimestamp() {
        Timestamp timestamp = new Timestamp(this.utcMillis);
        timestamp.setNanos(this.nanos);
        return timestamp;
    }

    public int getMinutesOffset() {
        return this.minutesOffset;
    }

    @Override
    public int compareTo(DateTimeOffset dateTimeOffset) {
        assert (this.nanos >= 0);
        assert (dateTimeOffset.nanos >= 0);
        return this.utcMillis > dateTimeOffset.utcMillis ? 1 : (this.utcMillis < dateTimeOffset.utcMillis ? -1 : this.nanos - dateTimeOffset.nanos);
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("");
    }

    private static class SerializationProxy
    implements Serializable {
        private final long utcMillis;
        private final int nanos;
        private final int minutesOffset;
        private static final long serialVersionUID = 664661379547314226L;

        SerializationProxy(DateTimeOffset dateTimeOffset) {
            this.utcMillis = dateTimeOffset.utcMillis;
            this.nanos = dateTimeOffset.nanos;
            this.minutesOffset = dateTimeOffset.minutesOffset;
        }

        private Object readResolve() {
            Timestamp timestamp = new Timestamp(this.utcMillis);
            timestamp.setNanos(this.nanos);
            return new DateTimeOffset(timestamp, this.minutesOffset);
        }
    }
}

