/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.driver.DmBinder;
import dm.jdbc.driver.DmNullBinder;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.jdbc.driver.DmdbStatement_bs;
import java.sql.SQLException;

public class DmOutParamBinder
extends DmBinder {
    public DmBinder m_inParamBinder = null;
    DmdbStatement_bs curStmt = null;
    boolean isOutNull = false;
    byte[] outValue = null;

    public DmOutParamBinder(DmdbPreparedStatement_bs pstmt) {
        super(pstmt);
        this.hasSqlScale = false;
        this.hasSqlType = false;
    }

    public DmOutParamBinder(DmdbPreparedStatement_bs pstmt, int sqlType) {
        this(pstmt);
        this.sqlType = sqlType;
        this.hasSqlType = true;
    }

    public DmOutParamBinder(DmdbPreparedStatement_bs pstmt, int sqlType, int sqlScale) {
        this(pstmt, sqlType);
        this.sqlScale = sqlScale;
        this.hasSqlScale = true;
    }

    void init() {
    }

    public void setCursorStmt(DmdbStatement_bs stmt) {
        this.curStmt = stmt;
    }

    void checkType(int irow, int icol, boolean forBatch) throws SQLException {
        if (this.m_checkType) {
            return;
        }
        this.m_checkType = true;
        if (this.paramsDesc == null) {
            this.paramsDesc = this.pstmt.getParamsDesc();
        }
        this.destDType = this.paramsDesc[icol].getDType();
        this.destPrec = this.paramsDesc[icol].getPrec();
        this.destScale = this.paramsDesc[icol].getScale();
        this.destIoType = this.paramsDesc[icol].getIOType();
        if (this.destIoType == 1 && this.destDType == 120) {
            this.destIoType = (byte)2;
        }
    }

    public int bindData(DmMsgSend msg, int irow, int icol, boolean forBatch) throws SQLException {
        int retLen = 0;
        if (120 == this.destDType) {
            if (this.curStmt == null) {
                DBError.throwSQLException(6048);
            }
            msg.setShort(4);
            msg.setInt(this.curStmt.getHandle());
            retLen = 6;
        } else if (this.destIoType == 2) {
            if (this.m_inParamBinder == null) {
                DBError.throwSQLException(6054);
            }
            this.m_inParamBinder.checkType(irow, icol, forBatch);
            byte isNull = this.pstmt.getNullIndicator(irow, icol);
            retLen = isNull == 1 || this.m_inParamBinder instanceof DmNullBinder ? DmNullBinder.bindData(msg) : this.m_inParamBinder.bindData(msg, irow, icol, forBatch);
        }
        return retLen;
    }

    public void setInoutParamBinder(DmBinder inBinder) throws SQLException {
        if (this.m_inParamBinder == null) {
            this.m_inParamBinder = inBinder;
        } else if (this.m_inParamBinder instanceof DmNullBinder) {
            this.m_inParamBinder = inBinder;
        } else if (inBinder != null && this.m_inParamBinder.getClass() != inBinder.getClass()) {
            throw new SQLException("Different object bound with the first row in the same column");
        }
        this.m_inParamBinder = inBinder;
    }

    public DmBinder getInoutParamBinder() throws SQLException {
        return this.m_inParamBinder;
    }

    public DmdbStatement_bs getCursorStmt() throws SQLException {
        return this.curStmt;
    }

    public void setOutNullFlag(boolean flag) throws SQLException {
        this.isOutNull = flag;
    }

    public boolean getOutNullFlag() throws SQLException {
        return this.isOutNull;
    }

    public void setOutValue(byte[] out) throws SQLException {
        this.outValue = out;
    }

    public byte[] getOutValue() throws SQLException {
        return this.outValue;
    }
}

