/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.pool;

import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.pool.DmdbPooledConnection_bs;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;

public class DmdbPooledConnection
implements PooledConnection {
    private DmdbPooledConnection_bs rPConn = null;
    public static final int STMT_CLOSED_EVENT = 1;
    public static final int STMT_ERROROCCURED_EVENT = 2;
    private Hashtable<StatementEventListener, StatementEventListener> statementListeners;

    public Hashtable<StatementEventListener, StatementEventListener> getStatementListeners() {
        return this.statementListeners;
    }

    public DmdbPooledConnection(DmdbPooledConnection_bs pconn) {
        this.rPConn = pconn;
        this.statementListeners = new Hashtable(5);
    }

    DmdbPooledConnection_bs getRealPConn() {
        return this.rPConn;
    }

    @Override
    public synchronized void addConnectionEventListener(ConnectionEventListener listener) {
        this.rPConn.addConnectionEventListener(listener);
    }

    @Override
    public synchronized void close() throws SQLException {
        this.rPConn.close();
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        DmdbConnection_bs conn = (DmdbConnection_bs)this.rPConn.getConnection();
        if (conn == null) {
            return null;
        }
        return new DmdbConnection(conn);
    }

    @Override
    public synchronized void removeConnectionEventListener(ConnectionEventListener listener) {
        this.rPConn.removeConnectionEventListener(listener);
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        if (this.getStatementListeners() == null) {
            this.rPConn.setSqlException(new SQLException("statementListeners Hashtable Null"));
        } else {
            this.getStatementListeners().put(listener, listener);
        }
    }

    public void notifyStatementChanged(DmdbPreparedStatement pstmt, int eType) {
        if (this.getStatementListeners() == null) {
            return;
        }
        Enumeration<StatementEventListener> enumeration = this.getStatementListeners().keys();
        StatementEvent e = new StatementEvent(this, pstmt);
        while (enumeration.hasMoreElements()) {
            StatementEventListener stmteventlistener = enumeration.nextElement();
            StatementEventListener stmteventlistener1 = (StatementEventListener)this.rPConn.getEventListeners().get(stmteventlistener);
            if (eType == 1) {
                stmteventlistener1.statementClosed(e);
                continue;
            }
            if (eType != 2) continue;
            stmteventlistener1.statementErrorOccurred(e);
        }
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        if (this.getStatementListeners() == null) {
            this.rPConn.setSqlException(new SQLException("statementListeners Hashtable Null"));
        } else {
            this.getStatementListeners().remove(listener);
        }
    }
}

