package cn.quantgroup.mock;

import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.io.File;
import java.io.FileOutputStream;
import java.util.*;

/**
 * @author Aladdin(qiang.ding)
 * @date 2020/4/16
 */
@Component

public class MockData {

    @Value("${header.user}")
    private String userHeader;
    @Value("${header.order}")
    private String orderHeader;
    @Value("${path.data}")
    private String dataPath;
    @Value("${totalCount}")
    private int totalCount;

    private static final List<String> PHONE_SET = new ArrayList<>(1000000);

    static {
        for (int i = 1000000; i < 2000000; i++) {
            PHONE_SET.add("1512" + i);
        }
    }

    @PostConstruct
    public void mockData() {
        try {
            File user = new File(dataPath + "user.csv");
            FileOutputStream userOutputStream = new FileOutputStream(user, true);
            IOUtils.write(userHeader, userOutputStream);
            IOUtils.write("\n", userOutputStream);
            IOUtils.writeLines(PHONE_SET, null, userOutputStream);

            File order = new File(dataPath + "order.csv");
            FileOutputStream orderOutputStream = new FileOutputStream(order, true);
            IOUtils.write(orderHeader, orderOutputStream);
            IOUtils.write("\n", orderOutputStream);

            List<String> orders = new LinkedList<>();
            Random ran = new Random();
            for (int i = 0; i < totalCount; i++) {
                String orderPhone = PHONE_SET.get(i % PHONE_SET.size());
                String receiverPhone = PHONE_SET.get(ran.nextInt(PHONE_SET.size()));
                String orderId = UUID.randomUUID().toString();
                long t = ran.nextInt((int)(DateUtil.ONE_YEAR / 1000)) * 1000L + 1555171200000L;
                String orderTime = DateUtil.format(new Date(t));
                String orderStatus = i % 3 + "";
                orders.add(orderPhone + "," + receiverPhone + "," + orderId + "," + orderTime + "," + orderStatus);
            }
            IOUtils.writeLines(orders, null, orderOutputStream);
            System.out.println("数据生成完毕。");
            System.exit(0);
        } catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

}
