package cn.quantgroup.mock;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class DateUtil {

    public static final String TIME_ZONE = "Asia/Shanghai";
    /**
     * 一秒
     */
    public static final long ONE_SECOND = 1000L;

    /**
     * 一分钟
     */
    public static final long ONE_MINUTE = ONE_SECOND * 60;

    /**
     * 一小时
     */
    public static final long ONE_HOUR = ONE_MINUTE * 60;

    /**
     * 一天
     */
    public static final long ONE_DAY = ONE_HOUR * 24;

    /**
     * 一周
     */
    public static final long ONE_WEEK = ONE_DAY * 7;

    /**
     * 一月（按三十天计算）
     * 三十天
     */
    public static final long ONE_MONTH = ONE_DAY * 30;

    /**
     * 半年
     * 180天
     */
    public static final long HALF_YEAR = ONE_DAY * 180;

    /**
     * 一年
     * 365天
     */
    public static final long ONE_YEAR = ONE_DAY * 365;

    /**
     * 英文简写（默认）如：2015-12
     */
    public static String yyyyMM_Bar = "yyyy-MM";
    /**
     * 英文简写（默认）如：2015-12-01
     */
    public static String yyyyMMdd_Bar = "yyyy-MM-dd";
    /**
     * 英文全称  如：2015-12-01 23:15:06
     */
    public static String yyyyMMddSpaceHHmmss_Bar = "yyyy-MM-dd HH:mm:ss";
    /**
     * 精确到毫秒的完整时间    如：yyyy-MM-dd HH:mm:ss.S
     */
    public static String yyyyMMddSpaceHHmmssFull_Bar = "yyyy-MM-dd HH:mm:ss.S";
    /**
     * 英文简写（默认）如：2015-12-01
     */
    public static String yyyyMMdd_Slash = "yyyy/MM/dd";
    /**
     * 20151201
     */
    public static String yyyyMMdd = "yyyyMMdd";
    /**
     * 20151201121321
     */
    public static String yyyyMMddHHmmss = "yyyyMMddHHmmss";
    /**
     * 精确到毫秒
     * 20151201121321992
     */
    public static String yyyyMMddHHmmssS = "yyyyMMddHHmmssS";
    /**
     * 201512
     */
    public static String yyyyMM = "yyyyMM";

    /**
     * 获得默认的 date pattern
     */
    public static String getDatePattern() {
        return yyyyMMddSpaceHHmmss_Bar;
    }

    /**
     * 根据预设格式返回当前日期
     *
     * @return
     */
    public static String getNow() {
        return format(new Date());
    }
    public static Date getDate() {
        return new Date();
    }
    public static Timestamp getTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    /**
     * 根据用户格式返回当前日期
     *
     * @param format
     * @return
     */
    public static String getNow(String format) {
        return format(new Date(), format);
    }

    /**
     * 使用预设格式格式化日期
     *
     * @param date
     * @return
     */
    public static String format(Date date) {
        return format(date, getDatePattern());
    }

    /**
     * 使用用户格式格式化日期
     *
     * @param date    日期
     * @param pattern 日期格式
     * @return
     */
    public static String format(Date date, String pattern) {
        String returnValue = "";
        if (date != null) {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            returnValue = df.format(date);
        }
        return (returnValue);
    }

    /**
     * 使用预设格式提取字符串日期
     *
     * @param strDate 日期字符串
     * @return
     */
    public static Date parse(String strDate) {
        return parse(strDate, getDatePattern());
    }

    /**
     * 使用用户格式提取字符串日期
     *
     * @param strDate 日期字符串
     * @param pattern 日期格式
     * @return
     */
    public static Date parse(String strDate, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        try {
            return df.parse(strDate);
        } catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 在日期上增加数个整月
     *
     * @param date 日期
     * @param n    要增加的月数
     * @return
     */
    public static Date addMonth(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(Calendar.MONTH, n);
        return cal.getTime();
    }

    /**
     * 在日期上增加天数
     *
     * @param date 日期
     * @param n    要增加的天数
     * @return
     */
    public static Date addDay(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(Calendar.DATE, n);
        return cal.getTime();
    }

    /**
     * 获取日期年份
     *
     * @param date 日期
     * @return
     */
    public static String getYear(Date date) {
        return format(date).substring(0, 4);
    }

    public static String getMonth(Date date){
        return format(date).substring(5,7);
    }

    /**
     * 按默认格式的字符串距离今天的天数
     *
     * @param date 日期字符串
     * @return
     */
    public static int countDays(String date) {
        long t = Calendar.getInstance().getTime().getTime();
        Calendar c = Calendar.getInstance();
        c.setTime(parse(date));
        long t1 = c.getTime().getTime();
        return (int) (t / 1000 - t1 / 1000) / 3600 / 24;
    }


    /**
     * @param dateStr yyyy-MM-dd
     * @return
     */
    public static String lastDayOfMonth(String dateStr) {
        return lastDayOfMonth(dateStr,yyyyMMdd_Bar,yyyyMMdd_Bar);
    }
    public static String lastDayOfMonth(String dateStr,String inputFormat,String outFormat){
        return format((Object)dateStr,inputFormat,outFormat,false);
    }
    public static String lastDayOfMonth(Date date) {
        return format(date,yyyyMMdd_Bar,yyyyMMdd_Bar,false);
    }
    public static String lastDayOfMonth(Date date,String outFormat) {
        return format(date,yyyyMMdd_Bar,outFormat,false);
    }
    public static String lastDayOfMonth(Date date,String inputFormat,String outFormat) {
        return format(date,yyyyMMdd_Bar,outFormat,false);
    }
    /**
     * @param inputFormat 例如 yyyy-MM
     * @param outFormat   例如 yyyy-MM-dd
     * @return 月份的最后一天
     */
    private static String format(Object da,String inputFormat,String outFormat,boolean isFirst) {
        if(da!=null){
            Date date = null;
            try {
                if(da instanceof Date){
                    date = (Date) da;
                }else{
                    date = new SimpleDateFormat(inputFormat).parse(da.toString());
                }
            } catch (ParseException e) {
                e.printStackTrace();
            }
            if(date!=null){
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                cal.set(Calendar.DAY_OF_MONTH, 1);
                if(!isFirst){
                    cal.roll(Calendar.DAY_OF_MONTH, -1);
                }
                Date time = cal.getTime();
                SimpleDateFormat sdf = new SimpleDateFormat(outFormat);
                return sdf.format(time);
            }

        }
        return null;
    }
    /**
     * @param dateStr yyyy-MM-dd
     * @return
     */
    public static String firstDayOfMonth(String dateStr) {
        return firstDayOfMonth(dateStr,yyyyMMdd_Bar,yyyyMMdd_Bar);
    }
    public static String firstDayOfMonth(String dateStr,String inputFormat,String outFormat){
        return format((Object)dateStr,inputFormat,outFormat,true);
    }
    public static String firstDayOfMonth(Date date) {
        return format(date,yyyyMMdd_Bar,yyyyMMdd_Bar,true);
    }
    public static String firstDayOfMonth(Date date,String outFormat) {
        return format(date,yyyyMMdd_Bar,outFormat,true);
    }
    public static String firstDayOfMonth(Date date,String inputFormat,String outFormat) {
        return format(date,yyyyMMdd_Bar,outFormat,true);
    }

    public static Date getHourByDate(Calendar c,int hour){
        c.set(Calendar.HOUR_OF_DAY, c.get(Calendar.HOUR_OF_DAY)+hour);
//       c.set(Calendar.DAY_OF_MONTH,c.get(Calendar.DAY_OF_MONTH)+1);
        return c.getTime();
    }

    /**
     * @return  01,02月
     * @throws
     */
    public static String getChineseToDigitalMonth(String month){
        switch (month) {
            case "七月":
                return "07";
            case "六月":
                return "06";
            case "五月":
                return "05";
            case "四月":
                return "04";
            case "三月":
                return "03";
            case "二月":
                return "02";
            case "一月":
                return "01";
            case "十二月":
                return "12";
            case "十一月":
                return "11";
            case "十月":
                return "10";
            case "九月":
                return "09";
            case "八月":
                return "08";
            case "Jan":
                return "01";
            case "Feb":
                return "02";
            case "Mar":
                return "03";
            case "Apr":
                return "04";
            case "May":
                return "05";
            case "Jun":
                return "06";
            case "Jul":
                return "07";
            case "Aug":
                return "08";
            case "Sep":
                return "09";
            case "Oct":
                return "10";
            case "Nov":
                return "11";
            case "Dec":
                return "12";
            default:
                break;
        }
        return "";
    }

    public static Long getLongTime(String time){
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date date = sdf.parse(time);
            return date.getTime();
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void main(String[] args){
        System.out.println(lastDayOfMonth("2015-04-28"));
        System.out.println(firstDayOfMonth("2015-04-21"));
        System.out.println(lastDayOfMonth(new Date()));
        System.out.println(firstDayOfMonth(new Date()));
        System.out.println(getMonth(new Date()));
    }
}
