#!/bin/bash
NEO4J_HOME=/home/quant_group/relation/neo4j-3.2
data_dir=/home/quant_group/relation/mock-data
dat=`date +%Y%m%d`
$NEO4J_HOME/bin/neo4j stop

if [ -d $NEO4J_HOME/data/databases/graph.db ]; then
   rm -rf $NEO4J_HOME/data/databases/graph.db.*
   mv $NEO4J_HOME/data/databases/graph.db $NEO4J_HOME/data/databases/graph.db.$dat
fi

$NEO4J_HOME/bin/neo4j-import --into  $NEO4J_HOME/data/databases/graph.db --nodes:user  "$data_dir/user.csv" --relationships:order "$data_dir/order.csv,$data_dir/order_circle.csv" --delimiter ',' --bad-tolerance 100000000 --skip-duplicate-nodes  > log.log

$NEO4J_HOME/bin/neo4j start
sleep 5m

#$NEO4J_HOME/bin/neo4j-shell --host 172.18.3.45 -c "create  index on :user(uuid);";
$NEO4J_HOME/bin/neo4j-shell --host 173.18.4.45 -c "create  index on :user(phone);";