package com.quantgroup.eos.configuration;

import java.util.Objects;
import org.springframework.boot.context.config.ConfigDataResource;

public class EosConfigDataResource extends ConfigDataResource {

    private final String namespace;

    public EosConfigDataResource(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof EosConfigDataResource that)) return false;
        return Objects.equals(namespace, that.namespace);
    }

    @Override
    public int hashCode() {
        return Objects.hash(namespace);
    }

    @Override
    public String toString() {
        return "EosConfigDataResource{" +
                "namespace='" + namespace + '\'' +
                '}';
    }

    public String getNamespace() {
        return namespace;
    }
}
