# eos-config-loader

## 项目介绍
`eos-config-loader` 是基于 Spring Boot Config Data Loader 扩展机制开发的配置加载组件。该组件能够在应用启动阶段，从外部 EOS 配置服务自动获取 MySQL、Redis 等基础服务的配置信息，并集成到 Spring 环境管理中，简化多环境配置管理。

## 背景
量化派的测试环境包含多个分支（如 yxm、yxm2 等）。为避免在配置中心中对每个环境单独维护数据库、缓存等服务的地址和端口，我们通过 EOS 服务集中管理各环境的配置信息。
EOS 服务提供了统一的 HTTP 接口获取环境变量，例如：http://eos.quantgroups.com/api/apollo/env_vars?namespace=yxm

响应示例：
```json
{
    "success": true,
    "details": {
        "MYSQL_SERVICE_HOST": "172.24.192.6",
        "MYSQL_SERVICE_PORT": 32218
    }
}
```
借助 eos-config-loader，只需在配置中心配置如下内容：
```
redis.host=${REDIS_SERVICE_HOST}
redis.port=${REDIS_SERVICE_PORT_6379}
```


## 🚀使用说明：

#### 1. 引入依赖
```xml
<dependency>
    <groupId>com.example</groupId>
    <artifactId>eos-config-loader</artifactId>
    <version>1.0.1</version>
</dependency>
```
#### 2.在 application.yml 中添加：
```yml
spring:
  config:
    import: eos-config:namespace=test
```

#### 3.启动时通过 指定运行环境和命名空间
```
-Denv=dev -DNAMESPACE=yxm
```
其中：
- -Denv：指定测试环境类型
- -DNAMESPACE：指定所属的测试环境命名空间
- 可以在 jar 启动命令 、 idea -> vmoptions 设置该值