package com.quantgroup.eos.configuration;

import java.util.Collections;
import java.util.List;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.config.ConfigDataLocationResolver;
import org.springframework.boot.context.config.ConfigDataLocationResolverContext;
import org.springframework.boot.context.config.ConfigDataResourceNotFoundException;
import org.springframework.boot.context.config.Profiles;

public class EosConfigDataLocationResolver implements
        ConfigDataLocationResolver<EosConfigDataResource> {

    private static final String PREFIX = "qg-eos:";

    @Override
    public boolean isResolvable(ConfigDataLocationResolverContext context, ConfigDataLocation location) {
        return location.hasPrefix(PREFIX);
    }

    @Override
    public List<EosConfigDataResource> resolve(ConfigDataLocationResolverContext context, ConfigDataLocation location)
            throws ConfigDataResourceNotFoundException {
        String namespace = location.getNonPrefixedValue(PREFIX);
        return Collections.singletonList(new EosConfigDataResource(namespace));
    }

    @Override
    public List<EosConfigDataResource> resolveProfileSpecific(ConfigDataLocationResolverContext context,
            ConfigDataLocation location, Profiles profiles) throws ConfigDataResourceNotFoundException {
        return resolve(context, location);
    }
}
