package com.quantgroup.eos.logging;

import com.quantgroup.eos.configuration.EosConfigDataLoader;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.BootstrapRegistryInitializer;
import org.springframework.boot.logging.DeferredLog;

/**
 * spring 启动早期，日志系统尚未加载，通过DeferredLog记录日志，在 spring 日志启动完成后进行重播
 * @author biao
 * @since 2025-09-12
 */
public class EarlyLoggingInitializer implements BootstrapRegistryInitializer {

    @Override
    public void initialize(BootstrapRegistry registry) {
        // 创建并立即使用日志记录器
        DeferredLog logger = new DeferredLog();
        // 将日志记录器注册到BootstrapRegistry中
        registry.register(DeferredLog.class, context -> logger);
        registry.addCloseListener(event -> logger.switchTo(EosConfigDataLoader.class));
    }
}
