const Router = require('koa-router')
const yaml = require('js-yaml')
const templates = require('../serviceTemplate')

const IMAGES = ['rabbitmq:3.6-management']

const router = new Router()
module.exports = router

router.post('/create', async (ctx) => {
  // let svc = await ctx.client.service_get('rabbitmq', ctx.request.body.namespace)
  // if (svc) {
  //   ctx.body = ctx.fail('服务已经存在')
  //   return
  // }

  const data = {
    namespace: ctx.request.body.namespace,
    image: IMAGES[0],
  }
  const template = templates.rabbitmq.replace(/{{([A-Za-z0-9_]+)}}/g, function () {
    if (data[arguments[1]] === undefined) {
      throw new Error('缺少模板所需变量')
    }
    return data[arguments[1]]
  })
  const params = yaml.load(template)
  await ctx.client.service_create(params)
  ctx.body = ctx.ok('创建成功')
})

router.post('/delete', async (ctx) => {
  await ctx.client.service_delete('rabbitmq', ctx.request.body.namespace)
  ctx.body = ctx.ok('删除成功')
})
