const Client = require('./tke.service')
const domainConfig = require('../config')

class Container extends Client {
  constructor() {
    super();
    this.endpoint = domainConfig.containerPoint
  }

  repository_get(namespace) {
    return this.post('SearchUserRepository', { namespace })
  }

  tag_get(reponame) {
    return this.post('GetTagList', { reponame })
  }

  getNamespaceInfo(namespace) {
    return this.post('GetNamespaceInfo', { namespace, limit: 50 })
  }
}

exports.create = function () {
  return new Container()
}
