const path = require('path')
const Client = require('kubernetes-client').Client
const config = require('kubernetes-client').config
const _ = require('lodash')
const YAML = require('yamljs');
const yamls = require('../yamls')

const client = new Client({
  config: config.fromKubeconfig(
    path.resolve(__dirname, './kubeConfig.yaml'),
  ),
  version: '1.10',
})

const serviceGet = async (namespace, serviceName) => client.api.v1.namespaces(namespace).services(serviceName).get()
const podGet = async namespace => client.api.v1.namespaces(namespace).pods.get()

const serviceCreate = async (namespace, serviceName, image) => {
  const data = {
    namespace,
    app: serviceName,
    image,
  }
  const yamlManifest = yamls[serviceName].replace(/{{([A-Za-z0-9_\.]+)}}/g, function () {
    if (_.get(data, arguments[1], null) === null) {
      throw new Error(`缺少模板所需变量: ${arguments[1]}`)
    }
    return _.get(data, arguments[1])
  })
  const nativeObject = YAML.load(yamlManifest);
  // console.log(1, nativeObject)

  const jsonstr = JSON.stringify(nativeObject);

  const jsonTemp = JSON.parse(jsonstr, null);

  // jsonstr = JSON.parse(jsonstr, null);
  client.api.v1.namespaces(namespace).services.post({ body: jsonTemp })
}

module.exports = {
  serviceGet,
  podGet,
  serviceCreate,
}
