/* eslint-disable no-multi-assign */
const _ = require('lodash')

const defaultUI = {
  memory: {
    request: 5,
    limit: 50,
  },
  cpu: {
    request: 1,
    limit: 100,
  },
}

const defaultJava = {
  memory: {
    request: 500,
    limit: 1024,
  },
  cpu: {
    request: 1,
    limit: 1000,
  },
}

const defaultNodejs = {
  memory: {
    request: 10,
    limit: 300,
  },
  cpu: {
    request: 1,
    limit: 200,
  },
}

const defaultPython = {
  memory: {
    request: 10,
    limit: 300,
  },
  cpu: {
    request: 1,
    limit: 200,
  },
}

const defaultRedis = {
  memory: {
    request: 40,
    limit: 100,
  },
  cpu: {
    request: 100,
    limit: 200,
  },
}

const defaultZookeeper = {
  memory: {
    request: 100,
    limit: 300,
  },
  cpu: {
    request: 100,
    limit: 200,
  },
}

const defaultMysql = {
  memory: {
    request: 1024,
    limit: 1500,
  },
  cpu: {
    request: 200,
    limit: 2000,
  },
}

const defaultRabbitmq = {
  memory: {
    request: 300,
    limit: 800,
  },
  cpu: {
    request: 100,
    limit: 200,
  },
}

const projectConfig = {}
const defaultConfig = _.assign({}, defaultJava, {
  memory: {
    request: 800,
    limit: 1024,
  },
})

projectConfig['quantcube-ui'] = _.assign({}, defaultJava, {
  cpu: {
    request: 1,
    limit: 1000,
  },
})

projectConfig['gu-bei'] = projectConfig['cash-loan-flow'] = projectConfig['black-hole'] = projectConfig['spider-center'] = defaultConfig
projectConfig.notify = projectConfig.gyxd = projectConfig['business-flow'] = defaultConfig

// clotho启动比较耗时
projectConfig['urge-dispatcher'] = projectConfig.clotho = {
  memory: {
    request: 800,
    limit: 1500,
  },
  cpu: {
    request: 100,
    limit: 2000,
  },
}

projectConfig['xyqb-user2'] = projectConfig.xyqb = {
  memory: {
    request: 800,
    limit: 1024,
  },
  cpu: {
    request: 100,
    limit: 2000,
  },
}

exports.projectConfig = projectConfig
exports.defaultConfig = {
  java: defaultJava,
  ui: defaultUI,
  node: defaultNodejs,
  redis: defaultRedis,
  zookeeper: defaultZookeeper,
  mysql: defaultMysql,
  rabbitmq: defaultRabbitmq,
  python: defaultPython,
}
