const path = require('path')
const Client = require('kubernetes-client').Client
const config = require('kubernetes-client').config

const client = new Client({
  config: config.fromKubeconfig(
    path.resolve(__dirname, './kubeConfig.yaml'),
  ),
  version: '1.10',
})
const getManifest = ({ namespace, serviceName, domain }) => ({
  apiVersion: 'extensions/v1beta1',
  kind: 'Ingress',
  metadata: {
    name: serviceName,
    namespace,
    annotations: {
      'kubernetes.io/ingress.class': 'traefik',
    },
  },
  spec: {
    rules: [
      {
        host: `${domain}-${namespace}.liangkebang.net`,
        http: {
          paths: [
            {
              path: '/',
              backend: {
                serviceName: `${serviceName}`,
                servicePort: 80,
              },
            },
          ],
        },
      },
    ],
  },
})
const ingressGet = async (namespace, servicename) => client.apis.extensions.v1beta1.namespaces(namespace)
  .ingresses(servicename).get()

const ingressCreate = async (options) => {
  const m = getManifest(options)
  await client.apis.extensions.v1beta1.namespace(options.namespace).ingresses
    .post({ body: m })
}

const ingressUpdate = async (namespace, servicename, host) => {
  const Manifest = getManifest(namespace, servicename)
  Manifest.spec.rules[0].host = host
  await client.apis.extensions.v1beta1.namespace(namespace).ingresses(servicename)
    .patch({ body: Manifest })
}

const ingressDelete = async (namespace, servicename) => {
  await client.apis.extensions.v1beta1.namespaces(namespace).ingresses(servicename).delete()
}
module.exports = {
  ingressGet,
  ingressCreate,
  ingressUpdate,
  ingressDelete,
}
