const Router = require('koa-router')
const qs = require('querystring')
const { getAllNamespace, createNamespace } = require('./../kubeService/service')

// const newNsKey = ''

const router = new Router();
module.exports = router

router.get('/', async (ctx) => {
  const data = await getAllNamespace(ctx.client)
  ctx.body = ctx.ok(data)
})

router.get('/get_namespace_for_jenkins', async (ctx) => {
  const data = await getAllNamespace(ctx.client)
  const ret = data.namespaces.map(item => item.name)
  ctx.body = ret.join('\n')
})


router.get('/info', async (ctx) => {
  const data = await getAllNamespace(ctx.client)
  const ns = data.namespaces.find(item => item.name === qs.unescape(ctx.request.query.namespace))
  ctx.body = ctx.ok(ns)
})

router.post('/create', async (ctx) => {
  // await ctx.cluster.namespace_create(ctx.request.body.name, ctx.request.body.description)
  await createNamespace(ctx.client, ctx.request.body.name, ctx.request.body.description)
  ctx.body = ctx.ok()
})
