// const path = require('path')
//
// const logDir = path.resolve(process.cwd(), './logs')
//
// const log4js = require('koa-log4')
// log4js.configure({
//   replaceConsole: true,
//   appenders: {
//     stdout: {//控制台输出
//       type: 'stdout'
//     },
//     req: {//请求日志
//       type: 'dateFile',
//       filename: 'logs/reqlog/',
//       pattern: 'yyyy-MM-dd.log',
//       alwaysIncludePattern: true
//     },
//     error: {//错误日志
//       type: 'dateFile',
//       filename: 'logs/errorlog/',
//       pattern: 'yyyy-MM-dd.log',
//       alwaysIncludePattern: true
//     },
//     tkeEos: {// 文件日志
//       type: 'dateFile',
//       filename: 'logs/tkeEoslog/',
//       pattern: 'yyyy-MM-dd.log',
//       alwaysIncludePattern: true
//     }
//   },
//   categories: {
//     default: {appenders: ['stdout', 'req'], level: 'info'},//appenders:采用的appender,取appenders项,level:设置级别
//     error: {appenders: ['stdout', 'error'], level: 'error'},
//     tkeEos: {appenders: ['stdout', 'tkeEos'], level: 'info'}
//   }
// })
// const errorLog = log4js.getLogger('error')
// const tkeLog = log4js.getLogger('tkeEos')
// const log = log4js.getLogger()
// // module.exports = {
// //   errorLog,
// //   tkeLog,
// //   log
// // }
// module.exports =function(){
//   return  async function (ctx,next) {
//     ctx.logger=log4js.getLogger('error')
//     return next()
//   }
// }
const path = require('path')

const logDir = path.resolve(process.cwd(), './logs')
module.exports = {
  devlog: {
    appenders: {
      out: {type: 'stdout'},
      app: {
        type: 'dateFile', filename: `${logDir}/tke-eos.log`, daysToKeep: 3, compress: true,
      },
      error: {
        type: 'dateFile', filename: `${logDir}/tke-eos.error.log`, daysToKeep: 3, compress: true,
      },
      timing: {
        type: 'dateFile', filename: `${logDir}/tke-eos.timing.log`, daysToKeep: 3, compress: true,
      },
      just_errors: {type: 'logLevelFilter', appender: 'error', level: 'error'},
    },
    categories: {
      default: {appenders: ['out', 'app', 'just_errors'], level: 'info'},
      error: {appenders: ['stdout', 'error'], level: 'error'},
      timing: {appenders: ['out', 'timing'], level: 'info'}
    }
  }
}
