const Koa = require('koa')
const Router = require('koa-router')
const bodyParser = require('koa-bodyparser')
const log4js = require('koa-log4')

const logConf = require('../config/logger')
const error = require('../middleware/error')
const result = require('../middleware/result')

const namespaceRoute = require('./namespace')
const serviceRoute = require('./service')
const repositoryRouter = require('./repository')
const tag = require('./tag')
// const rabbitmqRoute = require('./rabbitmq')
// const zookeeperRoute = require('./zookeeper')
const commonServiceRoute = require('./commonService')
const ingressRoute = require('./ingress')

const logFormat = ':req[x-real-ip] :req[x-forwarded-for] - -'
  + ' ":method :url HTTP/:http-version"'
  + ' :status :content-length ":referrer"'
  + ' ":user-agent" :req[x-auth-token] :response-timems'
// const client = require('../services/tke.service').create({
//   secretId: 'AKID4rY7wwNphsUcaFsy1pRtKhQvDj4CA3Ac',
//   secretKey: 'YBduRnjgVRGzmagZJbss3Vo58wWCyhgc',
//   clusterId: 'cls-acfx4pvj',
//   region: 'ap-beijing'
// })
const cluster = require('../services/tke.clusterService').create()
const container = require('../services/tke.containerService').create()

const logger = log4js.getLogger()
log4js.configure(logConf.devlog)
function loadRoutes(router) {
  router
    .use(error())
    .use(result())
    .use(async (ctx, next) => {
      // 腾讯云
      ctx.container = container
      ctx.cluster = cluster
      await next()
    }, bodyParser())
    .use('/namespace', namespaceRoute.routes())
    .use('/service', serviceRoute.routes())
    // .use('/rabbitmq', rabbitmqRoute.routes())
    // .use('/zookeeper', zookeeperRoute.routes())
    .use('/commonService', commonServiceRoute.routes())
    .use('/ingress', ingressRoute.routes())
    .use('/repository', repositoryRouter.routes())
    .use('/tag', tag.routes())
}

exports.start = function () {
  // 加载各种服务
  const app = new Koa()
  const router = new Router()

  // 加载所有路由
  loadRoutes(router)
  app.use(log4js.koaLogger())
  app.use(router.routes())
  app.listen(4000)
  logger.info('server listening 4000')
  logger.info('加载环境配置: ', process.env.NODE_ENV)
}
