const Client = require('./tke.service')
const domainConfig = require('../config')

class Cluster extends Client {
  constructor() {
    super();
    this.endpoint = domainConfig.clusterPoint
  }

  namespace_get() {
    return this.post('DescribeClusterNameSpaces', { clusterId: this.clusterId })
  }

  namespace_create(name) {
    return this.post('CreateClusterNamespace', { name, description: '', clusterId: this.clusterId })
  }

  namespace_delete(name) {
    return this.post('DeleteClusterNamespace', { 'names.0': name, clusterId: this.clusterId })
  }

  service_list(namespace) {
    return this.post('DescribeClusterService', { namespace, clusterId: this.clusterId, allnamespace: 0 })
  }

  service_get(serviceName, namespace) {
    return this.post('DescribeClusterServiceInfo', { serviceName, namespace, clusterId: this.clusterId })
  }

  async service_create(params, type) {
    params.clusterId = this.clusterId
    const str = JSON.stringify(params)
    await this.post('CreateClusterService', params)
    // 腾讯云api暂只能通过修改服务来改成Recreate策略
    const modifyParams = JSON.parse(str)
    modifyParams.strategy = 'Recreate'
    await this.post('ModifyClusterService', modifyParams)
    const updateLabels = {
      clusterId: params.clusterId,
      serviceName: params.serviceName,
      namespace: params.namespace,
      'labels.type': type,
    }

    return this.post('ModifyServiceLabels', updateLabels)
  }

  service_delete(serviceName, namespace) {
    return this.post('DeleteClusterService', { serviceName, namespace, clusterId: this.clusterId })
  }

  service_modifyImage(serviceName, image, namespace) {
    return this.post('ModifyClusterServiceImage', {
      serviceName, namespace, image, clusterId: this.clusterId,
    })
  }

  service_redeployment(serviceName, namespace) {
    return this.post('RedeployClusterService', { serviceName, namespace, clusterId: this.clusterId })
  }

  instance_get(serviceName, namespace) {
    return this.post('DescribeServiceInstance', { serviceName, namespace, clusterId: this.clusterId })
  }

  ingress_get(namespace) {
    return this.post('DescribeIngress', { namespace, clusterId: this.clusterId })
  }

  ingress_create(namespace) {
    return this.post('CreateIngress', {
      ingressName: `qa-${namespace}`,
      ingressDesc: '',
      namespace,
      clusterId: this.clusterId,
    })
  }

  ingress_delete(ingressName, namespace) {
    return this.post('DeleteIngress', { ingressName, namespace, clusterId: this.clusterId })
  }

  ingress_modify(ingressName, namespace, rules) {
    return this.post('MosifyIngress', {
      ingressName, namespace, ...rules, clusterId: this.clusterId,
    })
  }
}

exports.create = function () {
  return new Cluster()
}
