const path = require('path')
const Client = require('kubernetes-client').Client
const config = require('kubernetes-client').config

const newClient = function client(ctx) {
  const parmars = ctx.request.query.namespace || ''
  if (parmars.search('@') === -1) {
    ctx.body = {
      code: '0001',
      msg: '参数传入不合法',
    }
    return false
  }
  const namespace = parmars.split('@')[0];
  const cluster = parmars.split('@')[1]
  let yaml = ''
  switch (cluster) {
    case 'qa':
      yaml = './../kubeService/kubeConfig-qa.yaml'
      break;
    case 'dev-ops':
      yaml = './../kubeService/kubeConfig-dev-ops.yaml'
      break
    case 'qke':
      yaml = './../kubeService/kubeConfig-qke.yaml'
      break
    default:
      ctx.body = {
        code: '0001',
        msg: '请选择集群的名字',
      }
  }
  const client = new Client({
    config: config.fromKubeconfig(
      path.resolve(__dirname, yaml),
    ),
    version: '1.10',
  })
  return { namespace, client }
}
module.exports = newClient
