const Router = require('koa-router')
const logger = require('koa-log4')
  .getLogger()
const _ = require('lodash')
const Redis = require('ioredis')

const redis = new Redis(6380, '172.30.220.22')
const { ingressCreate, ingressDelete } = require('../kubeService/ingress')
const { defaultConfig } = require('../resource/resourceLimit')
const {
  getPods,
  serviceCreate,
  getServicesFormat,
  getServices,
  getServiceDetail,
  serviceRestart,
  serviceDelete,
  imageUpdate,
  deployUpdate,
  replicaSetDelete,
  pvcDelete,
} = require('../kubeService/service')
const getClient = require('./../resource/getClient')
const awaitRequest = require('../utils/awaitRequest')

const router = new Router()
module.exports = router
const clientNew = {}
router.get('/', async (ctx) => {
  const data = await getServicesFormat(ctx.client, ctx.query.namespace)
  ctx.body = ctx.ok({
    services: data,
    namespace: ctx.query.namespace,
  })
})

// 资源限制
const makeResouce = async (serviceName, type) => {
  let resources = defaultConfig[type]

  const res = await awaitRequest({
    url: `http://127.0.0.1:3003/proconfig/getK8sConf?project_name=${serviceName}`,
    method: 'get',
  })
  const mongoResouces = JSON.parse(res.body).data
  if (mongoResouces && mongoResouces.memLimit) {
    resources = mongoResouces
  }

  return resources
}

// // 用于刷 mongo 库
// router.get('/insertData', async (ctx) => {
//   const res = await awaitRequest({
//     url: 'http://127.0.0.1:3003/proconfig/get_project?is_active=true',
//     method: 'get',
//   })
//   const data = JSON.parse(res.body).data
//   let ret
//   for (const item of data) {
//     const resources = projectConfig[item.project_name] || defaultConfig[item.type]
//     item.memRequest = resources.memory.request
//     item.memLimit = resources.memory.limit
//     item.cpuRequest = resources.cpu.request
//     item.cpuLimit = resources.cpu.limit
//     ret = await awaitRequest({
//       url: 'http://127.0.0.1:3003/proconfig/save',
//       method: 'POST',
//       headers: {
//         'Content-Type': 'application/json;charset=utf-8',
//       },
//       body: JSON.stringify(item),
//     })
//   }
//   ctx.body = ctx.ok(ret.body)
// })

const createService = async (ctx) => {
  const {
    type, serviceName, namespace, domain, label,
  } = ctx.request.body

  const data = ctx.request.body
  const resources = await makeResouce(serviceName, type)
  data.resources = resources

  logger.info('创建服务', data)
  await serviceCreate(ctx.cluterParams, ctx.client, data)
  if (label !== 'base') {
    if (serviceName === 'xyqb-user2') {
      await ingressCreate(ctx.client, namespace, 'xyqb-user2-2', 'passportapi2', ctx.cluterParams.clusterDomain)
    }
    await ingressCreate(ctx.client, namespace, serviceName, domain, ctx.cluterParams.clusterDomain)
  }
  ctx.body = ctx.ok('创建成功')
}

router.post('/create', async (ctx) => {
  await createService(ctx)
})

router.post('/details', async (ctx) => {
  ctx.validate(ctx.Joi.object()
    .keys({
      serviceName: ctx.Joi.string()
        .required(),
      namespace: ctx.Joi.string()
        .required(),
      type: ctx.Joi.string()
        .required(),
    }))

  const data = await getServiceDetail(ctx.client, ctx.request.body.namespace, ctx.request.body.serviceName, ctx.request.body.type)
  ctx.body = ctx.ok(data)
})
router.post('/delete', async (ctx) => {
  const { namespace, serviceName, podName } = ctx.request.body
  const key = `${namespace}:${podName}#${serviceName}`
  const res = await redis.get(key)
  await redis.del(key)
  if (res) {
    await redis.set(`copy${namespace}&${serviceName}`, res)
  }
  await serviceDelete(ctx.client, namespace, serviceName)
  await replicaSetDelete(ctx.client, namespace, serviceName)
  await pvcDelete(ctx.client, namespace, serviceName)

  // let rsData = await getReplicaSet(namespace)
  // rsData = rsData.map(item => item.metadata.name).filter(item => item.indexOf(serviceName) !== -1)
  // for (const rs of rsData) {
  //   await replicaSetDelete(namespace, rs)
  // }

  await ingressDelete(ctx.client, namespace, serviceName)
  if (serviceName === 'xyqb-user2') {
    await ingressDelete(ctx.client, namespace, 'xyqb-user2-2')
  }
  ctx.body = ctx.ok(`删除${serviceName}成功`)
})

router.post('/modifyImage', async (ctx) => {
  const data = ctx.request.body
  let list = await getPods(ctx.client, data.namespace)
  list = list.body.items.map(item => (item.metadata.labels && item.metadata.labels['qcloud-app']) || item.metadata.name)

  if (list.includes(data.serviceName)) {
    await imageUpdate(ctx.client, ctx.request.body)
  } else {
    await createService(ctx)
  }

  ctx.body = ctx.ok('更新成功')
})

router.post('/modifyDeploy', async (ctx) => {
  const data = ctx.request.body
  if (!data.label) {
    data.label = data.type
  }
  const resources = await makeResouce(data.serviceName, data.label)
  data.resources = resources
  await deployUpdate(ctx.cluterParams, ctx.client, data)
  // await deployUpdate(ctx.cluster, ctx.client, data)

  ctx.body = ctx.ok('更新成功')
})

router.post('/redeploy', async (ctx) => {
  const key = `${ctx.request.body.namespace}:${ctx.request.body.podName}#${ctx.request.body.serviceName}`
  const res = await redis.get(key)
  await redis.del(key)
  if (res) {
    await redis.set(`copy${ctx.request.body.namespace}&${ctx.request.body.serviceName}`, res)
  }
  await serviceRestart(ctx.client, ctx.request.body.namespace, ctx.request.body.podName)
  ctx.body = ctx.ok('重置服务成功')
})

// for dev
router.get('/listEnvVars', async (ctx) => {
  const envVars = {}
  let cluster;
  let namespace;
  const parmars = ctx.request.query.namespace || ''
  if (parmars.search('@') === -1) {
    cluster = 'qa'
    namespace = ctx.request.query.namespace
  } else {
    namespace = parmars.split('@')[0];
    cluster = parmars.split('@')[1]
  }
  if (!clientNew[cluster]) {
    clientNew[cluster] = await getClient(cluster)
  }
  const res = await Promise.all([
    getPods(clientNew[cluster], namespace),
    getServices(clientNew[cluster], namespace),
  ])

  res[0].body.items.forEach(async (item) => {
    const serviceName = (item.metadata.labels && item.metadata.labels['qcloud-app']) || item.metadata.name
    const upperCaseName = serviceName.toUpperCase()
      .replace(/-/g, '_')
    envVars[`${upperCaseName}_SERVICE_HOST`] = item.status.hostIP
  })

  res[1].body.items.forEach(async (item) => {
    const upperCaseName = item.metadata.name.toUpperCase()
      .replace(/-/g, '_')
    envVars[`${upperCaseName}_SERVICE_PORT`] = _.get(item.spec.ports, '[0].nodePort', undefined)
    item.spec.ports.forEach((i) => {
      envVars[`${upperCaseName}_SERVICE_PORT_${i.port}`] = i.nodePort || i.port
    })
  })

  envVars.DB_SERVICE_HOST = envVars.MYSQL_SERVICE_HOST
  envVars.DB_SERVICE_PORT = envVars.MYSQL_SERVICE_PORT
  envVars.DB_SERVICE_PORT_3306 = envVars.MYSQL_SERVICE_PORT_3306

  ctx.body = {
    details: envVars,
    success: true,
  }
})

// for container

router.get('/listEnvVarsNew', async (ctx) => {
  const envVars = {}
  let cluster;
  let namespace;
  const parmars = ctx.request.query.namespace || ''
  if (parmars.search('@') === -1) {
    cluster = 'qa'
    namespace = ctx.request.query.namespace
  } else {
    namespace = parmars.split('@')[0];
    cluster = parmars.split('@')[1]
  }
  if (!clientNew[cluster]) {
    clientNew[cluster] = await getClient(cluster)
  }
  const res = await Promise.all([
    getPods(clientNew[cluster], namespace),
    getServices(clientNew[cluster], namespace),
  ])

  res[0].body.items.forEach(async (item) => {
    const serviceName = (item.metadata.labels && item.metadata.labels['qcloud-app']) || item.metadata.name
    const upperCaseName = serviceName.toUpperCase()
      .replace(/-/g, '_')
    if (item.metadata.labels.type === 'base') {
      envVars[`${upperCaseName}_SERVICE_HOST`] = serviceName
    } else {
      envVars[`${upperCaseName}_SERVICE_HOST`] = item.status.hostIP
    }
  })

  res[1].body.items.forEach(async (item) => {
    const upperCaseName = item.metadata.name.toUpperCase()
      .replace(/-/g, '_')
    const type = item.metadata.labels.type
    if (type === 'base') {
      envVars[`${upperCaseName}_SERVICE_PORT`] = _.get(item.spec.ports, '[0].port', undefined)
      item.spec.ports.forEach((i) => {
        envVars[`${upperCaseName}_SERVICE_PORT_${i.port}`] = i.port
      })
    } else {
      envVars[`${upperCaseName}_SERVICE_PORT`] = _.get(item.spec.ports, '[0].nodePort', undefined)
      item.spec.ports.forEach((i) => {
        envVars[`${upperCaseName}_SERVICE_PORT_${i.port}`] = i.nodePort || i.port
      })
    }
  })

  envVars.DB_SERVICE_HOST = envVars.MYSQL_SERVICE_HOST
  envVars.DB_SERVICE_PORT = envVars.MYSQL_SERVICE_PORT
  envVars.DB_SERVICE_PORT_3306 = envVars.MYSQL_SERVICE_PORT_3306

  ctx.body = {
    details: envVars,
    success: true,
  }
})
