const Client = require('kubernetes-client').Client
const config = require('kubernetes-client').config
const awaitRequest = require('../../utils/awaitRequest')

module.exports = function client() {
  const client = {}
  const domain = {}
  return async function (ctx, next) {
    const exclude = [
      '/service/listEnvVarsNew',
      '/service/listEnvVars',
      '/service/insertData',
      '/cluster',
      '/repository',
      '/repository/getTags',
      '/repository/getNamespaceInfo',
    ]
    if (exclude.includes(ctx.path)) {
      await next()
    } else {
      const cluster = ctx.request.headers.cluster
      if (!client[cluster]) {
        // 请求qa-api
        const res = await awaitRequest({
          url: `http://qaapi.liangkebang.com/cluster/list?clusterName=${cluster}`,
          method: 'get',
        })
        const ca = JSON.parse(res.body).data[0]
        client[cluster] = new Client({
          config: config.fromKubeconfig(ca.clusterCA),
          version: '1.10',
        })
        let hosts = ''
        ca.hosts.forEach((item) => {
          hosts += `${item.value}&`
        })
        domain[`${cluster}domain`] = {
          clusterDomain: ca.clusterDomain,
          cluster: ca.clusterName,
          hosts,
        }
      }
      ctx.client = client[cluster]
      ctx.cluterParams = domain[`${cluster}domain`]
      await next()
    }
  }
}
