const schedule = require('node-schedule')
const request = require('request')
const moment = require('moment')
const Redis = require('ioredis')
const { podGetstatus, getPods } = require('../kubeService/service')
const getClient = require('../resource/getClient')

const clientNew = {}

const redis = new Redis(6380, '172.30.220.22')
const awaitRequest = function (options) {
  return new Promise((resolve, reject) => {
    request(options, (error, res, body) => {
      if (error) {
        reject(error)
      } else {
        resolve(body)
      }
    })
  })
}
const dingTalkPush = async function (item, is_recover) {
  // const key = `${item.metadata.namespace}:${item.metadata.name}#${item.metadata.labels['qcloud-app']}`
  let message
  let status
  switch (item.status.conditions.length) {
    case 1:
      message = item.status.conditions[0].reason
      break;
    case 2:
      break
    case 3:
      status = Object.keys(item.status.containerStatuses[0].state)[0]
      if (status === 'running') {
        message = '服务启动可能出现错误,请及时查看'
      } else {
        message = item.status.containerStatuses[0].state[status].reason
      }
      break;
    default:
      break
  }
  const dingData = is_recover ? {
    msgtype: 'markdown',
    markdown: {
      title: 'pipeline项目添加信息如下',
      text: '> 描述信息 : 腾讯云服务---恢复正常通知\n\n'
        + `> 项目名称 : ${item.metadata.labels['qcloud-app']}\n\n`
        + `> 项目类型 : ${item.metadata.labels.type}\n\n`
        + `> 命名空间 : ${item.metadata.namespace}\n\n`
        + `> 恢复时间 : ${moment()
          .format('YYYY-MM-DD HH:mm:ss')}\n\n`,
    },
  } : {
    msgtype: 'markdown',
    markdown: {
      title: 'pipeline项目添加信息如下',
      text: '> 描述信息 : 腾讯云服务---异常提醒通知\n\n'
        + `> 项目名称 : ${item.metadata.labels['qcloud-app']}\n\n`
        + `> 项目类型 : ${item.metadata.labels.type}\n\n`
        + `> 命名空间 : ${item.metadata.namespace}\n\n`
        + `> 异常原因 : ${message}\n\n`
        + `> 异常时间 : ${moment()
          .format('YYYY-MM-DD HH:mm:ss')}\n\n`
        + `[查看详情](http://qa2.liangkebang.com/dockers/runingEnv/${item.metadata.namespace})`,
    },
  };
  await awaitRequest({
    url: 'https://oapi.dingtalk.com/robot/send?access_token=473e49a1b6d4952e2306e0a8e530573384a6340052c40365a141b30757fd0997',
    method: 'POST',
    headers: {
      'Content-Type': 'application/json;charset=utf-8',
    },
    body: JSON.stringify(dingData),
  })
}
const checkRecoverPod = async () => {
  let stream = redis.scanStream({
    match: '*#*',
  });
  stream.on('data', async (resKeys) => {
    for (let i = 0; i < resKeys.length; i += 1) {
      const namespace = resKeys[i].split(':')[0]
      const podname = resKeys[i].split('#')[1]
      // 获取新的状态
      if (podname.indexOf(resKeys[i].split('#')[1]) > -1) {
        if (!clientNew.qa) {
          clientNew.qa = await getClient('qa')
        }
        const Pod = await getPods(clientNew.qa, namespace)
        Pod.body.items.forEach(async (item) => {
          if (item.metadata.name.indexOf(podname) > -1) {
            if (item.status.conditions.length === 3) {
              const c1 = item.status.conditions[0].status === 'True'
              const c2 = item.status.conditions[1].status === 'True'
              const c3 = item.status.conditions[2].status === 'True'
              if (c1 && c2 && c3) {
                const result = await redis.get(`copy${namespace}&${resKeys[i].split('#')[1]}`)
                const afterKey = await redis.get(resKeys[i])
                // 位置不可变 否则无法发送钉钉推送
                const flag = result || afterKey
                if (flag === 'send') {
                  dingTalkPush(item, true)
                  await redis.del(resKeys[i])
                  await redis.del(`copy${namespace}&${resKeys[i].split('#')[1]}`)
                } else {
                  await redis.del(resKeys[i])
                  await redis.del(`copy${namespace}&${resKeys[i].split('#')[1]}`)
                }
              }
            }
          }
        })
      }
    }
  })
  stream.on('end', () => {
    stream = null
  });
}
const checkErrorPod = async () => {
  if (!clientNew.qa) {
    clientNew.qa = await getClient('qa')
  }
  const listPods = await podGetstatus(clientNew.qa)
  listPods.body.items.forEach((item) => {
    const key = `${item.metadata.namespace}:${item.metadata.name}#${item.metadata.labels['qcloud-app']}`
    item.status.conditions.forEach(async (value) => {
      if (value.status !== 'True') {
        const res = await redis.get(key)
        if (res != null) {
          if (res === 'send') {
            // logger.info(item.metadata.name, ':已到达阈值并已发送钉钉提醒服务')
          } else {
            const counter = Number(res)
            if (counter > 5) {
              await redis.set(key, 'send')
              dingTalkPush(item, false)
            } else {
              await redis.set(key, counter + 1)
            }
          }
        } else {
          await redis.set(key, 1)
        }
      }
    })
  })
}
// checkRecoverPod()
// checkErrorPod()
const checkError = (cron) => {
  schedule.scheduleJob(cron, () => {
    checkErrorPod()
  })
}
const checkRecover = (cron) => {
  schedule.scheduleJob(cron, () => {
    checkRecoverPod()
  })
}
const flushAll = (cron) => {
  schedule.scheduleJob(cron, async () => {
    await redis.flushall()
  })
}
module.exports = {
  flushAll,
  checkError,
  checkRecover,
}
