const path = require('path')
const Client = require('kubernetes-client').Client
const config = require('kubernetes-client').config

module.exports = function getClient(cluster) {
  let yaml = ''
  switch (cluster) {
    case 'qa':
      yaml = './../kubeService/kubeConfig-qa.yaml'
      break;
    case 'dev-ops':
      yaml = './../kubeService/kubeConfig-dev-ops.yaml'
      break
    case 'qke':
      yaml = './../kubeService/kubeConfig-qke.yaml'
      break
    default:
      throw Error('未获取到Client')
  }
  return new Client({
    config: config.fromKubeconfig(
      path.resolve(__dirname, yaml),
    ),
    version: '1.10',
  })
}
