const logger = require('koa-log4').getLogger()

const getManifest = (namespace, servicename, doamin) => ({
  apiVersion: 'extensions/v1beta1',
  kind: 'Ingress',
  metadata: {
    name: servicename,
    namespace,
    annotations: {
      'kubernetes.io/ingress.class': 'traefik',
    },
  },
  spec: {
    rules: [
      {
        host: `${doamin}-${namespace}.liangkebang.net`,
        http: {
          paths: [
            {
              path: '/',
              backend: {
                serviceName: `${servicename}`.replace('-2', ''),
                servicePort: 80,
              },
            },
          ],
        },
      },
    ],
  },
})
const ingressGet = async (client, namespace, servicename) => client.apis.extensions.v1beta1.namespaces(namespace)
  .ingresses(servicename).get()

const ingressCreate = async (client, namespace, servicename, doamin) => {
  const Manifest = getManifest(namespace, servicename, doamin)
  logger.info('创建ingress', JSON.stringify(Manifest))
  await client.apis.extensions.v1beta1.namespace(namespace).ingresses
    .post({ body: Manifest })
}
const ingressUpdate = async (client, namespace, servicename, host) => {
  const Manifest = getManifest(namespace, servicename)
  Manifest.spec.rules[0].host = host
  logger.info('更新ingress', Manifest)
  await client.apis.extensions.v1beta1.namespace(namespace).ingresses(servicename)
    .patch({ body: Manifest })
}
const ingressDelete = async (client, namespace, servicename) => {
  logger.info('删除ingress', namespace, servicename)
  await client.apis.extensions.v1beta1.namespaces(namespace).ingresses(servicename).delete()
}
module.exports = {
  ingressGet,
  ingressCreate,
  ingressUpdate,
  ingressDelete,
}
