const schedule = require('node-schedule')
const logger = require('koa-log4').getLogger('dailySyncDB')
const {
  getServicesFormat, getAllNamespace,
} = require('../kubeService/service')
const getClient = require('../resource/getClient')
const awaitRequest = require('../utils/awaitRequest')
const sleep = require('../utils/sleep')
const APP_CONFIG = require('../config')
const dingTalk = require('../utils/dingTalk')

const syncDB = async (cluster) => {
  logger.info('dailySyncDB start')
  const client = (await getClient(cluster)).clientInfo
  const ns = await getAllNamespace(client)
  const summary = {}

  // // for test
  // const testNamespace = ['ai2', 'test1']
  // const nsTest = ns.namespaces && ns.namespaces.filter(item => testNamespace.includes(item.name))
  // for (const namespace of nsTest) {
  for (const namespace of ns.namespaces) {
    const svcs = await getServicesFormat(client, namespace.name)
    for (const svc of svcs) {
      if (svc.serviceName === 'mysql') {
        const latestDB = await awaitRequest({
          url: `${APP_CONFIG.qaapiHost}/proconfig/getLatestSvcDB?namespace=${namespace.name}&type=json`,
          method: 'get',
        })
        summary[namespace.name] = latestDB.data
        const data = {
          dbname: 'latest',
          mysqlName: 'mysql',
          namespace: namespace.name,
          not_delete_business_data: true,
          use_cache: true,
        }

        const res = await awaitRequest({
          url: `${APP_CONFIG.qaapiHost}/dbsync/tke`,
          method: 'post',
          body: JSON.stringify(data),
        })

        if (res.code === '0000') {
          logger.info('开始同步ns:', namespace.name, latestDB.data)
        } else {
          logger.info('同步ns失败:', namespace.name, res.data)
        }
        await sleep(60 * 1000)
        break
      }
    }
  }
  let text = ''
  for (const i in summary) {
    if (Object.prototype.hasOwnProperty.call(summary, i)) {
      if (summary[i].length) {
        text = `${text}${i} 同步的 latest svc db : ${summary[i].join('、')}\n\n`
      }
    }
  }
  dingTalk('daily latest db同步结果', text, APP_CONFIG.latestDingRobot)
  logger.info('dailySyncDB end')
}

module.exports = () => {
  // schedule.scheduleJob('*/2 * * * *', async () => {
  schedule.scheduleJob('50 7 * * *', async () => {
    try {
      await syncDB('qa')
    } catch (e) {
      logger.info('dailySyncDB', e)
    }
  });
}
