const schedule = require('node-schedule')
const _ = require('lodash')
const sleep = require('sleep')
const logger = require('koa-log4').getLogger('deployLatest')
const { serviceRestart, getServicesFormat, getAllNamespace } = require('../kubeService/service')
const container = require('../services/tke.containerService').create()
const getClient = require('../resource/getClient')

const repoNS = ['qa-java', 'qa-ui', 'qa-node', 'qa-python']
const testNamespace = ['qa', 'fe', 'data', 'fis', 'xyqb2']
const clientNew = {}

const deploy = async (cluster) => {
  if (!clientNew[cluster]) {
    clientNew[cluster] = await getClient(cluster)
  }
  logger.info('deployLatest start')
  for (const ns of repoNS) {
    const repoNSData = await container.repository_get(ns)
    for (const repo of repoNSData.repoInfo) {
      logger.info('开始检查仓库项目:', repo.reponame)
      const repoName = repo.reponame.split('/')[1]
      const latest = await container.getTagByName(repo.reponame, 'latest')
      const latestImageID = _.get(latest.tagInfo, '[0].tagId', '')
      let ns = await getAllNamespace(clientNew[cluster])
      ns = ns.namespaces && ns.namespaces.filter(item => testNamespace.includes(item.name))
      for (const namespace of ns) {
        const svcs = await getServicesFormat(clientNew[cluster], namespace.name)
        for (const svc of svcs) {
          if (svc.serviceName === repoName && svc.image.indexOf('latest') !== -1) {
            if (latestImageID !== svc.imageID.split('@')[1]) {
              logger.info('部署项目', namespace.name, svc.podName)
              await serviceRestart(clientNew[cluster], namespace.name, svc.podName)
              sleep.msleep(500)
            }
          }
        }
      }
      logger.info('仓库项目检查完毕:', repo.reponame)
    }
  }
  logger.info('deployLatest end')
}

module.exports = () => {
  // schedule.scheduleJob('*/2 * * * *', async () => {
  schedule.scheduleJob('0 2 * * *', async () => {
    try {
      await deploy('qa')
    } catch (e) {
      logger.info('deployLatest', e)
    }
  });
}
