const schedule = require('node-schedule')
const logger = require('koa-log4').getLogger('deleteTestSvc')
const {
  getServicesFormat, getAllNamespace,
} = require('../kubeService/service')
const getClient = require('../resource/getClient')
const dingTalk = require('../utils/dingTalk')
const APP_CONFIG = require('../config')

const deploy = async (cluster) => {
  logger.info('deleteTestSvc job start')
  const client = await getClient(cluster)
  const ns = await getAllNamespace(client.clientInfo)
  const summary = {}

  for (const namespace of ns.namespaces) {
    if (namespace.description === 'test') {
      logger.info('开始检查ns:', namespace.name)
      summary[namespace.name] = []
      const svcs = await getServicesFormat(client.clientInfo, namespace.name)
      for (const svc of svcs) {
        if (svc.labels.type !== 'base' && !~svc.image.indexOf('latest') && !~svc.image.search(':master-') && ~svc.createdAt.search('month')) {
          summary[namespace.name].push(svc.image.split('/')[2])
        }
      }
      logger.info('ns:', namespace.name, '检查完毕')
    }
  }

  let text = '早。以下测试分支已经一个月没有更新啦，请确认该服务是否还在使用，如无回复将会被删除\n\n'
  for (const i in summary) {
    if (Object.prototype.hasOwnProperty.call(summary, i)) {
      if (summary[i].length) {
        text = `${text}${i} : \n\n${summary[i].join('\n\n')}\n\n`
      }
    }
  }
  dingTalk('daily 闲置服务检查', text, APP_CONFIG.deleteTestSvcRobot)
  logger.info('deleteTestSvc job end')
}

module.exports = () => {
  // schedule.scheduleJob('*/2 * * * *', async () => {
  schedule.scheduleJob('59 9 * * 1-5', async () => {
    try {
      await deploy('qa')
    } catch (e) {
      logger.info('deleteTestSvc', e)
    }
  });
}
