const Client = require('kubernetes-client').Client
const config = require('kubernetes-client').config
const awaitRequest = require('../utils/awaitRequest')
const APP_CONFIG = require('../config')

const getClient = async function (cluster) {
  const res = await awaitRequest({
    url: `${APP_CONFIG.qaapiHost}/cluster/list?clusterName=${cluster}`,
    method: 'get',
  })
  const ca = res.data[0]

  const clientInfo = new Client({
    config: config.fromKubeconfig(ca.clusterCA),
    version: '1.10',
  })

  let hosts = ''
  ca.hosts.forEach((item) => {
    hosts += `${item.value}&`
  })
  const clusterInfo = {
    clusterDomain: ca.clusterDomain,
    cluster: ca.clusterName,
    hosts,
  }

  return {
    clientInfo,
    clusterInfo,
  }
}

const client = {}

module.exports = async function (cluster) {
  if (!client[cluster]) {
    client[cluster] = await getClient(cluster)
  }
  return client[cluster]
}
