const Router = require('koa-router')
const { ingressGet, ingressUpdate } = require('../kubeService/ingress')

const router = new Router();
module.exports = router

router.get('/', async (ctx) => {
  // const data = await ctx.cluster.ingress_get(ctx.query.namespace)
  const data = await ingressGet(ctx.query.namespace, ctx.query.serviceName)
  ctx.body = ctx.ok(data)
})

/**
namespace
rules
*/
router.post('/modify', async (ctx) => {
  const data = await ingressUpdate(ctx.request.body.namespace, ctx.request.body.serviceName, ctx.request.body.host)
  ctx.body = ctx.ok(data)
})
// router.post('/modify', async (ctx) => {
//   const ingress = await ctx.cluster.ingress_get(ctx.request.body.namespace)
//   if (!ingress) {
//     ctx.body = ctx.fail('namespace下没有ingress，请先创建')
//     return ctx.body
//   }
//   const data = await ctx.cluster.ingress_modify(ctx.request.body.ingressName, ctx.request.body.namespace, rules)
//   ctx.body = ctx.ok(data)
// })

router.post('/create', async (ctx) => {
  const ingress = await ctx.cluster.ingress_get(ctx.request.body.namespace)
  if (ingress) {
    ctx.body = ctx.fail('namespace下已存在ingress')
    return ctx.body
  }
  await ctx.cluster.ingress_create(ctx.request.body.namespace)
  ctx.body = ctx.ok()
})

router.post('/delete', async (ctx) => {
  await ctx.cluster.ingress_delete(ctx.request.body.ingressName, ctx.request.body.namespace)
  ctx.body = ctx.ok()
})
