const { describe, it } = require('mocha')
const { expect } = require('chai');
const request = require('request')
const app = require('./../app')

const awaitRequest = function (options) {
  return new Promise((resolve, reject) => {
    request(Object.assign(options, {
      headers: {
        'Content-Type': 'application/json;charset=utf-8',
        cluster: 'qa',
      },
    }), (error, res) => {
      if (error) {
        reject(error)
      } else {
        resolve(res)
      }
    })
  })
}
const namespace = 'monitor'


describe('test tke-eos api', () => {
  app.start(4000)
  /**
   * 获取所有的namespace
   */
  describe('test get all namespace URL->http://localhost:4000/namespace', () => {
    it('should return all namespace', async () => {
      const res = await awaitRequest({
        url: 'http://localhost:4000/namespace',
        method: 'GET',
      })
      expect(res.statusCode).to.equal(200)
    });
  })
  /**
   * 获取某个namespace下的所有服务
   */
  describe(`test get service URL->http://localhost:4000/service?namespace=${namespace}`, () => {
    it(`should return  service belong to namespace ${namespace}`, async () => {
      const res = await awaitRequest({
        url: `http://localhost:4000/service?namespace=${namespace}`,
        method: 'GET',
      })
      expect(res.statusCode).to.equal(200)
    });
  })
  /**
   * 获取镜像
   */
  describe('test get images URL->http://localhost:4000/repository', () => {
    const data = { namespace: 'qa-ui' }
    it('should return images list', async () => {
      const res = await awaitRequest({
        url: 'http://localhost:4000/repository',
        method: 'POST',
        headers: {
          'Content-Type': 'application/json;charset=utf-8',
        },
        body: JSON.stringify(data),
      })
      expect(res.statusCode).to.equal(200)
    });
  })

  /**
   * 获取镜像标签
   */
  describe('test get tag URL->http://localhost:4000/tag', () => {
    const data = { reponame: 'qa-ui/new-op-ui' }
    it('should return images list', async () => {
      const res = await awaitRequest({
        url: 'http://localhost:4000/tag',
        method: 'POST',
        headers: {
          'Content-Type': 'application/json;charset=utf-8',
        },
        body: JSON.stringify(data),
      })
      expect(res.statusCode).to.equal(200)
    });
  })

  /**
   * 创建服务
   */
  describe('test create service URL->http://localhost:4000/service/create', () => {
    const data = {
      debug: '"0"',
      domain: 'new-op',
      image: 'qa-ui/new-op-ui:latest',
      label: 'ui',
      mock: '0',
      namespace,
      serviceName: 'new-op-ui',
      type: 'ui',
      wechat: '"0"'
      ,
    }
    it('should return create service sucess', async () => {
      const res = await awaitRequest({
        url: 'http://localhost:4000/service/create',
        method: 'POST',
        headers: {
          'Content-Type': 'application/json;charset=utf-8',
        },
        body: JSON.stringify(data),
      })
      expect(res.statusCode).to.equal(200)
    });
  })

  describe('test details of a service URL->http://localhost:4000/service/details', async () => {
    const data = {
      namespace,
      serviceName: 'new-op-ui',
      type: 'ui',
    }
    it('should returns details of a service', async () => {
      const res = await awaitRequest({
        url: 'http://localhost:4000/service/details',
        method: 'POST',
        headers: {
          'Content-Type': 'application/json;charset=utf-8',
        },
        body: JSON.stringify(data),
      })
      expect(res.statusCode).to.equal(200)
    });
  })

  describe('test update a service URL->http://localhost:4000/service/modifyImage', async () => {
    const data = {
      namespace,
      serviceName: 'new-op-ui',
      type: 'ui',
      image: 'qa-ui/new-op-ui:latest',
    }
    it('should update a service', async () => {
      const res = await awaitRequest({
        url: 'http://localhost:4000/service/modifyImage',
        method: 'POST',
        headers: {
          'Content-Type': 'application/json;charset=utf-8',
        },
        body: JSON.stringify(data),
      })
      expect(res.statusCode).to.equal(200)
    });
  })

  describe('test redeploy a service URL->http://localhost:4000/service/redeploy', async () => {
    it('should redeploy a service', async () => {
      const data1 = {
        namespace,
        serviceName: 'new-op-ui',
        type: 'ui',
      }
      const res1 = await awaitRequest({
        url: 'http://localhost:4000/service/details',
        method: 'POST',
        headers: {
          'Content-Type': 'application/json;charset=utf-8',
        },
        body: JSON.stringify(data1),
      })
      const data = {
        namespace,
        podName: JSON.parse(res1.body).data.podName,
        serviceName: 'new-op-ui',
      }
      const res = await awaitRequest({
        url: 'http://localhost:4000/service/redeploy',
        method: 'POST',
        headers: {
          'Content-Type': 'application/json;charset=utf-8',
        },
        body: JSON.stringify(data),
      })
      expect(res.statusCode).to.equal(200)
    });
  })

  describe('test delete a service URL->http://localhost:4000/service/delete', async () => {
    it('should delete a service', async () => {
      const data1 = {
        namespace,
        serviceName: 'new-op-ui',
        type: 'ui',
      }
      const res1 = await awaitRequest({
        url: 'http://localhost:4000/service/details',
        method: 'POST',
        headers: {
          'Content-Type': 'application/json;charset=utf-8',
        },
        body: JSON.stringify(data1),
      })
      const data = {
        namespace,
        podName: JSON.parse(res1.body).data.podName,
        serviceName: 'new-op-ui',
      }
      const res = await awaitRequest({
        url: 'http://localhost:4000/service/delete',
        method: 'POST',
        headers: {
          'Content-Type': 'application/json;charset=utf-8',
        },
        body: JSON.stringify(data),
      })
      expect(res.statusCode).to.equal(200)
    });
  })
})
