const Router = require('koa-router')
const yaml = require('js-yaml')
const _ = require('lodash')
const logger = require('koa-log4').getLogger()

const templates = require('../serviceTemplate')
const lruCache = require('../services/lruCache.service')
const { ingressCreate, ingressDelete } = require('../kubeService/ingress')

const router = new Router()
module.exports = router

router.get('/', async (ctx) => {
  // 取节点列表的第一个作为服务的访问ip
  const cacheKey = 'k8s.nodes.first'
  let c = lruCache.get(cacheKey)
  let wanIp = lruCache.get(cacheKey)
  if (!c) {
    const res = await ctx.cluster.node_list()
    wanIp = _.get(res, 'nodes[0].wanIp', '')
    lruCache.set(cacheKey, wanIp)
  }

  const data = await ctx.cluster.service_list(ctx.query.namespace)
  const getDetail = async (item) => {
    let resData = await ctx.cluster.service_get(item.serviceName, ctx.query.namespace)
    item.portMappings = resData.service.portMappings
    item.image = resData.service.containers[0].image
    item.wanIp = wanIp
    return
  }
  const task = []
  for (let i = 0; i < data.services.length; i += 1) {
    if (data.services[i].userLabels.type === 'base') {
      task.push(getDetail(data.services[i]))
    }
  }
  await Promise.all(task)
  ctx.body = ctx.ok(data)
})

router.post('/create', async (ctx) => {
  const {
    type, serviceName, namespace, image, system_name, domain, label,
  } = ctx.request.body
  logger.info('创建服务', ctx.request.body)
  const data = {
    serviceName,
    namespace,
    image,
    system_name,
  }
  if (!system_name) {
    // ui abTest的时候不一样
    data.system_name = serviceName
  }

  const template = templates[type].replace(/{{([A-Za-z0-9_]+)}}/g, function () {
    if (data[arguments[1]] === undefined) {
      throw new Error(`缺少模板所需变量: ${arguments[1]}`)
    }
    return data[arguments[1]]
  })
  const params = yaml.load(template)
  await ctx.cluster.service_create(params, label)
  if (label !== 'base') {
    await ingressCreate(namespace, serviceName, domain)
  }
  ctx.body = ctx.ok('创建成功')
})
router.post('/details', async (ctx) => {
  const data = await ctx.cluster.service_get(ctx.request.body.serviceName, ctx.request.body.namespace)
  ctx.body = ctx.ok(data)
})
router.post('/delete', async (ctx) => {
  await ingressDelete(ctx.request.body.namespace, ctx.request.body.serviceName)
  await ctx.cluster.service_delete(ctx.request.body.serviceName, ctx.request.body.namespace)
  ctx.body = ctx.ok('删除成功')
})

router.post('/modifyImage', async (ctx) => {
  await ctx.cluster.service_modifyImage(ctx.request.body.serviceName, ctx.request.body.image, ctx.request.body.namespace)
  ctx.body = ctx.ok('更新成功')
})
router.post('/instance', async (ctx) => {
  const data = await ctx.cluster.instance_get(ctx.request.body.serviceName, ctx.request.body.namespace)
  ctx.body = ctx.ok(data)
})
router.post('/redeploy', async (ctx) => {
  await ctx.cluster.service_redeployment(ctx.request.body.serviceName, ctx.request.body.namespace)
  ctx.body = ctx.ok('服务重部署成功')
})
