const defaultMysql = {
  memory: {
    request: 1024,
    limit: 1024,
  },
  cpu: {
    request: 200,
    limit: 2000,
  },
}

const defaultRabbitmq = {
  memory: {
    request: 1500,
    limit: 1500,
  },
  cpu: {
    request: 100,
    limit: 200,
  },
}

const defaultZookeeper = {
  memory: {
    request: 300,
    limit: 300,
  },
  cpu: {
    request: 100,
    limit: 200,
  },
}

const defaultRedis = {
  memory: {
    request: 100,
    limit: 100,
  },
  cpu: {
    request: 100,
    limit: 200,
  },
}

const defaultUI = {
  cpuLimit: 10,
  cpuRequest: 100,
  memLimit: 50,
  memRequest: 50,
}

const defaultNodejs = {
  cpuLimit: 20,
  cpuRequest: 200,
  memLimit: 200,
  memRequest: 240,
}

const defaultPython = {
  cpuLimit: 20,
  cpuRequest: 200,
  memLimit: 200,
  memRequest: 240,
}

const defaultJava = {
  cpuLimit: 100,
  cpuRequest: 1000,
  memLimit: 500,
  memRequest: 600,
}

exports.defaultConfig = {
  redis: defaultRedis,
  'redis-sentinel': defaultRedis,
  zookeeper: defaultZookeeper,
  mysql: defaultMysql,
  rabbitmq: defaultRabbitmq,
  java: defaultJava,
  ui: defaultUI,
  node: defaultNodejs,
  python: defaultPython,
}
