const Router = require('koa-router')
const logger = require('koa-log4').getLogger()

const { ingressCreate, ingressDelete } = require('../kubeService/ingress')
const { projectConfig, defaultConfig } = require('../serviceTemplate/resourceLimit')
const {
  getPods,
  serviceCreate,
  getServices,
  getServiceDetail,
  serviceRestart,
  serviceDelete,
  imageUpdate,
  getReplicaSet,
  replicaSetDelete,
} = require('../kubeService/service')

const router = new Router()
module.exports = router

router.get('/', async (ctx) => {
  const data = await getServices(ctx.query.namespace)
  ctx.body = ctx.ok({ services: data })
})

const makeResouce = (serviceName, type) => {
  // 资源限制
  const resources = projectConfig[serviceName] || defaultConfig[type]
  logger.info('资源限制', JSON.stringify(resources))
  return resources
}

const createService = async (ctx) => {
  const {
    type, serviceName, namespace, domain, label,
  } = ctx.request.body

  const data = ctx.request.body
  const resources = makeResouce(serviceName, type)
  data.resources = resources

  logger.info('创建服务', data)
  await serviceCreate(data)
  if (label !== 'base') {
    if (serviceName === 'xyqb-user2') {
      await ingressCreate(namespace, 'xyqb-user2-2', 'passportapi2')
    }
    await ingressCreate(namespace, serviceName, domain)
  }
  ctx.body = ctx.ok('创建成功')
}

router.post('/create', async (ctx) => {
  await createService(ctx)
})

router.post('/details', async (ctx) => {
  ctx.validate(ctx.Joi.object().keys({
    serviceName: ctx.Joi.string().required(),
    namespace: ctx.Joi.string().required(),
  }))

  const data = await getServiceDetail(ctx.request.body.namespace, ctx.request.body.serviceName)
  ctx.body = ctx.ok(data)
})

router.post('/delete', async (ctx) => {
  const { namespace, serviceName } = ctx.request.body
  await serviceDelete(namespace, serviceName)

  // const rsName = ctx.request.body.podName.slice(0, -6)
  let rsData = await getReplicaSet(namespace)
  rsData = rsData.map(item => item.metadata.name).filter(item => item.indexOf(serviceName) !== -1)
  for (const rs of rsData) {
    await replicaSetDelete(namespace, rs)
  }

  if (ctx.request.body.serviceName === 'xyqb-user2') {
    await ingressDelete(ctx.request.body.namespace, 'xyqb-user2-2')
  }
  await ingressDelete(ctx.request.body.namespace, ctx.request.body.serviceName)
  ctx.body = ctx.ok('删除成功')
})

router.post('/modifyImage', async (ctx) => {
  let list = await getPods(ctx.request.body.namespace)
  list = list.map(item => (item.metadata.labels && item.metadata.labels['qcloud-app']) || item.metadata.name)

  if (list.includes(ctx.request.body.serviceName)) {
    logger.info('更新服务', ctx.request.body)
    await imageUpdate(ctx.request.body)

    // const data = ctx.request.body
    // if (!data.label) {
    //   data.label = data.type
    // }
    // const resources = makeResouce(data.serviceName, data.label)
    // data.resources = resources
    // logger.info('更新服务', data)
    // await serviceUpdate(data)
  } else {
    await createService(ctx)
  }

  ctx.body = ctx.ok('更新成功')
})

router.post('/redeploy', async (ctx) => {
  await serviceRestart(ctx.request.body.namespace, ctx.request.body.podName)
  ctx.body = ctx.ok('重置服务成功')
})
