const path = require('path')
const Client = require('kubernetes-client').Client
const config = require('kubernetes-client').config

module.exports = function client() {
  const client = {}
  return async function (ctx, next) {
    const cluster = ctx.request.headers.cluster
    let yaml = ''
    switch (cluster) {
      case 'qa':
        yaml = './../../kubeService/kubeConfig-qa.yaml'
        break
      case 'dev-ops':
        yaml = './../../kubeService/kubeConfig-dev-ops.yaml'
        break
      default:
        ctx.body = {
          code: '0001',
          msg: '请选择集群的名字',
        }
        return
    }
    if (!client[cluster]) {
      client[cluster] = new Client({
        config: config.fromKubeconfig(
          path.resolve(__dirname, yaml),
        ),
        version: '1.10',
      })
    }
    ctx.client = client[cluster]
    await next()
  }
}
