const Koa = require('koa')
const Router = require('koa-router')
const bodyParser = require('koa-bodyparser')
const log4js = require('koa-log4')
const { flushAll, checkError, checkRecover } = require('./schedule')
const logConf = require('../config/logger')
const error = require('../middleware/error')
const result = require('../middleware/result')
const validate = require('../middleware/validate')

const namespaceRoute = require('./namespace')
const serviceRoute = require('./service')
const repositoryRouter = require('./repository')
const tag = require('./tag')
const ingressRoute = require('./ingress')
const deploy = require('./restartLatest')
const client = require('../middleware/client')

const logFormat = ':req[x-real-ip] :req[x-forwarded-for] - -'
  + ' ":method :url HTTP/:http-version"'
  + ' :status :content-length ":referrer"'
  + ' ":user-agent" :req[x-auth-token] :response-timems'

// const cluster = require('../services/tke.clusterService').create()
const container = require('../services/tke.containerService').create()

const logger = log4js.getLogger()
log4js.configure(logConf.devlog)
function loadRoutes(router) {
  router
    .use(error())
    .use(result())
    .use(validate())
    .use(client())
    .use(async (ctx, next) => {
      // 腾讯云
      ctx.container = container
      // ctx.cluster = cluster
      await next()
    }, bodyParser())

    .use('/namespace', namespaceRoute.routes())
    .use('/service', serviceRoute.routes())
    .use('/ingress', ingressRoute.routes())
    .use('/repository', repositoryRouter.routes())
    .use('/tag', tag.routes())
}

exports.start = function (port) {
  // 加载各种服务
  const app = new Koa()
  const router = new Router()
  checkError('0 */2 * * * ?')
  checkRecover('0 */1 * * * ?')
  flushAll('0 0 9 * * ?')
  // 加载所有路由
  loadRoutes(router)
  deploy()
  app.use(log4js.koaLogger(log4js.getLogger('http'), { level: 'auto', format: logFormat }))
  app.use(router.routes())
  app.listen(port)
  logger.info('server listening 4000')
  logger.info('加载环境配置: ', process.env.NODE_ENV)
}
