const Router = require('koa-router')

const router = new Router();
module.exports = router

router.get('/', async (ctx) => {
  const data = await ctx.client.ingress_get(ctx.query.namespace)
  ctx.body = ctx.ok(data)
})

/**
namespace
rules
*/
router.post('/modify', async (ctx) => {
  const ingress = await ctx.client.ingress_get(ctx.request.body.namespace)
  if (!ingress) {
    ctx.body = ctx.fail('namespace下没有ingress，请先创建')
    return ctx.body
  }
  console.log(1, ingress)
  // let data = await ctx.client.ingress_modify()
  ctx.body = ctx.ok(ingress)
})

router.post('/create', async (ctx) => {
  const ingress = await ctx.client.ingress_get(ctx.request.body.namespace)
  if (ingress) {
    ctx.body = ctx.fail('namespace下已存在ingress')
    return ctx.body
  }
  await ctx.client.ingress_create(ctx.request.body.namespace)
  ctx.body = ctx.ok()
})

router.post('/delete', async (ctx) => {
  await ctx.client.ingress_delete(ctx.request.body.ingressName, ctx.request.body.namespace)
  ctx.body = ctx.ok()
})
